package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade.ExploreParamsV2;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;

public class AdjustPrice {

    public static List<AdjPriceResult> adjustFactor(List<AdjPriceInfo> exploreInfos,
                                      ExploreParamsV2 exploreParams) {

        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
        List<Double>  exploreLevel = exploreParams.getExploreLevel();
        double biasWeight = exploreParams.getBiasWeight();

        Double[] biasBucket1 = new Double[biasBucket.size()];
        Double[] factorBucket1 = new Double[factorBucket.size()];
        biasBucket1 = biasBucket.toArray(biasBucket1);
        factorBucket1 = factorBucket.toArray(factorBucket1);

        Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
        Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);
        Double[] exploreLevelBucket = exploreLevel.toArray(new Double[exploreLevel.size()]);
        Double[] finalBiasBucket = biasBucket1;
        Double[] finalFactorBucket = factorBucket1;
        return exploreInfos.stream().map(info ->
                adjustFactor(info, finalBiasBucket, finalFactorBucket,
                        expbiasBucket1, expFactorBucket1, exploreLevelBucket, biasWeight)).collect(Collectors.toList());
    }

    /**
     * 加价接口2
     */
    public static AdjPriceResult adjustFactor(AdjPriceInfo adjPriceInfo,
                                              Double[] biasBucket,
                                              Double[] factor,
                                              Double[] expBiasBucket,
                                              Double[] expFactor,
                                              Double[] exploreLevelBucket,
                                              Double biasWeight) {
        AdjPriceResult adjPriceResult = new AdjPriceResult();
        adjPriceResult.setOrientId(adjPriceInfo.getOrientId());
        double f = 1.0;
        if (!AssertUtil.isAnyEmpty(
                adjPriceInfo.getAppAdvertInfo(),
                adjPriceInfo.getAppAccountInfo())) {
            //配置成本
            long consume = adjPriceInfo.getOrientOcpcConsume();//消耗
            long conv = adjPriceInfo.getOrientConv().getOrDefault(adjPriceInfo.getConvertType(), 0L);//转化
            double cost = conv >= 5 ? division(division(consume, conv), adjPriceInfo.getTarget()) : 1.0;

            double f1 = getConfidenceWeight(cost, biasBucket, factor, 1.0);

            //拓量成本
            double exploreCost = 1.0;
            if(adjPriceInfo.getOrientExpCost() != null && adjPriceInfo.getOrientExpCost().getExploreAdjConsume() > 3000) {
                exploreCost = division(adjPriceInfo.getOrientExpCost().getExploreConsume(),
                        adjPriceInfo.getOrientExpCost().getExploreAdjConsume());
            }else if(adjPriceInfo.getAppAdvertInfo().getConsume() != null &&
                    adjPriceInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() != null &&
                    adjPriceInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() > 5000) {
                exploreCost = division(adjPriceInfo.getAppAdvertInfo().getConsume().getExploreConsume(),
                        adjPriceInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume());
            }else if(adjPriceInfo.getAppAccountInfo().getConsume() != null &&
                    adjPriceInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() != null &&
                    adjPriceInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() > 5000){
                exploreCost = division(adjPriceInfo.getAppAccountInfo().getConsume().getExpConsume(),
                        adjPriceInfo.getAppAccountInfo().getConsume().getExploreAdjConsume());
            }else{
                biasWeight = 1.0;
            }

            double f2 = getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);

            f = biasWeight * f1 + (1 - biasWeight) * f2;

            // 根据参竞失败率调整加价系数
            double ratio = (double) adjPriceInfo.getAppAdvertInfo().getAppAdExpCnt() /
                    adjPriceInfo.getAppAdvertInfo().getAppAdBidCnt();

            for (int i=0; i < exploreLevelBucket.length; i++) {
                if (ratio < exploreLevelBucket[i]) {
                    f -= i * 0.05;
                }
            }
            if (ratio > exploreLevelBucket[exploreLevelBucket.length-1]) {
                f -= exploreLevelBucket.length * 0.05;
            }

        }
        adjPriceResult.setExpAdjustFactor(f);
        return adjPriceResult;
    }


    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {

            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }



    public static void main(String[] args) {

    }


}
