package cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import cn.com.duiba.nezha.alg.common.model.advertexplore.explore.*;
import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;


public class AdvertExploreV2 {


    private static final Logger logger = LoggerFactory.getLogger(AdvertExploreV2.class);


    public static Set<ExploreResultV2> exploreV2(Set<ExploreInfoV2> exploreInfos,
                                               ExploreParamsV2 exploreParams) {

        if (AssertUtil.isAnyEmpty(exploreInfos, exploreParams)) {
            return null;
        }

        if (Math.random() < 0.0001) {
            logger.info("params AdvertExplore2:{}", exploreParams.toString());
        }

        Long appAdCnt = exploreParams.getAppAdCnt();//媒体广告发券量级
        Double expratio = exploreParams.getExpratio();//探索消耗占比

        Long clkCnt1 = exploreParams.getClkCnt1();
        Long convCnt1 = exploreParams.getConvCnt1();

        Long clkCnt2 = exploreParams.getClkCnt2();
        Long convCnt2 = exploreParams.getConvCnt2();

        Double bias1 = exploreParams.getBias1();
        Double bias2 = exploreParams.getBias2();
        Double bias3 = exploreParams.getBias2();
        Double ctrTrendLimit = exploreParams.getCtrBiasTrend();
        Double cvrTrendLimit = exploreParams.getCvrBiasTrend();


        Set<ExploreResultV2> resList= new HashSet<>();

        for (ExploreInfoV2 info : exploreInfos){
            ExploreResultV2 res = new ExploreResultV2(info.advertId,info.convertType);
            //探索消耗达到10%
            double exploreRatio = division(info.adExpConsume,info.adOcpcConsume);

            if (exploreRatio > expratio || info.appAdExpCnt > appAdCnt) { //发券达到一定量级
                res.stopExp = 1;
            } else {
                double ctrBias = getCtrBias(info);
                double cvrBias = getCvrBias(info);

                if(info.appAdConv.clickCnt <= clkCnt1 || info.appAdConv.convCnt <= convCnt1){
                    res.stopExp = 0;
                } else if(info.appAdConv.clickCnt > clkCnt2 && ctrBias > bias1){
                    res.stopExp =2;
                } else if(info.appAdConv.convCnt > convCnt2 && cvrBias > bias1){
                    res.stopExp =2;
                } else {
                    Long convType = info.convertType;
                    double ctrTrend = getBiasTrend(info.appAdCtrFeature, convType,true);
                    double cvrTrend = getBiasTrend(info.appAdCvrFeature, convType,false);
                    if (ctrBias <= bias2 && cvrBias <= bias2) {
                        res.stopExp = 3;
                    }else if (ctrBias <= bias3 && cvrBias <= bias3 && ctrTrend < ctrTrendLimit && cvrTrend < cvrTrendLimit) {
                        res.stopExp = 3;
                    }else {
                        res.stopExp = 0;
                    }
                }
            }
            resList.add(res);
        }
        return resList;
    }

    public static double getCtrBias (ExploreInfoV2 info) {

        double clk = division(info.adClickCnt * 100,info.adExpoCnt);
        double ctr = division(info.appAdConv.clickCnt + clk,info.appAdConv.expCnt+100);
        double ctrBias = division(ctr,info.appAdConv.preCtrSum);

        if(info.appAdConv.clickCnt >= 50) {
            ctr = division(info.appAdConv.clickCnt,info.appAdConv.expCnt);
            ctrBias = division(ctr,info.appAdConv.preCtrSum);
        }

        return ctrBias;
    }

    public static double getCvrBias (ExploreInfoV2 info) {
        double conv = division(info.adConvCnt * 100,info.adClickCnt);
        double cvr = division(info.appAdConv.convCnt + conv,info.appAdConv.clickCnt+100);
        double cvrBias = division(cvr,info.appAdConv.preCtrSum);

        if(info.appAdConv.convCnt >= 10) {
            cvr = division(info.appAdConv.convCnt, info.appAdConv.clickCnt);
            cvrBias = division(cvr, info.appAdConv.preCvrSum);
        }
        return cvrBias;
    }

    public static double getBiasTrend (AppAdvertResult appAdFeature,Long convType,boolean ctr) {
        double biasTrend = 99.0;
        if (AssertUtil.isAnyEmpty(appAdFeature, convType)) {
            return biasTrend;
        }

        Long exp5 = 0L;
        Long clk5 = 0L;
        Double prectr5 = 0.0;
        Double precvr5 = 0.0;
        Long exp10 = 0L;
        Long clk10 = 0L;
        Double prectr10 = 0.0;
        Double precvr10 = 0.0;
        Long exp15 = 0L;
        Long clk15 = 0L;
        Double prectr15 = 0.0;
        Double precvr15 = 0.0;
        try {
            AppAdvertDo appAdvertDo5 = appAdFeature.getAppAdvertDo5();
            exp5 = appAdvertDo5.getExpCnt().get(convType);
            clk5 = appAdvertDo5.getChargeCnt().get(convType);
            prectr5 = appAdvertDo5.getPreCtr().get(convType);
            precvr5 = appAdvertDo5.getPreCvr().get(convType);
        } catch (Exception e) {
            logger.info("getBiasTrend方法有空值：{}",e);
        }
        try {
            AppAdvertDo appAdvertDo10 = appAdFeature.getAppAdvertDo10();
            exp10 = appAdvertDo10.getExpCnt().get(convType);
            clk10 = appAdvertDo10.getChargeCnt().get(convType);
            prectr10 = appAdvertDo10.getPreCtr().get(convType);
            precvr10 = appAdvertDo10.getPreCvr().get(convType);
        } catch (Exception e) {
            logger.info("getBiasTrend方法有空值：{}",e);

        }
        try {
            AppAdvertDo appAdvertDo15 = appAdFeature.getAppAdvertDo15();
            exp15 = appAdvertDo15.getExpCnt().get(convType);
            clk15 = appAdvertDo15.getChargeCnt().get(convType);
            prectr15 = appAdvertDo15.getPreCtr().get(convType);
            precvr15 = appAdvertDo15.getPreCvr().get(convType);
        } catch (Exception e) {
            logger.info("getBiasTrend方法有空值：{}",e);

        }

        if(ctr == true && prectr15 > 0.0 && prectr10 > 0.0) {
            biasTrend = 0.5*(prectr10 / prectr15 + prectr5 / prectr10);
        } else if(clk15*precvr15*exp10 > 0.0 && clk10*precvr10*exp5 > 0.0) {
            biasTrend = 0.5*((exp15*clk10*precvr10) / (clk15*precvr15*exp10)
                    + (exp10*clk5*precvr5) / (clk10*precvr10*exp5));
        }

        return biasTrend;

    }



    public static void main(String[] args) {

    }


}
