package cn.com.duiba.nezha.alg.common.model.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.junit.Test;

public class PidController {

    private double P;
    private double I;
    private double I2;
    private double D;
    private static double LEARNING_RATE = 0.3;


    public PidController() {
        P = 1.0;
        I = 0.3;
        I2 = 0.01;
        D = 0.;
    }

    public double runPid(double target, double actual, double actualSum) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum);
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }

    public double runPid(double target, double actual, double actualSum, double factor) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum);
        signal = LEARNING_RATE * error;

        double range = getRange(factor);
        signal = MathUtil.stdwithBoundary(signal, -1 * range, range);
        return signal;
    }


    public double runPid(double target, double actual) {

        double error = 0;
        double signal = 0;

        error = P * (target - actual) / target;

        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.2, 0.2);

        return signal;
    }




    private double getRange(double factor) {

        double ret = 0.05;

        if (factor > 1.2) {
            ret = 0.05 + (factor - 1) * 0.2;
        }

        if (factor < 1.2) {
            ret = 0.05 + Math.abs(1 - factor) * 0.05;
        }

        return ret;
    }

    public double runPid2(double target, double actual, double actualSum, double actualSum2) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum) + I2 * (target - actualSum2) ;

        signal = DataUtil.division(LEARNING_RATE * error, target, 3);

        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }



}
