package cn.com.duiba.nezha.alg.common.model.activityselectconversionforms;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import junit.framework.TestCase;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivitySelectorPoolTest extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println();
    }

    public void testBayesianBandit() throws Exception {
        String Path = "/Users/lijingzhe/codes/duiba_sql/activityIds";
        String laststr = readInline(Path);
        JSONArray jsonArray = JSON.parseArray(laststr);
        List<ActivityData> actDs = new ArrayList<>();
        List<ActivityModel> actMs = new ArrayList<>();
        for (int i = 0; i < jsonArray.size(); i++) {
            ActivityData actD = jsonArray.getJSONObject(i).toJavaObject(ActivityData.class);
            actDs.add(actD);
            ActivityModel actM = new ActivityModel();
            actM.slotId = actD.slotId;
            actM.activityId = actD.activityId;
            actM.appId = actD.appId;
            actMs.add(actM);
        }

        //单元测试
        Map<Long,Integer> map = new HashMap<>();
        Map<Integer,Integer> sMap = new HashMap<>();
        ActivityModel result=new ActivityModel();
        for (int i=0;i<10000;i++) {
            SelectActivityResult ret = ActivitySelectorPoolCvr.select(actMs, actDs);
//            System.out.println(i + " select result:" + ret.activityModel.toString());
//            sMap.put(ret.activityModel.strategyType,sMap.getOrDefault(ret.activityModel.strategyType,0) + 1);
            map.put(ret.activityModel.activityId, map.getOrDefault(ret.activityModel.activityId,0) + 1);
        }

//        System.out.println(sMap);
        System.out.println(map);
    }

    public static String readInline(String Path){
        //读取本地模拟文件
        BufferedReader reader = null;
        String laststr = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(Path);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr += tempString;
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return laststr;
    }
}
