package cn.com.duiba.nezha.alg.common.model.adjustprice;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;

public class AdjustPrice {

//    public static List<ExploreResultV2> adjustFactor(List<ExploreInfo> exploreInfos,
//                                      ExploreParams exploreParams) {
//
//        List<Double> biasBucket = exploreParams.getBiasBucket();
//        List<Double> factorBucket = exploreParams.getFactorBucket();
//        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
//        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
//        List<Double> bidRatioBucket = exploreParams.getExpBiasBucket();
//        List<Double> bidFactorBucket = exploreParams.getExpFactorBucket();
//
//        double biasWeight = exploreParams.getBiasWeight();
//
//        Double[] finalBiasBucket = biasBucket.toArray(new Double[biasBucket.size()]);
//        Double[] finalFactorBucket = factorBucket.toArray(new Double[factorBucket.size()]);
//
//        Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
//        Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);
//
//        Double[] bidRatioBucket1 = bidRatioBucket.toArray(new Double[bidRatioBucket.size()]);
//        Double[] bidFactorBucket1 = bidFactorBucket.toArray(new Double[bidFactorBucket.size()]);
//
//        return exploreInfos.stream().map(info ->
//                adjustFactor(info, finalBiasBucket, finalFactorBucket,
//                        expbiasBucket1, expFactorBucket1,
//                        bidRatioBucket1, bidFactorBucket1,biasWeight)).collect(Collectors.toList());
//    }

    /**
     * 加价接口2
     */
    public static double adjustFactor(ExploreInfo exploreInfo,
                                       Double[] biasBucket,
                                       Double[] factor,
                                       Double[] expBiasBucket,
                                       Double[] expFactor,
                                       Double[] bidRatioBucket,
                                       Double[] bidFactor,
                                       Double biasWeight,
                                       Double limitFactor) {
//        ExploreResultV2 adjPriceResult = new ExploreResultV2(exploreInfo.getAdvertId(),exploreInfo.getOrientationId());
//        adjPriceResult.setScoreMap(exploreInfo.getScoreMap());
        double finalF = 1.0;
        if (!AssertUtil.isAnyEmpty(
                exploreInfo.getAppAdvertInfo(),
                exploreInfo.getAppAccountInfo())) {
            //配置成本
            long consume = exploreInfo.getOrientOcpcConsume();//消耗
            long conv = exploreInfo.getOrientConv().getOrDefault(exploreInfo.getConvertType(), 0L);//转化
            double cost = conv >= 5 ? division(division(consume, conv), exploreInfo.getTarget()) : 1.0;

            double f1 = getConfidenceWeight(cost, biasBucket, factor, 1.0);

            //拓量成本
            double exploreCost = 1.0;
            if(exploreInfo.getOrientExpCost() != null && exploreInfo.getOrientExpCost().getExploreAdjConsume() > 3000) {
                exploreCost = AdExploreUcb.division(exploreInfo.getOrientExpCost().getExploreConsume(),
                        exploreInfo.getOrientExpCost().getExploreAdjConsume());
            }else if(exploreInfo.getAppAdvertInfo().getConsume() != null &&
                    exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() != null &&
                    exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() > 5000) {
                exploreCost = AdExploreUcb.division(exploreInfo.getAppAdvertInfo().getConsume().getExploreConsume(),
                        exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume());
            }else if(exploreInfo.getAppAccountInfo().getConsume() != null &&
                    exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() != null &&
                    exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() > 5000){
                exploreCost = AdExploreUcb.division(exploreInfo.getAppAccountInfo().getConsume().getExpConsume(),
                        exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume());
            }else{
                biasWeight = 1.0;
            }

            double f2 = getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);

            double f = biasWeight * f1 + (1 - biasWeight) * f2;

            double ratio = division(exploreInfo.getAppAdvertInfo().getAppAdExpCnt(),exploreInfo.getAppAdvertInfo().getAppAdBidCnt());
            // TO DO：根据参竞失败率调整加价系数

            double f3 = getConfidenceWeight(ratio, bidRatioBucket, bidFactor, 1.0);

            finalF = f * f3;
            finalF = Math.max(Math.min(finalF,limitFactor),1.0);

        }
//        Map<Integer,Double> scoreMap = exploreInfo.getScoreMap();
//        scoreMap.put(4,finalF);
//        adjPriceResult.setScoreMap(scoreMap);
//        adjPriceResult.setExpAdjustFactor(finalF);
        return finalF;
    }


    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {

            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }


}
