package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

import java.util.ArrayList;
import java.util.HashMap;

class ConsumePIDController {
    //抄知乎上的pid控制出价的策略https://zhuanlan.zhihu.com/p/265215568
    //基于消耗的绝对值做控制，省得琢磨各种率置信不置信的问题

    public static WeightInfo calcControlFactor(ExpHourData expHourData,
                                        Double upperBound, Double lowerBound,
                                        Double kp, Double ki, WeightDimEnum dim) {

        HourDto lastHourDto=expHourData.getHourDtoMap().get(expHourData.getLastHour());
        double errorCurrent=errorDiff(lastHourDto);
        double errorIntegral=errorIntegral(expHourData);
        double kt=kp*errorCurrent+ki*errorIntegral;
        double unboundK=responseFunc(kt);
        double k=bound(unboundK,upperBound,lowerBound);
        return new WeightInfo(dim.getId(), 0L, DataUtil.formatDouble(errorCurrent, 5),
                DataUtil.formatDouble(k, 5));
    }

    //差分形式算偏差
    private static double errorDiff(HourDto lastHourDto) {
        double result = (lastHourDto.getAFee() - lastHourDto.getOcpcChargeFees());
        return result;
    }

    //累计偏差
    private static double errorIntegral(ExpHourData expHourData) {
        double result=0.0;
        for (HourDto hourDto : expHourData.getHourDtoMap().values()) {
            result=result+hourDto.getAFee()-hourDto.getOcpcChargeFees();
        }
        return result;
    }

    //响应函数
    private static double responseFunc(double kt) {
        return Math.exp(kt);
    }

    private static double bound(Double value,Double upperBound,Double lowerBound) {
        if(value>upperBound) {
            return upperBound;
        }
        else if (value<lowerBound) {
            return lowerBound;
        }
        else {
            return value;
        }
    }
}
