package cn.com.duiba.nezha.alg.common.util;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lijicong
 * @since 2021-09-03
 */
@Slf4j
public abstract class TypeKit {

    private static final Map<Class<?>, Type[]> cache = new ConcurrentHashMap<>();

    /**
     * 获取泛型子类的真实类型
     * @param clazz
     * @return
     */
    @SuppressWarnings("unchecked")
    public static Type[] getActualTypes(Class<?> clazz) {
        return cache.computeIfAbsent(clazz, k -> ((ParameterizedType) clazz.getGenericSuperclass()).getActualTypeArguments());
    }

    /**
     * 获取泛型子类的真实类型
     * @param clazz
     * @param typeIndex
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> Class<T> getActualType(Class<?> clazz, int typeIndex) {
        Type[] actualTypeArray = getActualTypes(clazz);
        if (typeIndex > actualTypeArray.length - 1) {
            return null;
        }
        Type actualType = actualTypeArray[typeIndex];
        if (actualType instanceof Class) {
            return (Class<T>) actualType;
        }
        return null;
    }

    /**
     * 实例化对象
     * @param clazz
     * @param typeIndex
     * @param <T>
     * @return
     */
    public static <T> T newActualInstance(Class<?> clazz, int typeIndex) {
        try {
            Class<T> actualClazz = getActualType(clazz, typeIndex);
            if (actualClazz != null) {
                return actualClazz.newInstance();
            }
        } catch (Exception e) {
            log.error("获取真实类型实例化异常", e);
        }
        return null;
    }

}
