package cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade;

import cn.com.duiba.nezha.alg.common.model.adjustprice.AdjPriceResult;
import cn.com.duiba.nezha.alg.common.model.adjustprice.AdjustPrice;
import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.UcbResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import java.util.stream.Collectors;

import cn.com.duiba.nezha.alg.common.model.advertexplore.explore.*;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.calcUcb;
import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;


public class AdvertExploreV2 {


    private static final Logger logger = LoggerFactory.getLogger(AdvertExploreV2.class);


    public static List<ExploreResultV2> exploreV2(List<ExploreInfo> exploreInfos,
                                                  ExploreParams exploreParams,
                                                  AdExploreUcbData adExploreUcbData,
                                                  String expNum) {

        if (AssertUtil.isAnyEmpty(exploreInfos, exploreParams)) {
            return null;
        }

        if (Math.random() < 0.0001) {
            logger.info("params AdvertExplore2:{}", exploreParams.toString());
        }

        Double expratio = exploreParams.getExpratio();//探索消耗占比
        Integer activeReTarget = exploreParams.getActiveReTarget();
        List<String> expATrade = exploreParams.getExpATrade();//"16"
        List<String> expBTrade = exploreParams.getExpBTrade();//"15"
        List<String> expCTrade = exploreParams.getExpCTrade();//"15","16","21","9"
        Long expCnt1 = exploreParams.getAppAdExpCnt1();
        Long expCnt2 = exploreParams.getAppAdExpCnt2();
        double bidfactor = exploreParams.getBidfactor();//出价
        double afeefactor = exploreParams.getAfeefactor();
        double expFactor = exploreParams.getExpFactor();


        //调价
        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
        List<Double> bidRatioBucket = exploreParams.getBidRatioBucket();
        List<Double> bidFactorBucket = exploreParams.getBidFactorBucket();

        double biasWeight = exploreParams.getBiasWeight();
        double limitFactor = exploreParams.getLimitFactor();

        Double[] finalBiasBucket = biasBucket.toArray(new Double[biasBucket.size()]);
        Double[] finalFactorBucket = factorBucket.toArray(new Double[factorBucket.size()]);

        Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
        Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);

        Double[] bidRatioBucket1 = bidRatioBucket.toArray(new Double[bidRatioBucket.size()]);
        Double[] bidFactorBucket1 = bidFactorBucket.toArray(new Double[bidFactorBucket.size()]);


        List<ExploreResultV2> resList = new ArrayList<>(); //结果

        for (ExploreInfo info : exploreInfos){
            ExploreResultV2 res = new ExploreResultV2(info.getAdvertId(),info.getOrientationId());
            //召回信息赋值
            Map<Integer,Double> scoreMap = info.getScoreMap();

            res.setScoreMap(scoreMap);
            //探索消耗达到10%
            double exploreRatio = division(info.getAppAdvertInfo().getAdvertExploreConsume(),info.getAppAdvertInfo().getAdvertOcpcConsume());
            Set<Integer> expWays = new HashSet<>();

            if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000 || exploreRatio < expratio)
                    && info.getAppAdvertInfo().getAppAdExpCnt()< expCnt1 && info.getIsCandidate1()
                    && info.getRealseTarget() == activeReTarget) { //发券达到一定量级

                /**
                 * 出价筛选配置
                 */
                double bid = 0.0;
                double orientProb1 = 0.1;
                if (info.getConvertType() == 0 && info.getAppTradeInfo().getData3day().getConv() != null
                        && info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()) != null) {
                    double tradeCvr = division(info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()), info.getAppTradeInfo().getData3day().getClick());
                    bid = info.getTarget() * tradeCvr;
                    orientProb1 = info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()) >= 5 ? bid * bidfactor : 0.1;// 0.025,40有100%的概率进来

                }
                double afee = info.getTarget();

                double orientProb2 = afee * afeefactor;//0.0005,2000有100%的概率进来
                double orientProb = Math.max(orientProb1, orientProb2);
//                //新广告的探索加权
//                if (info.getIsNewAdvert() == 1.0) {
//                    orientProb = Math.min(orientProb * 1.25, 1.0);
//                }
                orientProb = Math.max(Math.min(orientProb, 0.8), 0.1);
                Random r1 = new Random();
                if (("expA".equals(expNum) && r1.nextDouble() < orientProb && expATrade.contains(info.getTradeId())) ||
                        ("expB".equals(expNum) && r1.nextDouble() < orientProb && expBTrade.contains(info.getTradeId())) ||
                        ("expC".equals(expNum) && r1.nextDouble() < orientProb && expCTrade.contains(info.getTradeId()))) {

                    expWays.add(1);
                    res.setExpWays(expWays);
                    double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket,
                            expbiasBucket1, expFactorBucket1,
                            bidRatioBucket1, bidFactorBucket1,biasWeight,limitFactor);
                    scoreMap.put(4,factor);
                    res.setScoreMap(scoreMap);
                    res.setExpAdjustFactor(factor);
                }

            } if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000 || exploreRatio < expratio)
                    && info.getAppAdvertInfo().getAppAdExpCnt()< expCnt2
                    && info.getIsCandidate2()
                    && info.getRealseTarget() == activeReTarget){

                if (("expA".equals(expNum) && expATrade.contains(info.getTradeId())) ||
                        ("expB".equals(expNum) && expBTrade.contains(info.getTradeId())) ||
                        ("expC".equals(expNum) && expCTrade.contains(info.getTradeId()))) {

                    expWays.add(2);
                    res.setExpWays(expWays);
                    double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket,
                            expbiasBucket1, expFactorBucket1,
                            bidRatioBucket1, bidFactorBucket1,biasWeight,limitFactor);
                    scoreMap.put(4,factor);
                    res.setScoreMap(scoreMap);
                    res.setExpAdjustFactor(factor);
                }
            } if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000 || exploreRatio < expratio)
                    && info.getAppAdvertInfo().getAppAdExpCnt()< expCnt2
                    && MapUtils.isNotEmpty(info.getScoreMap())
                    && info.getRealseTarget() == activeReTarget){
                double prob = Math.max(
                        Math.min(division(expFactor,
                                info.getAppAdvertInfo().getAppAdExpCnt()),0.8),0.2);
                Random r2 = new Random();

                if (("expA".equals(expNum) && r2.nextDouble() < prob && expATrade.contains(info.getTradeId())) ||
                        ("expB".equals(expNum) && r2.nextDouble() < prob && expBTrade.contains(info.getTradeId())) ||
                        ("expC".equals(expNum) && r2.nextDouble() < prob && expCTrade.contains(info.getTradeId()))) {

                    expWays.add(3);
                    res.setExpWays(expWays);
                    double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket,
                            expbiasBucket1, expFactorBucket1,
                            bidRatioBucket1, bidFactorBucket1,biasWeight,limitFactor);
                    scoreMap.put(4,factor);
                    res.setScoreMap(scoreMap);
                    res.setExpAdjustFactor(factor);
                }
            }

            resList.add(res);
        }
        return resList;
    }

    public static void main(String[] args) {

    }


}
