package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;


class InverseController {
    //抄知乎上的逆系统控制https://zhuanlan.zhihu.com/p/92248872
    //其实不大一样了，他是只取前面一个时刻的偏差，且用的是原始值。
    //这边用的是累计值，且是修改后的值。更像是只有I的pid。

    //主函数用来返回个因子乘到最终的cvr/出价上面去
    //计算方法为前24小时的 统计cvr/融合cvr
    public static WeightInfo calcControlFactor(ExpHourData advertPkExpV1, Integer convertSubType,
                                    Double upperBound, Double lowerBound, Long controlClickCntThreshold,
                                    WeightDimEnum dim) {
        double avgMergeCvr=advertPkExpV1.getMergeCvr24Hour();
        double statCvr=advertPkExpV1.getCvr24Hour(convertSubType);
        long cumClickCnt=0L;
        for (HourDto hourDto : advertPkExpV1.getHourDtoMap().values()) {
            cumClickCnt=cumClickCnt+hourDto.getClickCnt();
        }
        double result=1.0;
        if (cumClickCnt<controlClickCntThreshold) {
            result=1.0;
        }
        else {
            double controlFactor=statCvr/(avgMergeCvr+0.000001);
            result=bound(controlFactor,upperBound,lowerBound);
        }

        return new WeightInfo(dim.getId(), 0L, 0.0,
                DataUtil.formatDouble(result, 5));
    }

    static private double bound(Double value,Double upperBound,Double lowerBound) {
        if(value>upperBound) {
            return upperBound;
        }
        else if (value<lowerBound) {
            return lowerBound;
        }
        else {
            return value;
        }
    }

}
