/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypeKit {
    private static final Logger log = LoggerFactory.getLogger(TypeKit.class);
    private static final Map<Class<?>, Type[]> cache = new ConcurrentHashMap();

    public static Type[] getActualTypes(Class<?> clazz) {
        return cache.computeIfAbsent(clazz, k -> ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments());
    }

    public static <T> Class<T> getActualType(Class<?> clazz, int typeIndex) {
        Type[] actualTypeArray = TypeKit.getActualTypes(clazz);
        if (typeIndex > actualTypeArray.length - 1) {
            return null;
        }
        Type actualType = actualTypeArray[typeIndex];
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        return null;
    }

    public static <T> T newActualInstance(Class<?> clazz, int typeIndex) {
        try {
            Class<T> actualClazz = TypeKit.getActualType(clazz, typeIndex);
            if (actualClazz != null) {
                return actualClazz.newInstance();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u771f\u5b9e\u7c7b\u578b\u5b9e\u4f8b\u5316\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

