package cn.com.duiba.nezha.alg.common.model.pacing;

import cn.com.duiba.nezha.alg.common.model.deeptarget.ConsumeInfo;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Recommender {
    private static final Logger logger = LoggerFactory.getLogger(Recommender.class);

    /**
     * 托管定向和召回的合并与放弃
     * @param orientlist
     * @param slotId
     * @param trusteeshipParams
     * @param flowType
     * @return
     */

    public static Map<ResultType, Collection<AdvertOrientInfo>> deviceAndSlotRecommend(Collection<OrientInfo> orientlist,
                                                                                       Long slotId,
                                                                                       TrusteeshipParams trusteeshipParams,
                                                                                       Integer flowType) {
        //定向合并
        Map<ResultType, Collection<AdvertOrientInfo>> slotRecommendSet = SlotRecommender.recommend(orientlist, slotId, trusteeshipParams, flowType);

        Collection<AdvertOrientInfo> advertOrientInfoSet = slotRecommendSet.get(ResultType.ONTARGET);

        List<OrientInfo> orientlistRecall = orientlist.stream().filter(orient -> orient.recall).collect(Collectors.toList());

        Set<AdvertOrientInfo> advertOrientInfoSetMerge = new HashSet<>();
        orientlistRecall.forEach(orient -> {
            AdvertOrientInfo advertOrientInfo = new AdvertOrientInfo(orient.advertId, orient.orientId, new HashSet<Integer>());
            if(!advertOrientInfoSet.contains(advertOrientInfo) && orient.getPreCvr() != null && orient.getPreCvr() >= 0.006){
                advertOrientInfo.getMatchType().add(20);
                advertOrientInfoSetMerge.add(advertOrientInfo);
            }
        });
        advertOrientInfoSetMerge.addAll(advertOrientInfoSet);

        slotRecommendSet.put(ResultType.BEFOREFILTER, advertOrientInfoSetMerge);


        //定向放弃
        Map<String, OrientInfo> collect = orientlist.stream().collect(Collectors.toMap(orient -> orient.getAdvertId() + "_" + orient.getOrientId(), Function.identity()));

        Set<AdvertOrientInfo> advertOrientInfoSetFilter = new HashSet<>();
        advertOrientInfoSetFilter.addAll(advertOrientInfoSetMerge);
        Iterator<AdvertOrientInfo> iterator = advertOrientInfoSetFilter.iterator();

        while(iterator.hasNext()) {
            AdvertOrientInfo orient = iterator.next();
            OrientInfo orientInfo = collect.get(orient.getAdvertId() + "_" + orient.getOrientId());

            if(orientInfo.getDeepTargetinfo() != null && orientInfo.getConsumeInfo() != null && orientInfo.getPreDcvr() != null){
                DeepTargetInfo deepTargetInfo = orientInfo.getDeepTargetinfo();
                ConsumeInfo consumeInfo = orientInfo.getConsumeInfo();
                Double preDcvr = orientInfo.getPreDcvr();
                Double preCvr = orientInfo.getPreCvr();

                boolean isGiveup = giveUpFlow(deepTargetInfo, consumeInfo, preDcvr, preCvr, flowType);
                if (isGiveup) {
                    iterator.remove();
                    logger.info("deviceAndSlotRecommend giveup :{}", orient.getAdvertId() + "_" + orient.getOrientId());
                }
            }
        }

        slotRecommendSet.put(ResultType.AFTERFILTER, advertOrientInfoSetFilter);
        return slotRecommendSet;

    }

    /**
     * 当前流量是否放弃
     * @param deepTargetInfo
     * @param preDcvr
     * @param preCvr
     * @return
     */
    public static boolean giveUpFlow(DeepTargetInfo deepTargetInfo,
                                     ConsumeInfo consumeInfo,
                                     Double preDcvr,
                                     Double preCvr,
                                     Integer flowType) {

        boolean ret = false;
        if (AssertUtil.isAnyEmpty(deepTargetInfo,consumeInfo,preDcvr,preCvr)) {
            return ret;
        }
        double selectFactor = deepTargetInfo.getSelectFactor();
        if (flowType == 1) {
            selectFactor =  deepTargetInfo.getSdkSelectFactor();
        }
        double consumeFactor = consumeInfo.getConsumeFactor();
//        if(preDcvr > selectFactor && preCvr < 0.01){
//            Random r = new Random();
//            Double x = r.nextDouble();
//            if (x <= 0.1){
//                ret = true;
//            }
//        }
        if(preDcvr <= selectFactor && consumeFactor >= 1.2){
            ret = true;
        } else if(consumeFactor < 1.2 && preDcvr < Math.max(selectFactor/1.4,0.01)){
            ret = true;
        }

        return ret;
    }


}


