/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityCvrInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoAd;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRankInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityVal;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SimilarCostActivitiesInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRec30 {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRec30.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts) {
        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>(){

            @Override
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityRankInfo> sortByIdAndSourceModelBack(List<ActivityRankInfo> acts) {
        List<ActivityRankInfo> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityRankInfo>(){

            @Override
            public int compare(ActivityRankInfo act1, ActivityRankInfo act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityMatchInfo> sortByIdAndSourceDataBack(List<ActivityMatchInfo> acts) {
        List<ActivityMatchInfo> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityMatchInfo>(){

            @Override
            public int compare(ActivityMatchInfo act1, ActivityMatchInfo act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    public static List<ActivityMatchInfo> match(List<ActivityInfoData> actData, List<ActivityInfoAd> actAds) {
        int topn = Constant.SEARANK_TOPN;
        ArrayList<ActivityMatchInfo> result = new ArrayList<ActivityMatchInfo>();
        ArrayList<ActivityMatchInfo> actModelCopy = new ArrayList<ActivityMatchInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        List<ActivityInfoData> actDataCopy = ActivityRec30.sortByIdAndSourceData(actData);
        HashMap<Long, ActivityInfoAd> adHashMap = new HashMap<Long, ActivityInfoAd>();
        for (int i = 0; i < actAds.size(); ++i) {
            adHashMap.put(actAds.get((int)i).activityId, actAds.get(i));
        }
        long size_act = actDataCopy.size();
        HashSet<Long> idset = new HashSet<Long>();
        int limit = topn;
        int i = 0;
        while ((long)i < size_act) {
            try {
                ActivityMatchInfo actM = new ActivityMatchInfo();
                actM.activityId = actDataCopy.get((int)i).activityId;
                actM.slotId = actDataCopy.get((int)i).slotId;
                actM.appId = actDataCopy.get((int)i).appId;
                actM.hisClick = new ActivityVal();
                actM.hisClick.globalVal = actDataCopy.get((int)i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get((int)i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get((int)i).click.slotVal;
                actM.hisCost = new ActivityVal();
                actM.hisCost.globalVal = actDataCopy.get((int)i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get((int)i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get((int)i).cost.slotVal;
                actM.hisRequest = new ActivityVal();
                actM.hisRequest.globalVal = actDataCopy.get((int)i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get((int)i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get((int)i).request.slotVal;
                actM.activityType = actDataCopy.get((int)i).activityType;
                actM.subType = actDataCopy.get((int)i).subType;
                actModelCopy.add(actM);
                if (actM.hisRequest.globalVal < 100.0) {
                    if (System.currentTimeMillis() - actDataCopy.get((int)i).createTime < 259200000L) {
                        if (Math.random() < 1.0E-4) {
                            result.add(actM);
                            --topn;
                            idset.add(actM.activityId);
                        }
                    } else if (actDataCopy.size() > limit && Math.random() < 1.0E-5) {
                        result.add(actM);
                        --topn;
                        idset.add(actM.activityId);
                    }
                } else {
                    double slotScore = WilsonInterval.wilsonCalc((double)((double)((long)actM.hisClick.slotVal)), (double)((double)((long)actM.hisRequest.slotVal * 3L))).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((double)((double)((long)actM.hisClick.globalVal)), (double)((double)((long)actM.hisRequest.globalVal * 3L))).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((double)((double)((long)actM.hisClick.appVal)), (double)((double)((long)actM.hisRequest.appVal * 3L))).lowerBound;
                    double coef = 0.0;
                    double matchscore = 0.0;
                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100.0, 1.0);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100.0, 1.0);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000.0, 1.0);
                    matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    double changeScore = 0.0;
                    ActivityCvrInfo activityChangeValNew = new ActivityCvrInfo();
                    activityChangeValNew = ActivityRec30.calChangeScoreMergeAbsolute(adHashMap.getOrDefault(actDataCopy.get((int)i).activityId, new ActivityInfoAd()));
                    actM.changeScore = changeScore = activityChangeValNew.changeScoreMerge;
                    actM.activityChangeVal = activityChangeValNew;
                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;
                    candis.add(info);
                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5.0) {
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        info2.score = actM.hisRequest.slotVal > 0.0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0.0;
                        slotCandis.add(info2);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        int size1 = slotCandis.size();
        for (int i2 = 0; i2 < 10 && i2 < size1; ++i2) {
            ActivityMatchInfo act = ((MatchInfo)slotCandis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            --topn;
        }
        int size = candis.size();
        int resultSize = result.size();
        for (int i3 = 0; resultSize < limit && i3 < size; ++i3) {
            ActivityMatchInfo act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            resultSize = result.size();
            --topn;
        }
        if (result.size() < limit) {
            int count = topn;
            int i4 = 0;
            while ((long)i4 < size_act) {
                if (!idset.contains(actDataCopy.get((int)i4).activityId)) {
                    idset.add(actDataCopy.get((int)i4).activityId);
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisClick.globalVal = actDataCopy.get((int)i4).click.globalVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisClick.appVal = actDataCopy.get((int)i4).click.appVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisClick.slotVal = actDataCopy.get((int)i4).click.slotVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisCost.globalVal = actDataCopy.get((int)i4).cost.globalVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisCost.appVal = actDataCopy.get((int)i4).cost.appVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisCost.slotVal = actDataCopy.get((int)i4).cost.slotVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisRequest.globalVal = actDataCopy.get((int)i4).request.globalVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisRequest.appVal = actDataCopy.get((int)i4).request.appVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).hisRequest.slotVal = actDataCopy.get((int)i4).request.slotVal;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).activityType = actDataCopy.get((int)i4).activityType;
                    ((ActivityMatchInfo)actModelCopy.get((int)i4)).subType = actDataCopy.get((int)i4).subType;
                    result.add((ActivityMatchInfo)actModelCopy.get(i4));
                    if (++count >= topn) break;
                }
                ++i4;
            }
        }
        return result;
    }

    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {
        double gama = 0.1;
        RankResult selectActivityResult = new RankResult();
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            selectActivityResult.activityModel = actModel.get(0);
            selectActivityResult.similarCostActivitiesInfo = null;
            return selectActivityResult;
        }
        List<ActivityRankInfo> actModelCopy = ActivityRec30.sortByIdAndSourceModelBack(actModel);
        List<ActivityMatchInfo> actDataCopy = ActivityRec30.sortByIdAndSourceDataBack(actData);
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = actModelCopy.get((int)i).activityId;
            long activityIdData = actDataCopy.get((int)i).activityId;
            if (activityIdMode == activityIdData) continue;
            selectActivityResult.activityModel = actModel.get(0);
            selectActivityResult.similarCostActivitiesInfo = null;
            return selectActivityResult;
        }
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<ActivityRankInfo> candiList = new ArrayList<ActivityRankInfo>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        ActivityRankInfo result = null;
        try {
            int i;
            for (i = 0; i < actDataCopy.size(); ++i) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(actDataCopy.get((int)i).activityId) ? (RankInfo)mMap.get(actDataCopy.get((int)i).activityId) : new RankInfo();
                info.grpm = grpm = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisCost.globalVal / actDataCopy.get((int)i).hisRequest.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actData.get((int)i).hisCost.appVal / actData.get((int)i).hisRequest.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actData.get((int)i).hisCost.slotVal / actData.get((int)i).hisRequest.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                mMap.put(actDataCopy.get((int)i).activityId, info);
            }
            for (i = 0; i < actDataCopy.size(); ++i) {
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(actDataCopy.get((int)i).hisRequest.slotVal / 60.0, 1.0);
                double aconfidence = Math.min(actDataCopy.get((int)i).hisRequest.appVal / 60.0, 1.0);
                reward = sconfidence * ActivityRec30.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivityRec30.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivityRec30.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).grpm * 0.5, maxG, 0.6);
                reward *= reward;
                reward = Math.max(reward, Constant.MIN_REWARD);
                actModelCopy.get((int)i).reward = actModelCopy.get((int)i).reward * decay + reward;
                actModelCopy.get((int)i).count = actModelCopy.get((int)i).count * decay + 1.0;
                actModelCopy.get((int)i).alpha = 1.5 + actModelCopy.get((int)i).reward;
                actModelCopy.get((int)i).beta = 2.0 + (actModelCopy.get((int)i).count - actModelCopy.get((int)i).reward);
                rewards.add(actModelCopy.get((int)i).reward);
                counts.add(actModelCopy.get((int)i).count);
                alphas.add(actModelCopy.get((int)i).alpha);
                betas.add(actModelCopy.get((int)i).beta);
                activityIds.add(actModelCopy.get((int)i).activityId);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            SelectInfoDetail selectInfoDetail = ActivityRec30.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, numMachines, gama);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityRankInfo)candiList.get(selectedActivityIndex);
            ArrayList<SelectInfo> sameCostcondi = selectInfoDetail.condi;
            int sameCostActivityCnt = sameCostcondi.size();
            ArrayList<SimilarCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SimilarCostActivitiesInfo>();
            for (SelectInfo selectInfo : sameCostcondi) {
                SimilarCostActivitiesInfo sameCostActivitiesInfo = new SimilarCostActivitiesInfo();
                Long activityId = selectInfo.activityId;
                Long activityType = selectInfo.activityType;
                int ifSelected = 0;
                if (selectInfo.index == selectedActivityIndex) {
                    ifSelected = 1;
                }
                int index = selectInfo.index;
                Double mabReward = selectInfo.reward;
                Double changeScore = selectInfo.changeScore;
                Double diffChangeScore = selectInfo.changeScore;
                sameCostActivitiesInfo.activityId = activityId;
                sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                sameCostActivitiesInfo.activityType = activityType;
                sameCostActivitiesInfo.ifSelected = ifSelected;
                sameCostActivitiesInfo.mabReward = mabReward;
                sameCostActivitiesInfo.changeScore = changeScore;
                sameCostActivitiesInfo.index = index;
                sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
            }
            selectActivityResult.activityModel = result;
            selectActivityResult.similarCostActivitiesInfo = sameCostActivitiesInfoList;
            mMap.clear();
            return selectActivityResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString(result)});
            return null;
        }
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad) {
        double changeScoreMerge = 0.0;
        double changeScoreForms = ad.sumClickForms > 0.0 ? ad.sumEffectPVForms / ad.sumClickForms : 0.0;
        double changeScoreNotForms = ad.sumClickNotForms > 0.0 ? ad.sumEffectPVNotForms / ad.sumClickNotForms : 0.0;
        double effctFormsWeight = Math.min(ad.sumEffectPVForms / 3.0, 1.0);
        double effctNotFormsWeight = Math.min(ad.sumEffectPVNotForms / 30.0, 1.0);
        double rand = Math.random();
        if (ad.sumEffectPVForms >= 1.0) {
            changeScoreMerge = changeScoreForms;
        } else if (0.0 < ad.sumClickForms && ad.sumClickForms < 100.0) {
            double w1 = ad.sumClickForms / 100.0 / 0.2;
            double w2 = 5.0 - w1;
            changeScoreMerge = 0.01 * w2 * 0.06;
        } else if (ad.sumClickForms >= 100.0) {
            changeScoreMerge = 0.06 / ad.sumClickForms;
        } else if (changeScoreNotForms > 0.0) {
            changeScoreMerge = changeScoreNotForms * 1.0E-6;
        } else if (rand <= 1.0E-6) {
            changeScoreMerge = Math.random();
        }
        ActivityCvrInfo activityChangeVal = new ActivityCvrInfo();
        activityChangeVal.sumClickForms = ad.sumClickForms;
        activityChangeVal.sumEffectPVForms = ad.sumEffectPVForms;
        activityChangeVal.sumClickNotForms = ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms = ad.sumEffectPVNotForms;
        activityChangeVal.changeScoreForms = changeScoreForms;
        activityChangeVal.changeScoreNotForms = changeScoreNotForms;
        activityChangeVal.changeScoreMerge = changeScoreMerge;
        return activityChangeVal;
    }

    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, double gama) {
        int i;
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new ArrayList<SelectInfo>();
        for (int i2 = 0; i2 < numMachines; ++i2) {
            double theta = BetaDistribution.BetaDist(alphas.get(i2), betas.get(i2));
            SelectInfo sinfo = new SelectInfo();
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i2);
            sinfo.index = i2;
            sinfo.activityId = activityIds.get(i2);
            sinfo.changeScore = changeScores.get(i2);
            sinfos.add(sinfo);
        }
        Collections.sort(sinfos, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList condi = new ArrayList();
        for (i = 0; i < sinfos.size(); ++i) {
            if (!(((SelectInfo)sinfos.get((int)0)).reward - ((SelectInfo)sinfos.get((int)i)).reward <= gama)) continue;
            condi.add(sinfos.get(i));
        }
        Collections.sort(condi, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                return 1;
            }
        });
        selectMachine = ((SelectInfo)condi.get((int)0)).index;
        for (i = 0; i < condi.size(); ++i) {
            if (((SelectInfo)condi.get((int)i)).activityType == 21L) continue;
            selectMachine = ((SelectInfo)condi.get((int)i)).index;
            break;
        }
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        selectInfoDetail.condi = condi;
        selectInfoDetail.index = selectMachine;
        return selectInfoDetail;
    }

    private static ActivityRec30 getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivityRec30 instance = new ActivityRec30();
    }

    static class MatchInfo {
        double score;
        ActivityMatchInfo act;

        MatchInfo() {
        }
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectInfo> condi;

        SelectInfoDetail() {
        }
    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;

        SelectInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

