/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LocalDateUtil {
    public static Map<String, DateTimeFormatter> map = new HashMap<String, DateTimeFormatter>();

    public static void main(String[] args) {
        LocalDateTime localDateTime1 = LocalDateUtil.getLocalDateTime("2019-02-19 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime localDateTime2 = LocalDateUtil.getLocalDateTime("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        System.out.println("localDateTime=" + localDateTime1.getDayOfWeek().getValue());
        System.out.println("wn=" + DateUtil.getWeekNumber("2019-02-19 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS));
        System.out.println("localDateTime.between=" + LocalDateUtil.getBetweenDuration(localDateTime1, localDateTime2).toHours());
        LocalDate localDate1 = LocalDateUtil.getLocalDate("2018-09-05", DateStyle.YYYY_MM_DD.getValue());
        LocalDate localDate2 = LocalDateUtil.getLocalDate("2018-09-03", DateStyle.YYYY_MM_DD.getValue());
        System.out.println("localDate=" + localDate1);
        System.out.println("localDate.between=" + LocalDateUtil.getBetweenDays(localDate1, localDate2));
        LocalTime localTime1 = LocalDateUtil.getLocalTime("13:02:10", DateStyle.HH_MM_SS.getValue());
        LocalTime localTime2 = LocalDateUtil.getLocalTime("12:02:10", DateStyle.HH_MM_SS.getValue());
        System.out.println("localTime=" + localTime1);
        System.out.println("localTime.between=" + LocalDateUtil.getBetweenSeconds(localTime1, localTime2));
        Long millis = LocalDateUtil.getTimeMillis("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        System.out.println("millis=" + millis);
        Date date = DateUtil.getDate("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date otherDate = DateUtil.getDate("2019-02-23 10:54:40", DateStyle.YYYY_MM_DD_HH_MM_SS);
        Long dayBetween = LocalDateUtil.getIntervalDays(date, null);
        System.out.println("dayBetween=" + dayBetween);
    }

    public static Long getIntervalDays(Date date, Date otherDate) {
        LocalDateTime otherDateLocal;
        Long ret = null;
        if (date == null || otherDate == null) {
            return null;
        }
        LocalDateTime dateLocal = LocalDateUtil.dateToLocal(date);
        Duration duration = LocalDateUtil.getBetweenDuration(dateLocal, otherDateLocal = LocalDateUtil.dateToLocal(otherDate));
        if (duration != null) {
            ret = duration.toDays();
        }
        return ret;
    }

    public static LocalDateTime dateToLocal(Date date) {
        LocalDateTime localDate = null;
        if (date != null) {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            localDate = instant.atZone(zoneId).toLocalDateTime();
        }
        return localDate;
    }

    public static Long getTimeMillis(String time, String parttern) {
        Long ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = LocalDateUtil.getLocalDateTime(time, parttern);
            ret = LocalDateUtil.getTimeMillis(localDateTime);
        }
        return ret;
    }

    public static Long getTimeMillis(LocalDateTime localDateTime) {
        Long ret = null;
        if (localDateTime != null) {
            ret = localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        return ret;
    }

    public static Integer getHour(String time, String parttern) {
        Integer ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = LocalDateUtil.getLocalDateTime(time, parttern);
            ret = LocalDateUtil.getHour(localDateTime);
        }
        return ret;
    }

    public static Integer getDayOfWeek(String time, String parttern) {
        Integer ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = LocalDateUtil.getLocalDateTime(time, parttern);
            ret = LocalDateUtil.getDayOfWeek(localDateTime);
        }
        return ret;
    }

    public static Integer getHour(LocalDateTime localDateTime) {
        Integer ret = null;
        if (localDateTime != null) {
            ret = localDateTime.getHour();
        }
        return ret;
    }

    public static Integer getDayOfWeek(LocalDateTime localDateTime) {
        Integer ret = null;
        if (localDateTime != null) {
            ret = localDateTime.getDayOfWeek().getValue();
        }
        return ret;
    }

    public static Long getIntervalMinutes(String date, String otherDate, DateStyle dateStyle, DateStyle otherDateStyle) {
        Long ret = null;
        try {
            LocalDateTime localDateTime1 = LocalDateUtil.getLocalDateTime(date, dateStyle.getValue());
            LocalDateTime localDateTime2 = LocalDateUtil.getLocalDateTime(otherDate, otherDateStyle.getValue());
            if (localDateTime1 != null && localDateTime2 != null) {
                ret = LocalDateUtil.getBetweenDuration(localDateTime2, localDateTime1).toMinutes();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Long getIntervalMinutes(String date1, DateStyle dateStyle) {
        Long ret = null;
        try {
            LocalDateTime localDateTime1 = LocalDateTime.now();
            LocalDateTime localDateTime2 = LocalDateUtil.getLocalDateTime(date1, dateStyle.getValue());
            if (localDateTime1 != null && localDateTime2 != null) {
                ret = LocalDateUtil.getBetweenDuration(localDateTime2, localDateTime1).toMinutes();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Long getIntervalDays(String date1, DateStyle dateStyle) {
        Long ret = null;
        try {
            LocalDate localDate1 = LocalDate.now();
            LocalDate localDate2 = LocalDateUtil.getLocalDate(date1, dateStyle.getValue());
            if (localDate1 != null && localDate2 != null) {
                ret = LocalDateUtil.getBetweenDays(localDate2, localDate1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getCurrentLocalDateTime(DateStyle dateStyle) {
        String ret = null;
        if (dateStyle != null) {
            ret = LocalDateUtil.getCurrentLocalDateTime(dateStyle.getValue());
        }
        return ret;
    }

    public static String getCurrentLocalDateTime(String parttern) {
        String ret = null;
        if (parttern != null) {
            ret = LocalDateTime.now().format(DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }

    public static Duration getBetweenDuration(LocalDateTime start, LocalDateTime end) {
        Duration ret = null;
        if (start != null && end != null) {
            ret = Duration.between(start, end);
        }
        return ret;
    }

    public static Long getBetweenDays(LocalDate start, LocalDate end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = end.toEpochDay() - start.toEpochDay();
        }
        return ret;
    }

    public static Long getBetweenSeconds(LocalTime start, LocalTime end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = (long)(end.toSecondOfDay() - start.toSecondOfDay()) + 0L;
        }
        return ret;
    }

    public static LocalDate getLocalDate(String timeString, String parttern) {
        LocalDate ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDate.parse(timeString, DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }

    public static LocalTime getLocalTime(String timeString, String parttern) {
        LocalTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }

    public static LocalDateTime getLocalDateTime(String timeString, String parttern) {
        LocalDateTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDateTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }
}

