package cn.com.duiba.nezha.alg.common.model.advertexplore;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

@Data
public class ExploreData {

    String id;

    Long exposure = 0L;
    Long click = 0L;
    Map<Integer, Long> conv = new HashMap<>();
    Long consume = 0L;
    Long ocpcConsume = 0L;

    Double costBias = 0D;

    public double getCtr() {
        if (exposure <= 0) {
            return 0.0;
        }
        return DataUtil.formatDouble(click * 1.0 / exposure, 4);
    }

    public double getWCtr(double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(exposure, click, faithLevel), 4);
    }

    public double getCvr(Integer convertSubtype) {
        if (click <= 0) {
            return 0.0;
        }

        return DataUtil.formatDouble(conv.getOrDefault(convertSubtype, 0L) * 1.0 / click,
                4);
    }

    public double getWCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(click, conv.getOrDefault(convertSubtype, 0L), faithLevel),
                4);
    }


    public double getCtCvr(Integer convertSubtype) {
        if (exposure <= 0) {
            return 0.0;
        }
        return DataUtil.formatDouble(conv.getOrDefault(convertSubtype, 0L) * 1.0 / exposure,
                4);
    }

    public double getWCtCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(exposure, conv.getOrDefault(convertSubtype, 0L), faithLevel),
                4);

    }


}
