/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class BidPidController {
    public static WeightInfo calcControlFactor(ExpHourData expHourData, ExpHourData baseHourData, Long bidReqCntThreshold, Double targetRatio, Double upperBound, Double lowerBound, Double kp, Double ki, WeightDimEnum dim) {
        double errorCurrent = BidPidController.errorDiff(expHourData, baseHourData, bidReqCntThreshold, targetRatio);
        double errorIntegral = BidPidController.errorIntegral(expHourData, baseHourData, bidReqCntThreshold, targetRatio);
        double kt = kp * errorCurrent + ki * errorIntegral;
        double unboundK = BidPidController.responseFunc(kt);
        double k = Double.isInfinite(unboundK) || Double.isNaN(unboundK) ? 1.0 : BidPidController.bound(unboundK, upperBound, lowerBound);
        return new WeightInfo(dim.getId(), 0L, DataUtil.formatDouble(errorCurrent, 5), DataUtil.formatDouble(k, 5));
    }

    private static double errorDiff(ExpHourData expHourData, ExpHourData baseHourData, Long baseBidReqCntThreshold, Double targetRatio) {
        HourDto expLastHourDto = expHourData.getHourDtoMap().getOrDefault(expHourData.getLastHour(), new HourDto());
        long bidReqCount = expLastHourDto.getBidReqCount();
        double bidSuccessRatio = expHourData.getBidSuccessRatioLastHour();
        HourDto baseLastHourDto = baseHourData.getHourDtoMap().getOrDefault(baseHourData.getLastHour(), new HourDto());
        Long baseBidReqCount = baseLastHourDto.getBidReqCount();
        double baseBidSuccessRatio = baseHourData.getBidSuccessRatioLastHour();
        if (baseBidReqCount <= baseBidReqCntThreshold || bidSuccessRatio == 0.0) {
            return 0.0;
        }
        double targetBidSuccessRatio = baseBidSuccessRatio * targetRatio;
        return targetBidSuccessRatio / bidSuccessRatio - 1.0;
    }

    private static double errorIntegral(ExpHourData expHourData, ExpHourData baseHourData, Long baseBidReqCntThreshold, Double targetRatio) {
        double bidSuccessRatio = expHourData.getBidSuccessRatio24Hour();
        long bidReq24Hour = 0L;
        for (HourDto hourDto : baseHourData.getHourDtoMap().values()) {
            bidReq24Hour += hourDto.getBidReqCount().longValue();
        }
        double baseBidSuccessRatio = baseHourData.getBidSuccessRatio24Hour();
        if (bidReq24Hour <= baseBidReqCntThreshold || bidSuccessRatio == 0.0) {
            return 0.0;
        }
        double targetBidSuccessRatio = baseBidSuccessRatio * targetRatio;
        return targetBidSuccessRatio / bidSuccessRatio - 1.0;
    }

    private static double responseFunc(double kt) {
        return kt + 1.0;
    }

    private static double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        }
        if (value < lowerBound) {
            return lowerBound;
        }
        return value;
    }

    public static void main(String[] args) {
        double v = 3.3333333333333335;
        System.out.println(v);
        double a = Double.isInfinite(v) || Double.isNaN(v) ? 1.0 : BidPidController.bound(v, 1.2, 0.1);
        Double aDouble = DataUtil.formatDouble(a, 4);
        System.out.println(aDouble);
    }
}

