/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import cn.com.duiba.nezha.alg.common.model.materialrecommend.AlgUtils;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.Constant;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialDataInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialMatchInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialNormInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialRankInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.RankInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRec25 {
    private static final Logger logger = LoggerFactory.getLogger(MaterialRec25.class);

    public static List<MaterialMatchInfo> match(List<MaterialDataInfo> materialList, List<MaterialNormInfo> exScks) {
        int i;
        double prob = Constant.PROB;
        double exposureThreshold = Constant.EXPOSURE_THRESHOLD;
        int topn = Constant.RECALL_TOPN_25;
        int exTopN = Constant.EXCELLENT_TOPN;
        if (materialList.size() == 0) {
            return null;
        }
        PriorityQueue<? super AlgUtils.MatchInfo> gCandisCTR = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> sCandisCTR = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> gCandisUC = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> sCandisUC = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> gCandisUCA = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> sCandisUCA = new PriorityQueue<AlgUtils.MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super AlgUtils.MatchInfo> normCandis = new PriorityQueue<AlgUtils.MatchInfo>(exTopN, AlgUtils.normComparator);
        ArrayList<MaterialMatchInfo> result = new ArrayList<MaterialMatchInfo>();
        ArrayList<MaterialMatchInfo> sckModel = new ArrayList<MaterialMatchInfo>();
        double exposures = 0.0;
        double clicks = 0.0;
        double requests = 0.0;
        double costs = 0.0;
        double validClicks = 0.0;
        for (MaterialDataInfo mat2 : materialList) {
            exposures += mat2.getExposureCnt().getSlotVal();
            clicks += mat2.getClickCnt().getSlotVal();
            requests += mat2.getRequest().getSlotVal();
            costs += mat2.getCost().getSlotVal();
            validClicks += mat2.getValidClick().getSlotVal();
        }
        double ctr = exposures > 0.0 ? clicks / exposures : 0.0;
        double uca = requests > 0.0 ? validClicks / requests : 0.0;
        double uc = exposures > 0.0 ? costs / exposures : 0.0;
        HashMap<Long, MaterialNormInfo> exHashMap = new HashMap<Long, MaterialNormInfo>();
        if (exScks != null) {
            for (MaterialNormInfo exSck : exScks) {
                exHashMap.put(exSck.getMaterialId(), exSck);
            }
        }
        HashSet<Long> sckIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisSckIds = new HashSet(materialList.stream().map(MaterialDataInfo::getMaterialId).collect(Collectors.toSet()));
        HashSet<Long> idset = new HashSet<Long>();
        for (MaterialDataInfo materialDataInfo : materialList) {
            try {
                MaterialMatchInfo sckM = AlgUtils.fillData(materialDataInfo, sckIds, exHashMap);
                sckM.setCtr(ctr);
                sckM.setUc(uc);
                sckM.setUca(uca);
                sckM.setCosts(costs);
                sckModel.add(sckM);
                if (sckM.exposureCnt.getGlobalVal() < exposureThreshold) {
                    if (System.currentTimeMillis() - materialDataInfo.createTime < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(sckM);
                            --topn;
                            idset.add(sckM.materialId);
                        }
                    } else if (materialList.size() > topn && Math.random() < 0.1 * prob) {
                        result.add(sckM);
                        --topn;
                        idset.add(sckM.materialId);
                    }
                }
                double wctr = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100.0, 1000.0, false);
                double wuca = AlgUtils.getMatchScore(sckM.request, sckM.validClick, 100.0, 1000.0, false);
                double wuc = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.cost, 100.0, 1000.0, true);
                if (sckM.isExcellent) {
                    AlgUtils.MatchInfo emi = new AlgUtils.MatchInfo();
                    emi.mat = sckM;
                    emi.score = sckM.score;
                    normCandis.add(emi);
                    continue;
                }
                AlgUtils.MatchInfo wctrm = new AlgUtils.MatchInfo();
                wctrm.mat = sckM;
                wctrm.score = wctr;
                gCandisCTR.add(wctrm);
                AlgUtils.MatchInfo wucam = new AlgUtils.MatchInfo();
                wucam.mat = sckM;
                wucam.score = wuca;
                gCandisUCA.add(wucam);
                AlgUtils.MatchInfo wucm = new AlgUtils.MatchInfo();
                wucm.mat = sckM;
                wucm.score = wuc;
                gCandisUC.add(wucm);
                if (sckM.exposureCnt.getSlotVal() > 99.0 || sckM.clickCnt.getSlotVal() > 5.0) {
                    AlgUtils.MatchInfo uctrm = new AlgUtils.MatchInfo();
                    uctrm.mat = sckM;
                    uctrm.score = sckM.clickCnt.getSlotVal() / sckM.exposureCnt.getSlotVal();
                    sCandisCTR.add(uctrm);
                    AlgUtils.MatchInfo uckmi = new AlgUtils.MatchInfo();
                    uckmi.mat = sckM;
                    uckmi.score = sckM.cost.getSlotVal() / (100.0 * sckM.exposureCnt.getSlotVal());
                    sCandisUC.add(uckmi);
                }
                if (!(sckM.request.getSlotVal() > 49.0)) continue;
                AlgUtils.MatchInfo ucam = new AlgUtils.MatchInfo();
                ucam.mat = sckM;
                ucam.score = sckM.validClick.getSlotVal() / sckM.request.getSlotVal();
                sCandisUCA.add(ucam);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < Constant.RECALL_SUC_TOPN && i < sCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)sCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUC_TOPN && i < gCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)gCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SCTR_TOPN && i < sCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)sCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GCTR_TOPN && i < gCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)gCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SUCA_TOPN && i < sCandisUCA.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)sCandisUCA.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUCA_TOPN && i < gCandisUCA.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((AlgUtils.MatchInfo)gCandisUCA.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        if (exScks != null) {
            for (MaterialNormInfo materialNormInfo : exScks) {
                if (hisSckIds.contains(materialNormInfo.getMaterialId())) continue;
                AlgUtils.MatchInfo mci = new AlgUtils.MatchInfo();
                MaterialMatchInfo aim = new MaterialMatchInfo();
                aim.setAppId(materialList.get(0).getAppId());
                aim.setSlotId(materialList.get(0).getSlotId());
                aim.setMaterialId(materialNormInfo.getMaterialId());
                aim.setnCtr(materialNormInfo.getnCtr());
                aim.setnPvCost(materialNormInfo.getnPvCost());
                aim.setScore(materialNormInfo.getScore());
                aim.setExcellent(true);
                mci.score = materialNormInfo.getScore();
                mci.mat = aim;
                normCandis.add(mci);
            }
            for (int i2 = 0; i2 < exTopN && i2 < normCandis.size(); ++i2) {
                AlgUtils.MatchInfo matchInfo = (AlgUtils.MatchInfo)normCandis.poll();
                if (idset.contains(matchInfo.mat.getMaterialId())) continue;
                result.add(matchInfo.mat);
                idset.add(matchInfo.mat.getMaterialId());
                --topn;
            }
        }
        return result;
    }

    public static MaterialRankInfo select(List<MaterialMatchInfo> matchInfos, List<MaterialRankInfo> materialModels) {
        HashMap map = new HashMap();
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }
        if (matchInfos.size() != materialModels.size()) {
            return null;
        }
        List<MaterialMatchInfo> matchInfoList = matchInfos.stream().sorted(Comparator.comparing(MaterialMatchInfo::getMaterialId).reversed()).collect(Collectors.toList());
        List<MaterialRankInfo> materialModelList = materialModels.stream().sorted(Comparator.comparing(MaterialRankInfo::getMaterialId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long modelMaterailId;
            long intoMaterialId = ((MaterialMatchInfo)matchInfoList.get(i)).getMaterialId();
            if (intoMaterialId == (modelMaterailId = ((MaterialRankInfo)materialModelList.get(i)).getMaterialId())) continue;
            return null;
        }
        ArrayList<RankInfo> ris = new ArrayList<RankInfo>();
        List<Object> mris = new ArrayList();
        double costs = ((MaterialMatchInfo)matchInfoList.get((int)0)).costs;
        String oppAlg = Constant.ALG_CTR;
        if (costs >= (double)Constant.COST_THRESHOLD) {
            oppAlg = Constant.ALG_UC;
        }
        int algType = ((MaterialMatchInfo)matchInfoList.get(0)).getAlgType();
        int feeMark = ((MaterialMatchInfo)matchInfoList.get(0)).getFeeMark();
        if (algType == 4 && feeMark == 1) {
            oppAlg = Constant.ALG_UCA;
        }
        mris = AlgUtils.getSingleOptCandis(ris, matchInfoList, materialModelList, oppAlg, 100, 100);
        AlgUtils.MaterialDetail md = AlgUtils.selectMultiOptInfo(ris, matchInfoList, materialModelList, oppAlg);
        MaterialRankInfo mri = materialModelList.get(md.index);
        mri.strategyType = md.strategyType;
        return mri;
    }
}

