/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class PidController {
    private double P = 1.0;
    private double I = 0.3;
    private double I2 = 0.01;
    private double D = 0.0;
    private static double LEARNING_RATE = 0.3;

    public double runPid(double target, double actual, double actualSum) {
        double error = 0.0;
        double signal = 0.0;
        error = this.P * (target - actual) + this.I * (target - actualSum);
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }

    public double runPid(double target, double actual, double actualSum, double factor) {
        double error = 0.0;
        double signal = 0.0;
        error = this.P * (target - actual) + this.I * (target - actualSum);
        signal = LEARNING_RATE * error;
        double range = this.getRange(factor);
        signal = MathUtil.stdwithBoundary(signal, -1.0 * range, range);
        return signal;
    }

    public double runPid(double target, double actual) {
        double error = 0.0;
        double signal = 0.0;
        error = this.P * (target - actual) / target;
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.2, 0.2);
        return signal;
    }

    private double getRange(double factor) {
        double ret = 0.05;
        if (factor > 1.2) {
            ret = 0.05 + (factor - 1.0) * 0.2;
        }
        if (factor < 1.2) {
            ret = 0.05 + Math.abs(1.0 - factor) * 0.05;
        }
        return ret;
    }

    public double runPid2(double target, double actual, double actualSum, double actualSum2) {
        double error = 0.0;
        double signal = 0.0;
        error = this.P * (target - actual) + this.I * (target - actualSum) + this.I2 * (target - actualSum2);
        signal = DataUtil.division((Double)(LEARNING_RATE * error), (Double)target, 3);
        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }
}

