package cn.com.duiba.nezha.alg.common.model.slotmaterialselect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description 去除广告位偏差，归一化ctr和活动参与率
 * @date 2019/7/11
 */
public class NormInfo {
    long materialId;
    double nCtr = 0.0;
    double nPartRate = 0.0;

    public long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(long materialId) {
        this.materialId = materialId;
    }

    public double getnCtr() {
        return nCtr;
    }

    public void setnCtr(double nCtr) {
        this.nCtr = nCtr;
    }

    public double getnPartRate() {
        return nPartRate;
    }

    public void setnPartRate(double nPartRate) {
        this.nPartRate = nPartRate;
    }

    @Override
    public String toString() {
        return "NormInfo{" +
                "materialId=" + materialId +
                ", nCtr=" + nCtr +
                ", nPartRate=" + nPartRate +
                '}';
    }

    public static void main(String[] args) {
        List<NormInfo> nfs = new ArrayList();
        for (int i = 0; i < 10; i++) {
            NormInfo nf = new NormInfo();
            nf.materialId = i;
            nf.nCtr = Math.random();
            nf.nPartRate = Math.random();
            nfs.add(nf);
        }
        List<NormInfo> materials = nfs.stream()
                .sorted(Comparator.comparing(NormInfo::getnCtr).reversed())
                .limit(30)
                .collect(Collectors.toList());
        System.out.println(materials);
    }
}


