package cn.com.duiba.nezha.alg.common.model.mainmeetselect;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;


public class ActivitySelector {

    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;  //100次以前的观察，无效
        static int SEARANK_TOPN = 30;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;
    }

    public static  int getCoef(double hisRequest, double request, double hisClick, double click)
    {
        int coef = 1;
        int i = 1,j=1;
        if(request < 0)
        {
            for(i = 1;i<144;i++)
            {
                request += hisRequest/144;
                if(request > 0)
                    break;
            }
        }
        if(click < 0)
        {
            for(j = 1;j<144;j++)
            {
                click += hisClick/144;
                if(click > 0)
                    break;
            }
        }
        coef = coef + Math.max(i,j);
        return coef;
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1);
        }
    };

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {

        List<ActivityInfo> result = new ArrayList<>();

        Queue<MatchInfo> candis = new PriorityQueue<>(activityInfos.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(activityInfos.size(), iComparator);
        Queue<MatchInfo> appCandis = new PriorityQueue<>(activityInfos.size(), iComparator);
        Queue<MatchInfo> globalCandis = new PriorityQueue<>(activityInfos.size(), iComparator);


        for (ActivityInfo activity : activityInfos) {

            try {

                if(activity.source != 1)
                    continue;
                if(activity.valid == false)
                    continue;

                activity.hisClick.globalVal = activity.click.globalVal;
                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;
                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;

                //新活动试投
                int limit = topn;
                if (activity.hisRequest.globalVal < 100) {


                    System.out.println(activity.activityId+"************************");
                    //continue;
                    if(System.currentTimeMillis() - activity.createTime < 60 * 1000 * 60 * 24 * 3)
                    {
                        if (Math.random() < 0.0001) {
                            result.add(activity);
                            topn--;
                        }
                    }
                    else if (activityInfos.size() > limit) {
                        if (Math.random() < 0.00001) {
                            result.add(activity);
                            topn--;
                        }
                    }
                } else {
                    //计算matchscore
//                    System.out.println(activity.mainMeetId + " "+activity.source+" "+activity.activityId);


                    double slotScore = WilsonInterval.wilsonCalc((long) activity.hisClick.slotVal, (long) activity.hisRequest.slotVal * 3).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long) activity.hisClick.globalVal, (long) activity.hisRequest.globalVal * 3).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long) activity.hisClick.appVal, (long) activity.hisRequest.appVal * 3).lowerBound;

                    double coef = 0, matchscore = 0;

                    double sconfidence = Math.min(activity.hisRequest.slotVal / 100, 1);
                    double aconfidence = Math.min(activity.hisRequest.appVal / 100, 1);
                    double gconfidence = Math.min(activity.hisRequest.globalVal / 1000, 1);

                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

//                    System.out.println(sconfidence+" "+aconfidence+" "+gconfidence );
                    System.out.println("activity.activityId="+activity.activityId+" mainMeetId="+activity.mainMeetId+" matchscore="+matchscore);

                    System.out.println(activity.hisClick.slotVal+" "+activity.hisClick.globalVal+" "+activity.hisRequest.globalVal+" ");
                    MatchInfo info = new MatchInfo();
                    info.act = activity;
                    info.score = matchscore;
                    candis.add(info);

                    if (sconfidence > 0.99 || activity.hisClick.slotVal > 5) {
                        MatchInfo info2 = new MatchInfo();
                        info2.act = activity;
                        info2.score = activity.hisRequest.slotVal > 0 ? activity.hisCost.slotVal / activity.hisRequest.slotVal : 0;
                        slotCandis.add(info2);
//                        System.out.println("slotCandis="+info2.act.activityId);
                    }

                    if (aconfidence > 0.99 || activity.hisClick.slotVal > 5) {
                        MatchInfo info2 = new MatchInfo();
                        info2.act = activity;
                        info2.score = activity.hisRequest.appVal > 0 ? activity.hisCost.appVal / activity.hisRequest.appVal : 0;
                        appCandis.add(info2);
                    }


                }
            }catch (Exception e)
            {
                logger.error("error, act:{}", JSON.toJSONString(activity));
                logger.error(e.getMessage(), e);
            }
//            System.out.println("BBBBBBBBBBBBBBBBB");

        }

        HashSet<Long> idset = new HashSet();


        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; i++) {
            ActivityInfo act =  slotCandis.poll().act;
            result.add(act);
//            System.out.println("1="+act.activityId);
            idset.add(act.activityId);
        }

//        int size = candis.size();
//        for (int i = 0; i < topn && i < size; i++) {
//            ActivityInfo act =  candis.poll().act;
//
//            if(slotCandis.contains(act.activityId))
//                continue;
//            System.out.println();
//            System.out.println("2="+act.activityId);
//            result.add(act);
//            idset.add(act.activityId);
//        }

        if(result.size() < topn)
        {


            int count = topn;
            for (ActivityInfo activity : activityInfos){
//                System.out.println(activity.source);
//                System.out.println(activity.valid);
//                System.out.println(idset.contains(activity.activityId));
                if (activity.source != 1)
                    continue;
                if(activity.valid == false)
                    continue;
                if(idset.contains(activity.activityId))
                    continue;
//                System.out.println("DDDDDSSSSSAAAAAs");
                idset.add(activity.activityId);


                activity.hisClick.globalVal = activity.click.globalVal;
//                System.out.println("DDDDDSSSSSddddAAAAAss");

                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;


                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;

                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;

                result.add(activity);
                count++;

                if(count >= topn)
                    break;
            }
        }

//        System.out.println("result.size="+result.size());
        return result;
    }

    //100 - 10 - 1
    public static MainMeet select(MainMeet mainMeet) {

        List<ActivityInfo> activityInfos = mainMeet.activityInfo;

        //1、init
        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();

        List<ActivityInfo> candiList = new ArrayList<>();

        double decay = Constant.DECAY;

        int size = 0;

        HashMap<Long, RankInfo> mMap = new HashMap();
        double maxG = Constant.MIN_REWARD, maxH = Constant.MIN_REWARD, maxA = Constant.MIN_REWARD;
        List<ActivityInfo> totalResult = new ArrayList<ActivityInfo>();
        ActivityInfo result = new ActivityInfo();
        MainMeet mainmeet = new MainMeet();


        try {

            //2、match
//            System.out.println("JJJJJJJJJJJJJJJJJJJJ");

            List<ActivityInfo> MainMeetAndActivityInfos  = mainMeettoActivity(activityInfos,mainMeet.mainMeetActivitysList);

            List<ActivityInfo> matchActivityInfos = match(MainMeetAndActivityInfos, Constant.SEARANK_TOPN);

            size = MainMeetAndActivityInfos.size();

            //3、rank
            //3.1 get info
            for (ActivityInfo act : matchActivityInfos) {
                //get global data
                RankInfo info = mMap.containsKey(act.activityId) ? mMap.get(act.activityId) : new RankInfo();
                double grpm = act.hisRequest.globalVal > 0 ? act.hisClick.globalVal / act.hisRequest.globalVal : 0;
                info.grpm = grpm;
                info.gexp = act.hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);

                System.out.println(act.mainMeetId+" "+act.activityId+" "+"hisClick.globalVal="+act.hisClick.globalVal+" hisRequest.globalVal="+act.hisRequest.globalVal+" grpm="+grpm);

                //get app data
                double arpm = act.hisRequest.appVal > 0 ? act.hisCost.appVal / act.hisRequest.appVal : 0;


                System.out.println(act.mainMeetId+" "+act.activityId+" "+"hisCost.appVal="+act.hisCost.appVal+" hisRequest.appVal="+act.hisRequest.appVal+" arpm="+arpm);

                info.arpm = arpm;
                info.aexp = act.hisRequest.appVal;
                if (info.hexp > 50)
                    maxA = Math.max(arpm, maxA);

                //get slot data
                double hrpm = act.hisRequest.slotVal > 0 ? act.hisCost.slotVal / act.hisRequest.slotVal : 0;
                info.hrpm = hrpm;
                info.hexp = act.hisRequest.slotVal;
                if (info.hexp > 50)
                    maxH = Math.max(hrpm, maxH);

                System.out.println(act.mainMeetId+" "+act.activityId+" "+"hisCost.slotVal="+act.hisCost.slotVal+" hisRequest.slotVal="+act.hisRequest.slotVal+" hrpm="+hrpm);


                mMap.put(act.activityId, info);
            }



            for (ActivityInfo act : matchActivityInfos) {

//
                if (act.request.globalVal > 0) {
                    double reward = Constant.MIN_REWARD;
//                    System.out.println("12 "+act.mainMeetId+" "+act.activityId);
                    double sconfidence = Math.min(act.hisRequest.slotVal / 60, 1);
                    double aconfidence = Math.min(act.hisRequest.appVal / 60, 1);

                    reward = sconfidence * normlize(mMap.get(act.activityId).hrpm * 0.8, maxH, 0.8) +
                            (1 - sconfidence) * aconfidence * normlize(mMap.get(act.activityId).arpm * 0.7, maxA, 0.7) +
                            (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(mMap.get(act.activityId).grpm * 0.5, maxG, 0.6);
                    //System.out.println(sconfidence+" "+(1 - sconfidence) * aconfidence+" "+(1 - sconfidence - (1 - sconfidence) * aconfidence));

                    reward = reward * reward;

                    reward = Math.max(reward, Constant.MIN_REWARD);

                    act.reward = act.reward * decay + reward;
                    act.count = act.count * decay + 1.0;

                    System.out.println("mainMeetId="+act.mainMeetId+" activityId="+act.activityId+" "+act.reward/act.count);
                    long oneday = 24 * 60 * 60 * 1000;
                    if ((sconfidence > 0.99 || System.currentTimeMillis() - act.updateTime > oneday))    //临时脏数据修复代码
                    {
                        if (act.reward / act.count < 0.6 * reward || act.reward / act.count > 1.6 * reward) {
                            act.reward = 10 * reward;
                            act.count = 10;
                        }
                    }

                    act.alpha = 1.5 + act.reward;
                    act.beta = 2.0 + (act.count - act.reward);

                }

                rewards.add(act.reward);
                counts.add(act.count);
                alphas.add(act.alpha);
                betas.add(act.beta);
                candiList.add(act);
            }

            //4、select

            int numMachines = candiList.size();

            result = candiList.get(selectMachine(alphas, betas, numMachines));

            //System.out.println(rewards.toString()+" "+alphas.toString()+" "+betas.toString()+" "+numMachines+" "+selectMachine(alphas, betas, numMachines));

            if(System.currentTimeMillis() - result.updateTime > 60 * 1000) //1分钟更新一次
            {
                result.isUpdate = true;
            }
            mMap.clear();

//            System.out.println("result.activityId "+result.activityId+" result.mainMeetId"+result.mainMeetId);

            result.lastRequest.appVal = result.request.appVal;
            result.lastRequest.slotVal = result.request.slotVal;
            result.lastRequest.globalVal = result.request.globalVal;

            result.lastClick.appVal = result.click.appVal;
            result.lastClick.slotVal = result.click.slotVal;
            result.lastClick.globalVal = result.click.globalVal;

            result.lastCost.appVal = result.cost.appVal;
            result.lastCost.slotVal = result.cost.slotVal;
            result.lastCost.globalVal = result.cost.globalVal;
            //print(result);


            ActivityInfo saveAct = new ActivityInfo();

            if(result.mainMeetId != -1){
                mainmeet.activityInfo = setParam(getAllMainMeet(activityInfos).get(result.mainMeetId),result);
            }else{

                List<ActivityInfo> actSelect = new ArrayList<ActivityInfo>();
                actSelect.add(result);
                mainmeet.activityInfo = actSelect;
            }
            mainmeet.mainMeetActivitysList = getNewMainMeetRelation(activityInfos);

//            System.out.println(saveAct.mainMeetActivitysList.size());

            return mainmeet;
        }catch (Exception e)
        {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(activityInfos));
        }
        return mainmeet;
    }

    public static  void print(ActivityInfo act) {
        System.out.println("-----------" + act.mainMeetId + "-----------");
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.directRequest.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("click = " + act.directClick.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("cost = " + act.directCost.slotVal + "\t" + act.cost.appVal + "\t" + act.cost.globalVal);
        //System.out.println("click = " + act.directClick.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastClick = " + act.lastClick.slotVal + "\t" + act.lastClick.appVal + "\t" + act.lastClick.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
    }
    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static List<ActivityInfo> setParam(List<ActivityInfo> activityInfos,ActivityInfo result){
        List<ActivityInfo> temp = new ArrayList<ActivityInfo>();
//        temp.addAll(activityInfos);
        for (ActivityInfo act : activityInfos){
            temp.add(actClone(result));

        }
        return temp;
    }


    public static List<List<Long>> getNewMainMeetRelation(List<ActivityInfo> activityInfos) {
        Map<Long, List<ActivityInfo>> newMainMeetActivitysList = new HashMap<Long, List<ActivityInfo>>();
        for (ActivityInfo activity : activityInfos) {
            if (activity.mainMeetId != -1 && activity.mainMeetId != 0) {
                if (!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                    ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                    newMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId, newMainArr);


                } else {
                    List<ActivityInfo> olfMainArr = newMainMeetActivitysList.get(activity.mainMeetId);
                    olfMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId, olfMainArr);
                }
            }

        }
        List<List<Long>> newMainMeetSave = new ArrayList<List<Long>>();
        for (Map.Entry<Long, List<ActivityInfo>> entry : newMainMeetActivitysList.entrySet()) {

            ArrayList acts = new ArrayList<Long>();
            acts.add(entry.getKey());
            for (ActivityInfo activity : entry.getValue()) {
                acts.add(activity.activityId);
            }
            newMainMeetSave.add(acts);

        }
        return  newMainMeetSave;
    }

    public static Map<Long,List<ActivityInfo>> getAllMainMeet(List<ActivityInfo> activityInfos){
        List<List<Long>>  oldMainMeetActivitysList = null;
        Map<Long,List<ActivityInfo>>  newMainMeetActivitysList = new HashMap<Long,List<ActivityInfo>>();
        List<ActivityInfo> noMainMeetactivityInfos = new ArrayList<ActivityInfo>();

        for (ActivityInfo activity : activityInfos) {

            if(activity.activityId == -100)
                continue;
            if(activity.mainMeetId != -1 && activity.mainMeetId != 0) {
                if(!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                    ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                    newMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId,newMainArr);


                }else {
                    List<ActivityInfo> olfMainArr = newMainMeetActivitysList.get(activity.mainMeetId);
                    olfMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId,olfMainArr);
//                    System.out.println("activity.mainMeetId2"+activity.mainMeetId);
                }
            }
        }
        return newMainMeetActivitysList;


    }


    /****
     * 主会场转活动
     * @param activityInfos
     * @param mainMeetActivitysList
     * @return 主会场活动列表
     */
    public static List<ActivityInfo> mainMeettoActivity(List<ActivityInfo> activityInfos,List<List<Long>> mainMeetActivitysList){


        List<List<Long>>  oldMainMeetActivitysList = null;
        Map<Long,List<ActivityInfo>>  newMainMeetActivitysList = new HashMap<Long,List<ActivityInfo>>();
        List<ActivityInfo> noMainMeetactivityInfos = new ArrayList<ActivityInfo>();
        oldMainMeetActivitysList = mainMeetActivitysList;
        for (ActivityInfo activity : activityInfos) {

            if(activity.mainMeetId != -1 && activity.mainMeetId != 0) {
//                System.out.println("activity.mainMeetId44="+activity.mainMeetId);

                if(!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                    ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                    newMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId,newMainArr);
//                    System.out.println("activity.mainMeetId1"+activity.mainMeetId);


                }else {
                    List<ActivityInfo> olfMainArr = newMainMeetActivitysList.get(activity.mainMeetId);
                    olfMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId,olfMainArr);
//                    System.out.println("activity.mainMeetId2"+activity.mainMeetId);
                }
            }
            else {
                noMainMeetactivityInfos.add(activity);
            }
        }

        boolean initFlag = true;
        List<List<Long>> newMainMeetSave = new ArrayList<List<Long>>();
        for (Map.Entry<Long, List<ActivityInfo>> entry : newMainMeetActivitysList.entrySet()) {

            ArrayList acts = new ArrayList<Long>();
            acts.add(entry.getKey());
            for(ActivityInfo activity:entry.getValue()){
                acts.add(activity.activityId);
            }
            newMainMeetSave.add(acts);
        }
        if (oldMainMeetActivitysList == null) {
            initFlag = false;
            oldMainMeetActivitysList = new ArrayList<List<Long>>();
            oldMainMeetActivitysList.addAll(newMainMeetSave);

        }

        for(List<Long> mainMeet:newMainMeetSave){

            long mainMeetId = mainMeet.get(0);
//            System.out.println("mainMeetId="+mainMeetId);
            List<ActivityInfo> tempMainMeet= newMainMeetActivitysList.get(mainMeetId);

//            System.out.println("DDDDDDD"+tempMainMeet.size());

            long ClickGlobalVal = 0;
            long ClickSlotVal = 0;
            long ClickAppVal = 0;
            long CostGlobalVal = 0;
            long CostAppVal = 0;
            long CostSlotVal = 0;
            long RequestGlobalVal = 0;
            long RequestAppVal = 0;
            long RequestSlotVal = 0;
//            System.out.println(tempMainMeet.get(0).activityId);
            ActivityInfo mainMeetCastActivity = actClone(tempMainMeet.get(0));

            double missRequest = 0.0d;
//            System.out.println("KKKKKKKKKKKKKKKKKKK");
            if(equalMainMeet(mainMeet, tempMainMeet) && initFlag) {
                boolean first = true;
//                System.out.println("HHHHHHHHHHHHHHHHHHHHHHH");
                for(ActivityInfo activityInfo : tempMainMeet){
                    System.out.println(activityInfo.mainMeetId+" "+activityInfo.activityId);
                    //(activityInfo.missRequest.slotVal != 0 || activityInfo.missRequest.appVal!= 0 || activityInfo.missRequest.globalVal!= 0) &&
//                    System.out.println("missRequestquest="+activityInfo.missRequest);
                    if( ((activityInfo.missRequest!= null) && ( activityInfo.missRequest.slotVal != 0 || activityInfo.missRequest.appVal!= 0 || activityInfo.missRequest.globalVal!= 0)) && first) {
                        RequestSlotVal+= activityInfo.missRequest.slotVal;
                        RequestAppVal += activityInfo.missRequest.appVal;
                        RequestGlobalVal += activityInfo.missRequest.globalVal;
                        first = false;
                    }

                    ClickGlobalVal += activityInfo.click.globalVal;
                    ClickAppVal += activityInfo.click.appVal;
                    ClickSlotVal += activityInfo.click.slotVal;
                    CostGlobalVal += activityInfo.cost.globalVal;
                    CostAppVal += activityInfo.cost.appVal;
                    CostSlotVal += activityInfo.cost.slotVal;
                    RequestGlobalVal += activityInfo.request.globalVal;
                    RequestAppVal += activityInfo.request.appVal;
                    RequestSlotVal += activityInfo.request.slotVal;
                }

            }else {

//                System.out.println("GGGGGGGGGGGGGGGGGGGGGGGGGG");
                boolean first = true;
                for(ActivityInfo activityInfo : tempMainMeet){
                    if(mainMeet.indexOf(activityInfo.activityId) != -1 && initFlag)  {
                        //(activityInfo.missRequest.slotVal != 0 || activityInfo.missRequest.appVal!= 0 || activityInfo.missRequest.globalVal!= 0)&&
                        if(  ((activityInfo.missRequest!= null) &&( activityInfo.missRequest.slotVal != 0 || activityInfo.missRequest.appVal!= 0 || activityInfo.missRequest.globalVal!= 0)) && first) {
                            RequestSlotVal+= activityInfo.missRequest.slotVal;
                            RequestAppVal += activityInfo.missRequest.appVal;
                            RequestGlobalVal += activityInfo.missRequest.globalVal;
                            first = false;

                        }
                        ClickGlobalVal += activityInfo.click.globalVal;
                        ClickAppVal += activityInfo.click.appVal;
                        ClickSlotVal += activityInfo.click.slotVal;
                        CostGlobalVal += activityInfo.cost.globalVal;
                        CostAppVal += activityInfo.cost.appVal;
                        CostSlotVal += activityInfo.cost.slotVal;
                        RequestGlobalVal += activityInfo.request.globalVal;
                        RequestAppVal += activityInfo.request.appVal;
                        RequestSlotVal += activityInfo.request.slotVal;
//                        System.out.println("AAAAAAAAAAAAAAA");
                    }else {

                        RequestSlotVal += 19/3;
                        RequestAppVal += 25.5/3;
                        RequestGlobalVal += 594.5/3;

                        ClickSlotVal += 5/3;
                        ClickAppVal += 6/3;
                        ClickGlobalVal += 95.5/3;


                        CostSlotVal += 185/3;
                        CostAppVal += 241.5/3;
                        CostGlobalVal += 1293/3;
//                        System.out.println("FFFFFAAAA");


                    }
                }


            }

            mainMeetCastActivity.mainMeetId = mainMeetId;
            //missRequest =  activityInfo.missRequest;
            mainMeetCastActivity.click.globalVal = ClickGlobalVal;
            mainMeetCastActivity.click.appVal = ClickAppVal;
            mainMeetCastActivity.directClick.slotVal = ClickSlotVal;
            mainMeetCastActivity.cost.globalVal = CostGlobalVal;
            mainMeetCastActivity.cost.appVal = CostAppVal;
            mainMeetCastActivity.directCost.slotVal = CostSlotVal;
            mainMeetCastActivity.request.globalVal = RequestGlobalVal;
            mainMeetCastActivity.request.appVal = RequestAppVal;
            mainMeetCastActivity.directRequest.slotVal = RequestSlotVal;


//          System.out.println("ASSASSASAS");
            noMainMeetactivityInfos.add(mainMeetCastActivity);
        }
//        System.out.println("GGGGGGGGGGGGG");

//        System.out.println("noMainMeetactivityInfos="+noMainMeetactivityInfos.size());
        return noMainMeetactivityInfos;
    }


    /*****
     * 比较新旧关系是否相等
     * @param oldMainMeetActivity
     * @param newMainMeetActivitys
     * @return
     */

    public static boolean equalMainMeet(List<Long>  oldMainMeetActivity,List<ActivityInfo> newMainMeetActivitys){

        boolean flag = true;
        if ((oldMainMeetActivity.size() -1) != newMainMeetActivitys.size()) { //去除主会场id
            return false;
        }
        int count = 0;
        for(int i = 1;i < oldMainMeetActivity.size();++i){
            for(int j = 0; j < newMainMeetActivitys.size(); ++j) {
                if(oldMainMeetActivity.get(i) == newMainMeetActivitys.get(j).activityId) {
                    count += 1;
                }


            }
        }
        if (count == newMainMeetActivitys.size()) {
            flag = true;
        }
        else {
            flag = false;
        }
        return flag;
    }
    public ActivitySelector() { //下周

    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0;
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
//        System.out.println("numMachines="+numMachines);
//        System.out.println("selectMachine="+selectMachine);

        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0 ? clk / exp : 0;
    }

    private double sum(List<Long> list) {
        double sum = 0;
        for (Long val : list) {
            sum += val;
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null)
            return 0;
        long fenzi = (long) (ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null)
            return 0;
        if (ratio == 0) {
            ratio = 0.00000001;
        }
        long fenmu = (long) (num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null)
            return 0;
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi.longValue(), fenmu.longValue());
        return pair.lowerBound;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    private static ActivityInfo actClone(ActivityInfo originAct){
        ActivityInfo act =  new ActivityInfo();
        act.mainMeetId =  originAct.mainMeetId;
        act.activityId = originAct.activityId ;
        act.source = originAct.source;
        act.alpha = originAct.alpha;
        act.beta = originAct.beta;
        act.reward = originAct.reward;
        act.count = originAct.count;
        act.slotId = originAct.slotId;


        ActivityInfo.Val val = act.getVal();
        val = act.getVal();
        val.globalVal = originAct.hisRequest.globalVal;
        val.appVal = originAct.hisRequest.appVal;
        val.slotVal = originAct.hisRequest.slotVal;
        act.hisRequest = val;

        val = act.getVal();
        val.globalVal = originAct.hisSend.globalVal;
        val.appVal = originAct.hisSend.appVal;
        val.slotVal = originAct.hisSend.slotVal;
        act.hisSend = val;

        val = act.getVal();
        val.globalVal = originAct.hisClick.globalVal;
        val.appVal = originAct.hisClick.appVal;
        val.slotVal = originAct.hisClick.slotVal;
        act.hisClick = val;

        val = act.getVal();
        val.globalVal = originAct.hisCost.globalVal;
        val.appVal = originAct.hisCost.appVal;
        val.slotVal = originAct.hisCost.slotVal;
        act.hisCost = val;

        val = act.getVal();
        val.globalVal = originAct.send.globalVal;
        val.appVal = originAct.send.appVal;
        val.slotVal = originAct.send.slotVal;
        act.send = val;

        val = act.getVal();
        val.globalVal = originAct.directSend.globalVal;
        val.appVal = originAct.directSend.appVal;
        val.slotVal = originAct.directSend.slotVal;
        act.directSend = val;

        val = act.getVal();
        val.globalVal = originAct.request.globalVal;
        val.appVal = originAct.request.appVal;
        val.slotVal = originAct.request.slotVal;
        act.request = val;

        val = act.getVal();
        val.globalVal = originAct.directRequest.globalVal;
        val.appVal = originAct.directRequest.appVal;
        val.slotVal = originAct.directRequest.slotVal;
        act.directRequest = val;

        val = act.getVal();
        val.globalVal = originAct.click.globalVal;
        val.appVal = originAct.click.appVal;
        val.slotVal = originAct.click.slotVal;
        act.click = val;

        val = act.getVal();
        val.globalVal = originAct.directClick.globalVal;
        val.appVal = originAct.directClick.appVal;
        val.slotVal = originAct.directClick.slotVal;
        act.directClick = val;

        val = act.getVal();
        val.globalVal = originAct.cost.globalVal;
        val.appVal = originAct.cost.appVal;
        val.slotVal = originAct.cost.slotVal;
        act.cost = val;

        val = act.getVal();
        val.globalVal = originAct.directCost.globalVal;
        val.appVal = originAct.directCost.appVal;
        val.slotVal = originAct.directCost.slotVal;
        act.directCost = val;

        val = act.getVal();
        val.globalVal = originAct.lastSend.globalVal;
        val.appVal = originAct.lastSend.appVal;
        val.slotVal = originAct.lastSend.slotVal;
        act.lastSend = val;

        val = act.getVal();
        val.globalVal = originAct.lastRequest.globalVal;
        val.appVal = originAct.lastRequest.appVal;
        val.slotVal = originAct.lastRequest.slotVal;
        act.lastRequest = val;

        val = act.getVal();
        val.globalVal = originAct.lastClick.globalVal;
        val.appVal = originAct.lastClick.appVal;
        val.slotVal = originAct.lastClick.slotVal;
        act.lastClick = val;

        val = act.getVal();
        val.globalVal = originAct.lastCost.globalVal;
        val.appVal = originAct.lastCost.appVal;
        val.slotVal = originAct.lastCost.slotVal;
        act.lastCost = val;

        act.updateTime = originAct.updateTime;
        act.isUpdate = originAct.isUpdate;
        act.missRequest = originAct.missRequest;
        act.valid = originAct.valid;
        act.createTime = originAct.createTime;
        act.updateTime = originAct.updateTime;
        act.isUpdate = originAct.isUpdate;

        return act;


    }
}