package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Array;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description 加大试投比例
 * @date 2019/12/26
 */
public class ActivityRec46 {

    private static final Logger logger= LoggerFactory.getLogger(ActivityRec46.class);

    static class Constant {
        static double MIN_REWARD=0.1;
        static double DECAY=0.99;
        // 海选召回的数量
        static int SEARANK_TOPN=30;
        static int EXCELLENT_TOPN=20;
        // 优质活动或消耗较高的活动试投个数
        static int EXCN = 1;
        // 优质活动或消耗较高的活动试投阈值
        static int THR = 5000;
        // 优质活动或消耗高的活动试投流量占比
        static double PROBL = 0.2;
        // 公平竞争阶段次优解集比例系数
        static double LEVEL = 0.8;
        // 公平竞争阶段次优解被推出的概率
        static double PROBH = 0.3;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/26
     * @methodParameters:
     * @methodReturnType:
     * @description: 4.6海选
     */
    public static List<ActivityMatchInfo> match (List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        return ActivityRec42.match(actData, actAds, exActs);
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/26
     * @methodParameters:
     * @methodReturnType:
     * @description: 4.6优选: 加大试投比例，新增可调参数excN,thr,probL,level,probH
     */
    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData, List<Double> parameters) {
        int exeN = Constant.EXCN;
        int thr = Constant.THR;
        double probL = Constant.PROBL;
        double level = Constant.LEVEL;
        double probH = Constant.PROBH;

        if(parameters.size() == 5){
            exeN = parameters.get(0).intValue();
            thr = parameters.get(1).intValue();
            probL = parameters.get(2);
            level = parameters.get(3);
            probH = parameters.get(4);
        }

        RankResult rankResult=new RankResult();

        //判断列表长度，不一致抛异常
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }

        if (actModel.size() != actData.size()) {
            rankResult.activityModel=actModel.get(0);
            rankResult.similarCostActivitiesInfo=null;
            return rankResult; //todo 抛异常
        }
        //活动id倒排
        List<ActivityRankInfo> actModelCopy =
                actModel.stream()
                        .sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed())
                        .collect(Collectors.toList());
        List<ActivityMatchInfo> actDataCopy =
                actData.stream()
                        .sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed())
                        .collect(Collectors.toList());

        //活动 id 对不上返回空
        for (int i=0; i < actModelCopy.size(); ++i) {
            long activityIdMode=actModelCopy.get(i).activityId;
            long activityIdData=actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                rankResult.activityModel=actModel.get(0);
                rankResult.similarCostActivitiesInfo=null;
                return rankResult; // todo 抛异常
            }
        }

        // 活动访问pv
        ArrayList<Double> requests=new ArrayList<>();
        // 每pv消耗收益
        ArrayList<Double> rewards=new ArrayList<>();
        ArrayList<Double> counts=new ArrayList<>();
        // 贝塔分布alpha和beta
        ArrayList<Double> alphas=new ArrayList<>();
        ArrayList<Double> betas=new ArrayList<>();
        // 转化分
        ArrayList<Double> changeScores=new ArrayList<>();
        // 广告位置信cvr
        ArrayList<Double> cvrBiass = new ArrayList<>();
        ArrayList<Long> activityIds=new ArrayList<>();
        ArrayList<Long> activityTypes=new ArrayList<>();
        // 每pv消耗
        ArrayList<Double> grpms=new ArrayList<>();
        ArrayList<Double> arpms=new ArrayList<>();
        ArrayList<Double> hrpms=new ArrayList<>();
        // 是否是优质活动
        ArrayList<Boolean> excellents=new ArrayList<>();
        ArrayList<Integer> subTypes=new ArrayList<>();
        // 归一化score
        ArrayList<Double> scores=new ArrayList<>();
        List<ActivityRankInfo> candiList=new ArrayList<>();

        double decay= Constant.DECAY;

        int size=0;

        HashMap<Long, RankInfo> mMap=new HashMap();
        double maxG= Constant.MIN_REWARD, maxH= Constant.MIN_REWARD, maxA= Constant.MIN_REWARD;
        double minG=0, minH= Constant.MIN_REWARD, minA= Constant.MIN_REWARD;
        ActivityRankInfo result=new ActivityRankInfo();

        try {
            for (int i=0;i<actDataCopy.size();++i) {
                RankInfo info=mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                // 全局每pv消耗
                double grpm=actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / actDataCopy.get(i).hisRequest.globalVal : 0;
                info.grpm=grpm;
                info.gexp=actDataCopy.get(i).hisRequest.globalVal;
                maxG=Math.max(grpm, maxG);

                // 媒体每pv消耗
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ?
                        actDataCopy.get(i).hisCost.appVal / actDataCopy.get(i).hisRequest.appVal : 0;
                info.arpm=arpm;
                info.aexp=actDataCopy.get(i).hisRequest.appVal;
                if (info.aexp > 100) {
                    maxA=Math.max(arpm, maxA);
                }
                minA=Math.min(arpm, minA);

                // 广告位每pv消耗
                double hrpm=actDataCopy.get(i).hisRequest.slotVal > 0 ? actDataCopy.get(i).hisCost.slotVal / actDataCopy.get(i).hisRequest.slotVal : 0;
                info.hrpm=hrpm;
                info.hexp=actDataCopy.get(i).hisRequest.slotVal;
                if(info.hexp > 100) {
                    maxH=Math.max(hrpm, maxH);
                }
                minH=Math.min(hrpm, minH);

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i=0;i<actDataCopy.size();++i) {
                requests.add(actDataCopy.get(i).hisRequest.slotVal);
                double hrpm=mMap.get(actDataCopy.get(i).activityId).hrpm;
                double arpm=mMap.get(actDataCopy.get(i).activityId).arpm;
                double grpm=mMap.get(actDataCopy.get(i).activityId).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(actDataCopy.get(i).isExcellent);
                subTypes.add(actDataCopy.get(i).subType);
                scores.add(actDataCopy.get(i).score);
                cvrBiass.add(actDataCopy.get(i).cvrBias);

                double reward= Constant.MIN_REWARD;
                double sconfidence=Math.min(actDataCopy.get(i).hisRequest.slotVal / 100, 1);
                double aconfidence=Math.min(actDataCopy.get(i).hisRequest.appVal / 100, 1);

                reward=sconfidence * normlize( hrpm * 0.8, maxH, 0.8) +
                        (1 - sconfidence) * aconfidence * normlize(arpm * 0.7, maxA, 0.7) +
                        (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(grpm * 0.5, maxG, 0.6);

                reward=reward * reward;

                reward=Math.max(reward, 0);

                actModelCopy.get(i).reward=actModelCopy.get(i).reward * decay+reward;
                actModelCopy.get(i).count=actModelCopy.get(i).count * decay+1.0;
                actModelCopy.get(i).alpha=1.5+actModelCopy.get(i).reward;
                actModelCopy.get(i).beta=2.0+(actModelCopy.get(i).count - actModelCopy.get(i).reward);

                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityIds.add(actModelCopy.get(i).activityId);
                activityTypes.add(actDataCopy.get(i).activityType);
                changeScores.add(actDataCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            int numMachines=candiList.size();
            SelectInfoDetail selectInfoDetail =
                    selectMachineWithChangeScore(alphas, betas, activityTypes
                            , activityIds,changeScores,numMachines, hrpms,
                            arpms, grpms, requests, excellents, subTypes, scores,cvrBiass, thr, probL, level, probH);

            int selectedActivityIndex=selectInfoDetail.index;
            result=candiList.get(selectedActivityIndex);
            result.strategyType=selectInfoDetail.strategyType;
            double maxChangeScore=selectInfoDetail.maxChangeScore;

            List<SimilarCostActivitiesInfo> sameCostActivitiesInfoList=new ArrayList<>();
            //消耗分相近的活动信息
            ArrayList<SelectPoolInfo> sameCostcondi=selectInfoDetail.condi;
            if(sameCostcondi.size() > 0){
                double selectedActivityReward=sameCostcondi.get(0).getReward();
                int sameCostActivityCnt=sameCostcondi.size();

                for (SelectPoolInfo selectInfo:sameCostcondi){

                    SimilarCostActivitiesInfo sameCostActivitiesInfo=new SimilarCostActivitiesInfo();

                    Long activityId=selectInfo.getActivityId();
                    Long activityType=selectInfo.getActivityType();

                    int ifSelected=0;
                    if (selectInfo.getIndex() == selectedActivityIndex){
                        ifSelected=1;
                    }

                    int index=selectInfo.getIndex();

                    double mabReward=selectInfo.getReward();
                    double changeScore=selectInfo.getChangeScore();
                    double hrpm=selectInfo.getHrpm();
                    double arpm=selectInfo.getArpm();
                    double grpm=selectInfo.getGrpm();
                    int subType=selectInfo.getSubType();
                    boolean excellent=selectInfo.isExcellent();

                    //计算与最优的差异
                    double diffReward= selectInfo.getReward()-selectedActivityReward;
                    double diffChangeScore=selectInfo.getChangeScore() - maxChangeScore;

                    //封装
                    sameCostActivitiesInfo.activityId=activityId;
                    sameCostActivitiesInfo.sameActivityCnt=sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType=activityType;
                    sameCostActivitiesInfo.ifSelected=ifSelected;
                    sameCostActivitiesInfo.mabReward=mabReward;
                    sameCostActivitiesInfo.changeScore=changeScore;
                    sameCostActivitiesInfo.index=index;
                    sameCostActivitiesInfo.hrpm=hrpm;
                    sameCostActivitiesInfo.arpm=arpm;
                    sameCostActivitiesInfo.grpm=grpm;
                    sameCostActivitiesInfo.diffReward=diffReward;
                    sameCostActivitiesInfo.diffChangeScore=diffChangeScore;
                    sameCostActivitiesInfo.subType=subType;
                    sameCostActivitiesInfo.isExcellent=excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }

            rankResult.activityModel=result;
            rankResult.similarCostActivitiesInfo=sameCostActivitiesInfoList;

            mMap.clear();

            return rankResult;
        }catch (Exception e)
        {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }

    public static double normlize(double val, double max, double limit) {
        double norm=Math.min(val * limit / max, limit);
        return norm;
    }

    /**
     * @author: lijingzhe
     * @date: 2019/12/30
     * @methodParameters:
     * @methodReturnType:
     * @description: 减少对优质活动或消耗高活动试投数量execN，加大对单个活动的试投量级
     * 扶持+兜底：试投比例probL=0.2，阈值thr=5000
     * 公平竞争：>=收益最高值*level=0.8次优解集以probH=0.3概率出
     */
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Integer> subTypes, List<Double> scores, List<Double> cvrBiass, int thr, double probL, double level, double probH) {
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        ArrayList<SelectPoolInfo> sinfos=new ArrayList();
        for (int i=0; i < numMachines; i++) {
            if(activityTypes.get(i) != 21){
                double theta=BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
                SelectPoolInfo sinfo=new SelectPoolInfo();
                sinfo.setReward(theta);
                sinfo.setActivityType(activityTypes.get(i));
                sinfo.setIndex(i);
                sinfo.setActivityId(activityIds.get(i));
                sinfo.setChangeScore(changeScores.get(i));
                sinfo.setHrpm(hrpms.get(i));
                sinfo.setArpm(arpms.get(i));
                sinfo.setGrpm(grpms.get(i));
                sinfo.setRequest(requests.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setScores(scores.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setSubType(subTypes.get(i));
                sinfo.setCvrBias(cvrBiass.get(i));
                sinfos.add(sinfo);
            }
        }

        if(sinfos.size() > 0){
            // 非卡包活动转化分最高活动
            List<SelectPoolInfo> chs = sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed())
                    .collect(Collectors.toList());
            double maxChangeScore = chs.get(0).getChangeScore();
//            double midChangeScore = chs.get(Math.min(chs.size()/2+1, 10)).getChangeScore();

            List<SelectPoolInfo> ranks = sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed())
                    .collect(Collectors.toList());
            double maxRewards = ranks.get(0).getReward();

            List<SelectPoolInfo> viceRanks = ranks.stream().
                    filter(e -> e.getReward() >= 0.8 * maxRewards)
                    .collect(Collectors.toList());

            List<SelectPoolInfo> lowExRanks = ranks.stream().filter(e->e.isExcellent())
                    .sorted(Comparator.comparing(SelectPoolInfo::getScores).reversed())
                    .collect(Collectors.toList());

            List<SelectPoolInfo> conRanks = ranks.stream()
                    .filter(e->e.getChangeScore() >= 0.8 * e.getCvrBias())
                    .collect(Collectors.toList());

            selectInfoDetail.condi = new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
            selectInfoDetail.maxChangeScore = maxChangeScore;

            if(Math.random() < 0.2){
                if(lowExRanks.size() > 0 && lowExRanks.get(0).getRequest() < 5000){
                    selectInfoDetail.index = lowExRanks.get(0).getIndex();
                    selectInfoDetail.strategyType = 1;
                }
            }else{
                if(Math.random() < 0.3 && viceRanks.size() > 0){
                    double sws = viceRanks.stream().map(f->f.getReward()/maxRewards).reduce((a,b)->a+b).get();
                    for (int i = 0; i < viceRanks.size(); i++) {
                        double sw = viceRanks.get(i).getReward()/(maxRewards * sws);
                        if(Math.random() < sw){
                            selectInfoDetail.index = viceRanks.get(i).getIndex();
                            selectInfoDetail.strategyType = 2;
                        }
                    }
                }else{
                    if(conRanks.size() > 0){
                        selectInfoDetail.index = conRanks.get(0).getIndex();
                        selectInfoDetail.strategyType = 3;
                    }
                }
            }

            if(selectInfoDetail==null || selectInfoDetail.strategyType == 0){
                selectInfoDetail.index = ranks.get(0).getIndex();
                selectInfoDetail.strategyType = 5;
            }
        }else{
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = changeScores.get(0);
            selectInfoDetail.condi = new ArrayList<>();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }
}
