package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.BloomFilter;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.*;

@NoArgsConstructor
@Data
public class ExpHourData {
    //数据类型
    private WeightDimEnum dataType;
    //id，用广告id+配置id拼成的
    private String id;
    //yyyymmddhh作为键，当前所在小时的前一小时
    private String lastHour;

    //倒戈了用dto当属性
    private Map<String,HourDto> hourDtoMap;

    //从ExploreData那边抄来的数值安全的除法
    private double division(Long v1, Long v2) {
        return (v1 != null && v2 != null && v2 != 0)  ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }
    //获取最近一个小时的竞价成功率
    public double getSuccessLastHour() {
        HourDto lastHourDto=hourDtoMap.get(lastHour);
        if(lastHourDto==null) {
            return 0.0;
        }
        Long biddingCountLastHour=lastHourDto.getBidReqCount();
        Long exposureCountLastHour=lastHourDto.getAdvertExposure();
        Double result=division(exposureCountLastHour,biddingCountLastHour);
        return DataUtil.formatDouble(result,5);
    }
    //获取最近24小时的竞价成功率
    public double getSuccess24Hour() {
        Collection<HourDto> hourDtoList=hourDtoMap.values();
        Long biddingCount24Hour=0L;
        Long exposureCount24Hour=0L;
        for (HourDto hourDto : hourDtoList) {
            biddingCount24Hour=biddingCount24Hour+hourDto.getBidReqCount();
            exposureCount24Hour=exposureCount24Hour+hourDto.getAdvertExposure();
        }
        Double result=division(exposureCount24Hour,biddingCount24Hour);
        return DataUtil.formatDouble(result,5);
    }

    //获取最近一个小时的真实cvr
    public double getCvrLastHour(Integer convertSubtype) {
        HourDto lastHourDto=hourDtoMap.get(lastHour);
        if(lastHourDto==null) {
            return 0.0;
        }
        Long convertCountLastHour=lastHourDto.getBackendCntMap().getOrDefault(convertSubtype,0L);
        Long clickCountLastHour=lastHourDto.getClickCnt();
        Double result=division(convertCountLastHour,clickCountLastHour);
        return DataUtil.formatDouble(result,5);
    }
    //获取最近24个小时的真实cvr
    public double getCvr24Hour(Integer convertSubtype) {
        Long convertCount24Hour=0L;
        Long clickCount24Hour=0L;
        for (HourDto hourDto: hourDtoMap.values()) {
            convertCount24Hour=convertCount24Hour+hourDto.getBackendCntMap().getOrDefault(convertSubtype,0L);
            clickCount24Hour=clickCount24Hour+hourDto.getClickCnt();
        }
        Double result=division(convertCount24Hour,clickCount24Hour);
        return DataUtil.formatDouble(result,5);
    }

    //获取最近一个小时的融合cvr
    public double getMergeCvrLastHour() {
        HourDto lastHourDto=hourDtoMap.get(lastHour);
        if(lastHourDto==null) {
            return 0.0;
        }
        Double result=lastHourDto.getCvr();
        return DataUtil.formatDouble(result,5);
    }
    //获取最近24个小时的融合cvr
    public double getMergeCvr24Hour() {
        long expCount24Hour=0L;
        double temp=0.0;
        for (HourDto hourDto : hourDtoMap.values()) {
            expCount24Hour=expCount24Hour+hourDto.getAdvertExposure();
            temp=temp+hourDto.getAdvertExposure()*hourDto.getCvr();
        }
        if(expCount24Hour<=0) {
            return 0.0;
        }
        Double result=temp/expCount24Hour;
        return DataUtil.formatDouble(result,5);
    }

    // 获取最近一个小时的竞价成功率
    public double getBidSuccessRatioLastHour() {
        HourDto lastHourDto=hourDtoMap.get(lastHour);
        if(lastHourDto==null) {
            return 0.0;
        }

        Long bidReqCount = lastHourDto.getBidReqCount();
        Long exposure = lastHourDto.getAdvertExposure();

        double bidSuccessRatio = division(exposure, bidReqCount);

        return DataUtil.formatDouble(bidSuccessRatio, 5);
    }

    // 获取最近24小时的竞价成功率
    public double getBidSuccessRatio24Hour() {
        long exposure24Hour = 0L;
        long bidReq24Hour = 0L;

        for (HourDto hourDto : hourDtoMap.values()) {
            exposure24Hour = exposure24Hour + hourDto.getAdvertExposure();
            bidReq24Hour = bidReq24Hour + hourDto.getBidReqCount();
        }

        double bidSuccessRatio = division(exposure24Hour, bidReq24Hour);

        return DataUtil.formatDouble(bidSuccessRatio, 5);
    }

    public static void main(String[] args) {
        HourDto hourDto1=HourDto.getInstance(10000L,4000L,2222L,1113L,123L,44444L,40022L,0.02222);
        HourDto hourDto2=HourDto.getInstance(1000L,400L,222L,113L,12L,4444L,4022L,0.2222);
        Map<String,HourDto> hourDtoMap=new HashMap<String, HourDto>();
        hourDtoMap.put("2020121013",hourDto1);
        hourDtoMap.put("2020121012",hourDto2);

        ExpHourData expHourData=new ExpHourData();
        expHourData.setHourDtoMap(hourDtoMap);
        expHourData.setLastHour("2020121013");
        System.out.println(expHourData.getSuccessLastHour());
        System.out.println(expHourData.getSuccess24Hour());

        System.out.println(expHourData.getCvrLastHour(0));
        System.out.println(expHourData.getCvr24Hour(0));

        System.out.println(expHourData.getCvrLastHour(3));
        System.out.println(expHourData.getCvr24Hour(3));

        System.out.println(expHourData.getMergeCvrLastHour());
        System.out.println(expHourData.getMergeCvr24Hour());
    }
}
