package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.DataUtil;

import java.util.ArrayList;

public class WeightInfoList extends ArrayList<WeightInfo> {

    private double mw = 0.9;

    public double getMw() {
        return mw;
    }

    public WeightInfoList(int initialCapacity) {
        super(initialCapacity);
    }

    /**
     * 重新分配权重
     *
     * @return
     */
    public WeightInfoList reWeight() {
        Double sumWeight = this.stream().map(WeightInfo::getW).reduce(0.0, Double::sum);

        for (WeightInfo weightInfo : this) {
            double newDimWeight = weightInfo.getW() / sumWeight;
            weightInfo.setW(DataUtil.formatDouble(newDimWeight, 4));
            if (weightInfo.getId() != null && weightInfo.getId().equals(WeightDimEnum.MODEL.getId())) {
                this.mw = weightInfo.getW();
            }
        }
        return this;
    }
}
