/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DataUtil {
    public static int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();

    public static <T> T getValueOrDefault(T value, T defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean isLarger(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static Double toDouble(Long value) {
        return DataUtil.long2Double(value, 1L, 0);
    }

    public static double todouble(Double value) {
        double ret = 0.0;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static int toInt(Long value) {
        int ret = 0;
        if (value != null) {
            ret = value.intValue();
        }
        return ret;
    }

    public static Double long2Double(Long value, Long amplification, int newScala) {
        Double ret = null;
        if (value != null && (ret = Double.valueOf(((double)value.longValue() + 0.0) / (double)amplification.longValue())) != null) {
            ret = DataUtil.formatDouble((double)ret, newScala);
        }
        return ret;
    }

    public static double long2double(long value, long amplification, int newScala) {
        double ret = DataUtil.formatdouble(((double)value + 0.0) / (double)amplification, newScala);
        return ret;
    }

    public static Double formatDouble(Double d, int newScala) {
        Double ret = null;
        if (d != null) {
            BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
            ret = bg.doubleValue();
        }
        return ret;
    }

    public static double formatdouble(double d, int newScala) {
        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
        double ret = bg.doubleValue();
        return ret;
    }

    public static Long double2Long(Double value) {
        if (value != null) {
            return DataUtil.double2Long(value, 1L);
        }
        return null;
    }

    public static Long double22Long(Double value, Long amplification) {
        Long ret = null;
        if (amplification == null) {
            amplification = 1L;
        }
        if (value != null) {
            ret = Math.round(value * (double)amplification.longValue());
        }
        return ret;
    }

    public static long double2long(double value, long amplification) {
        return Math.round(value * (double)amplification);
    }

    public static Long double2Long(double value, Long amplification) {
        return Math.round(value * (double)amplification.longValue());
    }

    public static String listToString(List<String> v1) {
        if (v1 == null || v1.size() < 1) {
            return "null";
        }
        return String.join((CharSequence)",", v1);
    }

    public static Long addLong(Long v1, Long v2) {
        Long ret = 0L;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Double addDouble(Double v1, Double v2, int newScala) {
        return DataUtil.formatDouble(DataUtil.addDouble(v1, v2), newScala);
    }

    public static Double addDouble(Double v1, Double v2) {
        Double ret = 0.0;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Double multiplyDouble(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Double multiply(Double v1, Long v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * (double)v2.longValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long multiplyLong(Long v1, Long v2) {
        Long ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Double division(Double v1, Long v2, int newScala) {
        return DataUtil.formatDouble(DataUtil.division(v1, v2), newScala);
    }

    public static Double division(Double v1, Long v2) {
        return DataUtil.division(v1, DataUtil.toDouble(v2));
    }

    public static Double division(Long v1, Double v2, int newScala) {
        return DataUtil.formatDouble(DataUtil.division(v1, v2), newScala);
    }

    public static Double division(Long v1, Double v2) {
        return DataUtil.division(DataUtil.toDouble(v1), v2);
    }

    public static Double division(Long v1, Long v2, int newScala) {
        return DataUtil.formatDouble(DataUtil.division(v1, v2), newScala);
    }

    public static Double division(Long v1, Long v2) {
        return DataUtil.division(DataUtil.toDouble(v1), DataUtil.toDouble(v2));
    }

    public static Double division(Double v1, Double v2, int newScala) {
        return DataUtil.formatDouble(DataUtil.division(v1, v2), newScala);
    }

    public static boolean between(double value, double low, double high) {
        boolean ret = false;
        if (value >= low && value <= high) {
            ret = true;
        }
        return ret;
    }

    public static Double division(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 / (v2 + 1.0E-10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long str2Long(String value, Long defaultVal) {
        Long ret = defaultVal;
        if (value != null && value != "" && value != "null") {
            try {
                ret = Long.valueOf(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String stringStd(String src) {
        if (src == "") {
            return null;
        }
        return src;
    }

    public static String Long2String(Long src) {
        String ret = null;
        if (src != null) {
            ret = Long.toString(src);
        }
        return ret;
    }

    public static Long string2Long(String src) {
        Long ret = null;
        if (src != null) {
            ret = Long.valueOf(src);
        }
        return ret;
    }

    public static Double string2Double(String src) {
        Double ret = null;
        if (src != null) {
            ret = Double.valueOf(src);
        }
        return ret;
    }

    public static String Integer2String(Integer src) {
        String ret = null;
        if (src != null) {
            ret = Integer.toString(src);
        }
        return ret;
    }

    public static String Integer2String(Integer src, String defaultValue) {
        String ret = defaultValue;
        if (src != null) {
            ret = Integer.toString(src);
        }
        return ret;
    }

    public static String double2String(Double src) {
        String ret = null;
        if (src != null) {
            ret = Double.toString(src);
        }
        return ret;
    }

    public static List<String> stringToList(String src, String sep) {
        List<String> ret = null;
        if (src != null && sep != null) {
            String[] tmp = src.split(sep);
            ret = Arrays.asList(tmp);
        }
        return ret;
    }

    public static <T> Map<String, T> stringToMap(String src, T cls) {
        if (src == null) {
            return null;
        }
        try {
            return (Map)JSON.parseObject((String)src, Map.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONObject stringToJson(String src) {
        if (src == null) {
            return null;
        }
        try {
            return JSONObject.parseObject((String)src);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return (Object[])array2.clone();
        }
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static double[] insertElement(double[] original, double element, int index) {
        int length = original.length;
        double[] destination = new double[length + 1];
        System.arraycopy(original, 0, destination, 0, index);
        destination[index] = element;
        System.arraycopy(original, index, destination, index + 1, length - index);
        return destination;
    }

    public static double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) {
            return 0.0;
        }
        if (baseCnt <= 0L) {
            return 0.0;
        }
        double ratio = (double)targetCnt.longValue() * 1.0 / (double)baseCnt.longValue();
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * baseCnt) - faithLevel * Math.sqrt((double)(4L * baseCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * baseCnt)) / (1.0 + faithSquare / (double)baseCnt.longValue());
    }

    public static String featureFormat(String realTime, String offline) {
        if (realTime == null) {
            return offline;
        }
        return realTime;
    }
}

