package cn.com.duiba.nezha.alg.common.model.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.junit.Test;

public class PidController {

    private double P;
    private double I;
    private double I2;
    private double D;
    private static double LEARNING_RATE = 0.3;


    public PidController() {
        P = 1.0;
        I = 0.2;
        I2 = 0.01;
        D = 0.;
    }

    public double runPid(double target, double actual, double actualSum) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum);
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }

    public double runPid2(double target, double actual, double actualSum, double costWeigh) {

        double error;
        double signal;
        error = P * (target - actual) + I * (target - actualSum) * costWeigh;
        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.01, 0.01);
        return signal;
    }

    public double runPid(double target, double actual, double actualSum, double factor) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum);
        signal = LEARNING_RATE * error;

        double range = getRange(factor);
        signal = MathUtil.stdwithBoundary(signal, -1 * range, range);
        return signal;
    }


    public double runPid(double target, double actual) {

        double error = 0;
        double signal = 0;

        error = P * (target - actual) / target;

        signal = LEARNING_RATE * error;
        signal = MathUtil.stdwithBoundary(signal, -0.2, 0.2);

        return signal;
    }




    private double getRange(double factor) {

        double ret = 0.05;

        if (factor > 1.2) {
            ret = 0.05 + (factor - 1) * 0.2;
        }

        if (factor < 1.2) {
            ret = 0.05 + Math.abs(1 - factor) * 0.05;
        }

        return ret;
    }

    public double runPid2(double target, double actual, double actualSum, double actualSum2, double costWeigh) {

        double error = 0;
        double signal = 0;
        error = P * (target - actual) + I * (target - actualSum) * costWeigh + I2 * (target - actualSum2) ;

        signal = DataUtil.division(LEARNING_RATE * error * 0.5, target, 3);

        signal = MathUtil.stdwithBoundary(signal, -0.05, 0.05);
        return signal;
    }


    public double update(double target, double actual, double learingRate, double lowLmit, double upLmit) {

        double error = 0;
        double signal = 0;

        error = P * (target - actual) / target;

        signal = learingRate * error;
        signal = MathUtil.stdwithBoundary(signal, lowLmit, upLmit);

        return signal;
    }

    public double update2(double target, double actualMin, double actualHour, double actualDay, double factor, double learnRatio) {

        //计算 偏差
        double singal = 0.001;

        //实时偏差
        double wMin = 0.0;
        double singalMin = wMin * (target - actualMin);

        //小时偏差
        double wHour = 0.5;
        double singalHour = wHour * (target - actualHour);

        //累计偏差
        double wHis = 1.0;
        double singalHistory = wHis * (target - actualDay);

        //融合
        singal = (singalMin + singalHour + singalHistory) / (wMin + wHour + wHis);


        //当 实时偏差和累计偏差 相反时，限定实时成本偏差范围
        if (singalMin * singalHistory < 0) {

            //约束 实时偏低 且 全天偏高 情况
            if (singalMin <= -0.2) {
                singal = (-0.2 - singalMin);
            }

            //约束 实时偏高 且 全天偏低 情况
            if (singalMin >= 0.3) {
                singal = (0.3 - singalMin);
            }
        }

        //学习率
        learnRatio = learnRatio * getAdaptLearnRatio(factor);

        singal = learnRatio * singal;

        //幅度约束
        singal = MathUtil.stdwithBoundary(singal, -0.02, 0.02);

        return singal;
    }


    /**
     * facotor=1,ratio=1
     *
     * @param factor
     * @return
     */
    public double getAdaptLearnRatio(double factor) {

        double ret = factor > 1.0 ? (factor) : (3 - 2 * factor);

        ret = MathUtil.stdwithBoundary(ret, 0.5, 1.5);

        return ret;

    }




}
