/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityselectconversionforms;

import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityChangeVal;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityData;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfo;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoAdWithType;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoModel;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityModel;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.AdvertWithType;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SameCostActivitiesInfo;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SelectActivityResult;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.Val;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.WilsonInterval;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.WilsonPair;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(HotActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisClick, double click) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (click < 0.0) {
            for (j = 1; j < 144 && !((click += hisClick / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    private static List<ActivityInfoModel> sortByIdAndSourceModel(List<ActivityInfoModel> acts) {
        List<ActivityInfoModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoModel>(){

            @Override
            public int compare(ActivityInfoModel act1, ActivityInfoModel act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts) {
        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>(){

            @Override
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoAdWithType> sortByIdAndSourceAd(List<ActivityInfoAdWithType> acts) {
        List<ActivityInfoAdWithType> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoAdWithType>(){

            @Override
            public int compare(ActivityInfoAdWithType act1, ActivityInfoAdWithType act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts) {
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>(){

            @Override
            public int compare(ActivityModel act1, ActivityModel act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts) {
        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>(){

            @Override
            public int compare(ActivityData act1, ActivityData act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    public static List<ActivityInfoModel> match(List<ActivityInfoModel> actModel, List<ActivityInfoData> actData, List<ActivityInfoAdWithType> actAd) {
        int topn = Constant.SEARANK_TOPN;
        ArrayList<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        ArrayList<ActivityInfoModel> actModelCopy = new ArrayList<ActivityInfoModel>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> hotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        List<ActivityInfoData> actDataCopy = HotActivitySelector.sortByIdAndSourceData(actData);
        HashMap<Long, ActivityInfoAdWithType> adHashMap = new HashMap<Long, ActivityInfoAdWithType>();
        for (int i = 0; i < actAd.size(); ++i) {
            adHashMap.put(actAd.get((int)i).activityId, actAd.get(i));
        }
        long size_act = actDataCopy.size();
        HashSet<Long> idset = new HashSet<Long>();
        int limit = topn;
        int i = 0;
        while ((long)i < size_act) {
            try {
                ActivityInfoModel actM = new ActivityInfoModel();
                actM.activityId = actDataCopy.get((int)i).activityId;
                actM.slotId = actDataCopy.get((int)i).slotId;
                actM.appId = actDataCopy.get((int)i).appId;
                actM.hisClick = new Val();
                actM.hisClick.globalVal = actDataCopy.get((int)i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get((int)i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get((int)i).click.slotVal;
                actM.hisCost = new Val();
                actM.hisCost.globalVal = actDataCopy.get((int)i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get((int)i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get((int)i).cost.slotVal;
                actM.hisRequest = new Val();
                actM.hisRequest.globalVal = actDataCopy.get((int)i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get((int)i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get((int)i).request.slotVal;
                actM.isHot = actDataCopy.get((int)i).isHot;
                actM.uploadTime = actDataCopy.get((int)i).uploadTime;
                actModelCopy.add(actM);
                if (actM.hisRequest.globalVal < 100.0) {
                    if (actM.isHot) {
                        result.add(actM);
                        --topn;
                        idset.add(actM.activityId);
                    }
                    if (System.currentTimeMillis() - actDataCopy.get((int)i).createTime < 259200000L) {
                        if (Math.random() < 1.0E-4) {
                            result.add(actM);
                            --topn;
                            idset.add(actM.activityId);
                        }
                    } else if (actDataCopy.size() > limit && Math.random() < 1.0E-5) {
                        result.add(actM);
                        --topn;
                        idset.add(actM.activityId);
                    }
                } else {
                    double slotScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.slotVal), (long)((long)actM.hisRequest.slotVal * 3L)).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.globalVal), (long)((long)actM.hisRequest.globalVal * 3L)).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.appVal), (long)((long)actM.hisRequest.appVal * 3L)).lowerBound;
                    double coef = 0.0;
                    double matchscore = 0.0;
                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100.0, 1.0);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100.0, 1.0);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000.0, 1.0);
                    matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    double changeScore = 0.0;
                    ActivityChangeVal activityChangeValNew = new ActivityChangeVal();
                    if (adHashMap.containsKey(actDataCopy.get((int)i).activityId)) {
                        activityChangeValNew = HotActivitySelector.calChangeScoreMergeAbsolute(((ActivityInfoAdWithType)adHashMap.get(actDataCopy.get((int)i).activityId)).getAdvertsWithType());
                        changeScore = activityChangeValNew.changeScoreMerge;
                    }
                    actM.changeScore = changeScore;
                    actM.activityChangeVal = activityChangeValNew;
                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;
                    candis.add(info);
                    if (actM.isHot) {
                        MatchInfo info1 = new MatchInfo();
                        info1.act = actM;
                        info1.score = matchscore;
                        hotCandis.add(info);
                    }
                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5.0) {
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        info2.score = actM.hisRequest.slotVal > 0.0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0.0;
                        slotCandis.add(info2);
                    }
                    if (aconfidence > 0.99 || actM.hisClick.appVal > 5.0) {
                        MatchInfo info3 = new MatchInfo();
                        info3.act = actM;
                        info3.score = actM.hisRequest.appVal > 0.0 ? actM.hisCost.appVal / actM.hisRequest.appVal : 0.0;
                        appCandis.add(info3);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        int hotSize = hotCandis.size();
        for (int i2 = 0; i2 < 10 && i2 < hotSize; ++i2) {
            ActivityInfoModel act = ((MatchInfo)hotCandis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            --topn;
        }
        int size1 = slotCandis.size();
        for (int i3 = 0; i3 < 10 && i3 < size1; ++i3) {
            ActivityInfoModel act = ((MatchInfo)slotCandis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            --topn;
        }
        int size = candis.size();
        int resultSize = result.size();
        for (int i4 = 0; resultSize < limit && i4 < size; ++i4) {
            ActivityInfoModel act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            resultSize = result.size();
            --topn;
        }
        if (result.size() < limit) {
            int count = topn;
            int i5 = 0;
            while ((long)i5 < size_act) {
                if (!idset.contains(actDataCopy.get((int)i5).activityId)) {
                    idset.add(actDataCopy.get((int)i5).activityId);
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisClick.globalVal = actDataCopy.get((int)i5).click.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisClick.appVal = actDataCopy.get((int)i5).click.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisClick.slotVal = actDataCopy.get((int)i5).click.slotVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisCost.globalVal = actDataCopy.get((int)i5).cost.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisCost.appVal = actDataCopy.get((int)i5).cost.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisCost.slotVal = actDataCopy.get((int)i5).cost.slotVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisRequest.globalVal = actDataCopy.get((int)i5).request.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisRequest.appVal = actDataCopy.get((int)i5).request.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i5)).hisRequest.slotVal = actDataCopy.get((int)i5).request.slotVal;
                    result.add((ActivityInfoModel)actModelCopy.get(i5));
                    if (++count >= topn) break;
                }
                ++i5;
            }
        }
        return result;
    }

    public static SelectActivityResult select(List<ActivityModel> actModelCopy, List<ActivityData> actDataCopy, double gama) {
        SelectActivityResult selectActivityResult = new SelectActivityResult();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<Boolean> hots = new ArrayList<Boolean>();
        ArrayList<ActivityModel> candiList = new ArrayList<ActivityModel>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD;
        double maxHchange = Constant.MIN_REWARD;
        double maxAchange = Constant.MIN_REWARD;
        ActivityModel result = null;
        try {
            int i;
            for (i = 0; i < actDataCopy.size(); ++i) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(actDataCopy.get((int)i).activityId) ? (RankInfo)mMap.get(actDataCopy.get((int)i).activityId) : new RankInfo();
                info.grpm = grpm = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisCost.globalVal / actDataCopy.get((int)i).hisRequest.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actDataCopy.get((int)i).hisCost.appVal / actDataCopy.get((int)i).hisRequest.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actDataCopy.get((int)i).hisCost.slotVal / actDataCopy.get((int)i).hisRequest.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                mMap.put(actDataCopy.get((int)i).activityId, info);
            }
            for (i = 0; i < actDataCopy.size(); ++i) {
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(actDataCopy.get((int)i).hisRequest.slotVal / 60.0, 1.0);
                double aconfidence = Math.min(actDataCopy.get((int)i).hisRequest.appVal / 60.0, 1.0);
                reward = sconfidence * HotActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * HotActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * HotActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).grpm * 0.5, maxG, 0.6);
                reward *= reward;
                reward = Math.max(reward, Constant.MIN_REWARD);
                actModelCopy.get((int)i).reward = actModelCopy.get((int)i).reward * decay + reward;
                actModelCopy.get((int)i).count = actModelCopy.get((int)i).count * decay + 1.0;
                actModelCopy.get((int)i).alpha = 1.5 + actModelCopy.get((int)i).reward;
                actModelCopy.get((int)i).beta = 2.0 + (actModelCopy.get((int)i).count - actModelCopy.get((int)i).reward);
                actModelCopy.get((int)i).isHot = actDataCopy.get((int)i).isHot;
                actModelCopy.get((int)i).changeScore = actDataCopy.get((int)i).changeScore;
                actModelCopy.get((int)i).uploadTime = actDataCopy.get((int)i).uploadTime;
                actModelCopy.get((int)i).slotId = actDataCopy.get((int)i).slotId;
                actModelCopy.get((int)i).appId = actDataCopy.get((int)i).appId;
                rewards.add(actModelCopy.get((int)i).reward);
                counts.add(actModelCopy.get((int)i).count);
                alphas.add(actModelCopy.get((int)i).alpha);
                betas.add(actModelCopy.get((int)i).beta);
                activityTypes.add(actModelCopy.get((int)i).activityType);
                activityIds.add(actModelCopy.get((int)i).activityId);
                changeScores.add(actModelCopy.get((int)i).changeScore);
                hots.add(actModelCopy.get((int)i).isHot);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            SelectInfoDetail selectInfoDetail = HotActivitySelector.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, hots, numMachines, gama);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityModel)candiList.get(selectedActivityIndex);
            ArrayList<SelectInfo> sameCostcondi = selectInfoDetail.condi;
            Double selectedActivityChangeScore = result.changeScore;
            int sameCostActivityCnt = sameCostcondi.size();
            ArrayList<SameCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SameCostActivitiesInfo>();
            for (SelectInfo selectInfo : sameCostcondi) {
                SameCostActivitiesInfo sameCostActivitiesInfo = new SameCostActivitiesInfo();
                Long activityId = selectInfo.activityId;
                Long activityType = selectInfo.activityType;
                int ifSelected = 0;
                if (selectInfo.index == selectedActivityIndex) {
                    ifSelected = 1;
                }
                int index = selectInfo.index;
                Double mabReward = selectInfo.reward;
                Double changeScore = selectInfo.changeScore;
                Double diffChangeScore = selectInfo.changeScore - selectedActivityChangeScore;
                sameCostActivitiesInfo.activityId = activityId;
                sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                sameCostActivitiesInfo.activityType = activityType;
                sameCostActivitiesInfo.ifSelected = ifSelected;
                sameCostActivitiesInfo.mabReward = mabReward;
                sameCostActivitiesInfo.changeScore = changeScore;
                sameCostActivitiesInfo.index = index;
                sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                sameCostActivitiesInfo.isHot = selectInfo.isHot;
                sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
            }
            selectActivityResult.activityModel = result;
            selectActivityResult.sameCostActivitiesInfoList = sameCostActivitiesInfoList;
            mMap.clear();
            return selectActivityResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString(result)});
            return null;
        }
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.request.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("click = " + act.click.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastClick = " + act.lastClick.slotVal + "\t" + act.lastClick.appVal + "\t" + act.lastClick.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
        System.out.println("hisClick = " + act.hisClick.slotVal + "\t" + act.hisClick.appVal + "\t" + act.hisClick.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static SelectActivityResult hotSelect(List<ActivityModel> actModel, List<ActivityData> actData, double gama) {
        SelectActivityResult selectActivityResult = new SelectActivityResult();
        HashMap<Long, ActivityData> mMap = new HashMap<Long, ActivityData>();
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            int actMn = 0;
            for (int i = 0; i < actModel.size(); ++i) {
                if (actModel.get((int)i).isHot) continue;
                actMn = Math.random() > 0.5 ? i : 0;
                break;
            }
            selectActivityResult.activityModel = actModel.get(actMn);
            selectActivityResult.sameCostActivitiesInfoList = null;
            return selectActivityResult;
        }
        List<ActivityModel> actModelCopy = HotActivitySelector.sortByIdAndSourceModelBack(actModel);
        List<ActivityData> actDataCopy = HotActivitySelector.sortByIdAndSourceDataBack(actData);
        ArrayList<ActivityModel> hotActivityModels = new ArrayList<ActivityModel>();
        ArrayList<ActivityData> hotActivityData = new ArrayList<ActivityData>();
        ArrayList<ActivityModel> activityModels = new ArrayList<ActivityModel>();
        ArrayList<ActivityData> activityData = new ArrayList<ActivityData>();
        for (int i = 0; i < actModelCopy.size(); ++i) {
            boolean isSameHotActivity;
            long activityIdMode = actModelCopy.get((int)i).activityId;
            long activityIdData = actDataCopy.get((int)i).activityId;
            boolean bl = isSameHotActivity = actModelCopy.get((int)i).isHot == actData.get((int)i).isHot;
            if (activityIdMode != activityIdData || !isSameHotActivity) {
                int actMn = 0;
                for (int j = 0; j < actModel.size(); ++j) {
                    if (actModel.get((int)i).isHot) continue;
                    actMn = Math.random() > 0.5 ? j : 0;
                    break;
                }
                selectActivityResult.activityModel = actModel.get(actMn);
                selectActivityResult.sameCostActivitiesInfoList = null;
                return selectActivityResult;
            }
            ActivityModel ham = actModelCopy.get(i);
            ActivityData had = actDataCopy.get(i);
            if (ham.isHot) {
                hotActivityModels.add(ham);
                hotActivityData.add(had);
                mMap.put(had.activityId, had);
                continue;
            }
            activityModels.add(ham);
            activityData.add(had);
        }
        SelectActivityResult shar = new SelectActivityResult();
        SelectActivityResult sar = new SelectActivityResult();
        if (hotActivityData.size() > 0) {
            shar = HotActivitySelector.select(hotActivityModels, hotActivityData, gama);
        }
        if (activityData.size() > 0) {
            sar = HotActivitySelector.select(activityModels, activityData, gama);
        }
        if (shar.getActivityModel() == null) {
            if (sar.getActivityModel() != null) {
                return sar;
            }
        } else if (sar.getActivityModel() == null) {
            return shar;
        }
        long diffTime = System.currentTimeMillis() - ((ActivityData)mMap.get((Object)Long.valueOf((long)shar.activityModel.getActivityId()))).uploadTime;
        if (((ActivityData)mMap.get((Object)Long.valueOf((long)shar.activityModel.activityId))).hisRequest.slotVal < 200.0) {
            if (Math.random() < 0.5) {
                return shar;
            }
        } else {
            int currentHour = DateUtil.getHour(new Date());
            double hourCvrWeight = 1.0;
            double hourRewardWeight = 1.0;
            switch (currentHour) {
                case 0: {
                    hourCvrWeight = 1.2;
                    hourRewardWeight = 0.93;
                    break;
                }
                case 1: {
                    hourCvrWeight = 1.24;
                    hourRewardWeight = 0.95;
                    break;
                }
                case 2: {
                    hourCvrWeight = 1.22;
                    hourRewardWeight = 0.84;
                    break;
                }
                case 3: {
                    hourCvrWeight = 1.48;
                    hourRewardWeight = 0.65;
                    break;
                }
                case 4: {
                    hourCvrWeight = 1.68;
                    hourRewardWeight = 0.46;
                    break;
                }
                case 5: {
                    hourCvrWeight = 1.67;
                    hourRewardWeight = 0.47;
                    break;
                }
                case 6: {
                    hourCvrWeight = 1.34;
                    hourRewardWeight = 0.74;
                    break;
                }
                case 7: {
                    hourCvrWeight = 1.23;
                    hourRewardWeight = 0.82;
                    break;
                }
                case 8: {
                    hourCvrWeight = 0.98;
                    hourRewardWeight = 1.06;
                    break;
                }
                case 9: {
                    hourCvrWeight = 0.92;
                    hourRewardWeight = 1.24;
                    break;
                }
                case 10: {
                    hourCvrWeight = 0.91;
                    hourRewardWeight = 1.22;
                    break;
                }
                case 11: {
                    hourCvrWeight = 0.78;
                    hourRewardWeight = 1.21;
                    break;
                }
                case 12: {
                    hourCvrWeight = 0.78;
                    hourRewardWeight = 1.14;
                    break;
                }
                case 13: {
                    hourCvrWeight = 0.88;
                    hourRewardWeight = 1.25;
                    break;
                }
                case 14: {
                    hourCvrWeight = 0.87;
                    hourRewardWeight = 1.26;
                    break;
                }
                case 15: {
                    hourCvrWeight = 0.87;
                    hourRewardWeight = 1.25;
                    break;
                }
                case 16: {
                    hourCvrWeight = 0.82;
                    hourRewardWeight = 1.18;
                    break;
                }
                case 17: {
                    hourCvrWeight = 0.96;
                    hourRewardWeight = 1.03;
                    break;
                }
                case 18: {
                    hourCvrWeight = 1.01;
                    hourRewardWeight = 0.91;
                    break;
                }
                case 19: {
                    hourCvrWeight = 0.96;
                    hourRewardWeight = 0.95;
                    break;
                }
                case 20: {
                    hourCvrWeight = 0.92;
                    hourRewardWeight = 0.96;
                    break;
                }
                case 21: {
                    hourCvrWeight = 0.88;
                    hourRewardWeight = 0.88;
                    break;
                }
                case 22: {
                    hourCvrWeight = 0.91;
                    hourRewardWeight = 0.81;
                    break;
                }
                case 23: {
                    hourCvrWeight = 1.02;
                    hourRewardWeight = 0.68;
                    break;
                }
                default: {
                    hourCvrWeight = 1.0;
                    hourRewardWeight = 1.0;
                }
            }
            hourCvrWeight = Math.max(hourCvrWeight, 1.0);
            hourRewardWeight = Math.max(hourRewardWeight, 1.0);
            if (shar.activityModel.reward >= sar.activityModel.reward * hourRewardWeight * 0.95 && shar.activityModel.changeScore >= sar.activityModel.changeScore * hourCvrWeight * 0.95) {
                return shar;
            }
            if (shar.activityModel.reward >= sar.activityModel.reward * hourRewardWeight * 0.92 && shar.activityModel.changeScore >= sar.activityModel.changeScore * hourCvrWeight * 0.92 && ((ActivityData)mMap.get((Object)Long.valueOf((long)shar.activityModel.getActivityId()))).hisRequest.slotVal <= 500.0) {
                System.out.println("diffTIme:" + diffTime);
                if (diffTime >= 0L && diffTime < 86400000L ? Math.random() < 0.05 : diffTime >= 86400000L && diffTime < 172800000L && Math.random() < 0.01) {
                    return shar;
                }
            }
        }
        return sar;
    }

    public static double calChangeScoreMerge(List<AdvertWithType> ads) {
        double changeScoreMerge = 0.0;
        double changeScoreForms = 0.0;
        double changeScoreNotForms = 0.0;
        double sumClick = 0.0;
        double sumEffectPV = 0.0;
        double sumClickForms = 0.0;
        double sumEffectPVForms = 0.0;
        double sumClickNotForms = 0.0;
        double sumEffectPVNotForms = 0.0;
        for (AdvertWithType ad : ads) {
            if (ad.ifForms == 1) {
                sumClickForms += (double)ad.getClick();
                sumEffectPVForms += (double)ad.getEffectPV();
            } else {
                sumClickNotForms += (double)ad.getClick();
                sumEffectPVNotForms += (double)ad.getEffectPV();
            }
            sumClick += (double)ad.click;
            sumEffectPV += (double)ad.effectPV;
        }
        for (AdvertWithType ad : ads) {
            double ratio;
            double globalCvr;
            if (ad.ifForms == 1) {
                double changeMoreForms = ad.getClick() > 0L ? (double)ad.getEffectPV() / (double)ad.getClick() : 0.0;
                globalCvr = ad.getGlobalClick() > 0L ? (double)(ad.getGlobalEffectPV() / ad.getGlobalClick()) : 0.0;
                changeMoreForms = globalCvr > 0.0 ? changeMoreForms / globalCvr : 0.0;
                ratio = sumClickForms > 0.0 ? (double)ad.getClick() / sumClickForms : 0.0;
                changeScoreForms += ratio * (changeMoreForms -= 1.0);
                continue;
            }
            double changeMoreNotForms = ad.getClick() > 0L ? (double)ad.getEffectPV() / (double)ad.getClick() : 0.0;
            globalCvr = ad.getGlobalClick() > 0L ? (double)(ad.getGlobalEffectPV() / ad.getGlobalClick()) : 0.0;
            changeMoreNotForms = globalCvr > 0.0 ? changeMoreNotForms / globalCvr : 0.0;
            ratio = sumClickNotForms > 0.0 ? (double)ad.getClick() / sumClickNotForms : 0.0;
            changeScoreNotForms += ratio * (changeMoreNotForms -= 1.0);
        }
        changeScoreMerge = sumEffectPVForms >= 1.0 ? changeScoreForms * 0.999 + changeScoreNotForms * 0.001 : -99.0;
        return changeScoreMerge;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    public static ActivityChangeVal calChangeScoreMergeAbsolute(List<AdvertWithType> ads) {
        double changeScoreMerge = 0.0;
        double changeScoreForms = 0.0;
        double changeScoreNotForms = 0.0;
        double changeScoreFormsGlobal = 0.0;
        double changeScoreNotFormsGlobal = 0.0;
        double sumClick = 0.0;
        double sumEffectPV = 0.0;
        double sumClickGlobal = 0.0;
        double sumEffectPVGlobal = 0.0;
        double sumClickForms = 0.0;
        double sumEffectPVForms = 0.0;
        double sumClickNotForms = 0.0;
        double sumEffectPVNotForms = 0.0;
        double sumGlobalClickForms = 0.0;
        double sumGlobalEffectPVForms = 0.0;
        double sumGlobalClickNotForms = 0.0;
        double sumGlobalEffectPVNotForms = 0.0;
        Long formsAdvertCnt = 0L;
        Long notFormsAdvertCnt = 0L;
        for (AdvertWithType ad : ads) {
            if (ad.ifForms == 1) {
                sumClickForms += (double)ad.getClick();
                sumEffectPVForms += (double)ad.getEffectPV();
                sumGlobalClickForms += (double)ad.getGlobalClick().longValue();
                sumGlobalEffectPVForms += (double)ad.getGlobalEffectPV().longValue();
                formsAdvertCnt = formsAdvertCnt + 1L;
            } else {
                sumClickNotForms += (double)ad.getClick();
                sumEffectPVNotForms += (double)ad.getEffectPV();
                sumGlobalClickNotForms += (double)ad.getGlobalClick().longValue();
                sumGlobalEffectPVNotForms += (double)ad.getGlobalEffectPV().longValue();
                notFormsAdvertCnt = notFormsAdvertCnt + 1L;
            }
            sumClick += (double)ad.getClick();
            sumEffectPV += (double)ad.getEffectPV();
            sumClickGlobal += (double)ad.getGlobalClick().longValue();
            sumEffectPVGlobal += (double)ad.getGlobalEffectPV().longValue();
        }
        changeScoreForms = sumClickForms > 0.0 ? sumEffectPVForms / sumClickForms : 0.0;
        changeScoreNotForms = sumClickNotForms > 0.0 ? sumEffectPVNotForms / sumClickNotForms : 0.0;
        changeScoreFormsGlobal = sumGlobalClickForms > 0.0 ? sumGlobalEffectPVForms / sumGlobalClickForms : 0.0;
        changeScoreNotFormsGlobal = sumGlobalClickNotForms > 0.0 ? sumGlobalEffectPVNotForms / sumGlobalClickNotForms : 0.0;
        double effctFormsWeight = Math.min(sumEffectPVForms / 3.0, 1.0);
        double globalEffectFormsWeight = Math.min(sumGlobalEffectPVForms / 100.0, 1.0);
        double effctNotFormsWeight = Math.min(sumEffectPVNotForms / 30.0, 1.0);
        double globalEffectNotFormsWeight = Math.min(sumGlobalEffectPVNotForms / 100.0, 1.0);
        double rand = Math.random();
        if (sumEffectPVForms >= 1.0) {
            changeScoreMerge = changeScoreForms;
        } else if (0.0 <= sumClickForms && sumClickForms < 100.0 && changeScoreFormsGlobal > 0.0) {
            int w1 = (int)(sumClickForms / 100.0 / 0.2);
            int w2 = 5 - w1;
            changeScoreMerge = 0.01 * (double)w2 * changeScoreFormsGlobal;
        } else if (sumClickForms >= 100.0 && changeScoreFormsGlobal > 0.0) {
            changeScoreMerge = changeScoreFormsGlobal * 1.0 / sumClickForms;
        } else if (changeScoreNotForms > 0.0) {
            changeScoreMerge = changeScoreNotForms * 1.0 / 10000.0;
        } else if (rand <= 0.001) {
            changeScoreMerge = Math.random();
        }
        ActivityChangeVal activityChangeVal = new ActivityChangeVal();
        activityChangeVal.sumClickForms = sumClickForms;
        activityChangeVal.sumEffectPVForms = sumEffectPVForms;
        activityChangeVal.sumClickNotForms = sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms = sumEffectPVNotForms;
        activityChangeVal.sumGlobalClickForms = sumGlobalClickForms;
        activityChangeVal.sumGlobalEffectPVForms = sumGlobalEffectPVForms;
        activityChangeVal.sumGlobalClickNotForms = sumGlobalClickNotForms;
        activityChangeVal.sumGlobalEffectPVNotForms = sumGlobalEffectPVNotForms;
        activityChangeVal.changeScoreForms = changeScoreForms;
        activityChangeVal.changeScoreNotForms = changeScoreNotForms;
        activityChangeVal.changeScoreFormsGlobal = changeScoreFormsGlobal;
        activityChangeVal.changeScoreNotFormsGlobal = changeScoreNotFormsGlobal;
        activityChangeVal.formsAdvertCnt = formsAdvertCnt;
        activityChangeVal.notFormsAdvertCnt = notFormsAdvertCnt;
        activityChangeVal.changeScoreMerge = changeScoreMerge;
        return activityChangeVal;
    }

    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, List<Boolean> hots, int numMachines, double gama) {
        int i;
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new ArrayList<SelectInfo>();
        for (int i2 = 0; i2 < numMachines; ++i2) {
            double theta = BetaDistribution.BetaDist(alphas.get(i2), betas.get(i2));
            SelectInfo sinfo = new SelectInfo();
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i2);
            sinfo.index = i2;
            sinfo.activityId = activityIds.get(i2);
            sinfo.changeScore = changeScores.get(i2);
            sinfo.isHot = hots.get(i2);
            sinfos.add(sinfo);
        }
        Collections.sort(sinfos, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList condi = new ArrayList();
        for (i = 0; i < sinfos.size(); ++i) {
            if (!(((SelectInfo)sinfos.get((int)0)).reward - ((SelectInfo)sinfos.get((int)i)).reward <= gama)) continue;
            condi.add(sinfos.get(i));
        }
        Collections.sort(condi, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                return 1;
            }
        });
        selectMachine = ((SelectInfo)condi.get((int)0)).index;
        for (i = 0; i < condi.size(); ++i) {
            if (((SelectInfo)condi.get((int)i)).activityType == 21L) continue;
            selectMachine = ((SelectInfo)condi.get((int)i)).index;
            break;
        }
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        selectInfoDetail.condi = condi;
        selectInfoDetail.index = selectMachine;
        return selectInfoDetail;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static HotActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final HotActivitySelector instance = new HotActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfoModel act;

        MatchInfo() {
        }
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectInfo> condi;

        SelectInfoDetail() {
        }
    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;
        boolean isHot;

        SelectInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;
        double changeScore;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

