/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class CvrPidController {
    public static WeightInfo calcControlFactor(ExpHourData expHourData, Integer convertSubType, Double upperBound, Double lowerBound, Double kp, Double ki, Long controlClickCntThreshold, WeightDimEnum dim) {
        HourDto lastHourDto = expHourData.getHourDtoMap().getOrDefault(expHourData.getLastHour(), new HourDto());
        long clickCountLastHour = lastHourDto.getClickCnt();
        double mergeCvrLastHour = expHourData.getMergeCvrLastHour();
        double cvrLastHour = expHourData.getCvrLastHour(convertSubType);
        double errorCurrent = CvrPidController.errorDiff(mergeCvrLastHour, cvrLastHour, clickCountLastHour, controlClickCntThreshold);
        double errorIntegral = CvrPidController.errorIntegral(expHourData, convertSubType, controlClickCntThreshold);
        double kt = kp * errorCurrent + ki * errorIntegral;
        double unboundK = CvrPidController.responseFunc(kt);
        double k = Double.isInfinite(unboundK) || Double.isNaN(unboundK) ? 1.0 : CvrPidController.bound(unboundK, upperBound, lowerBound);
        return new WeightInfo(dim.getId(), 0L, DataUtil.formatDouble(errorCurrent, 5), DataUtil.formatDouble(k, 5));
    }

    private static double errorDiff(Double mergeCvrLastHour, Double cvrLastHour, Long clickCountLastHour, Long controlClickCntThreshold) {
        if (clickCountLastHour <= controlClickCntThreshold || mergeCvrLastHour == 0.0) {
            return 0.0;
        }
        double result = cvrLastHour / mergeCvrLastHour - 1.0;
        return result;
    }

    private static double errorIntegral(ExpHourData expHourData, Integer convertSubType, Long controlClickCntThreshold) {
        long clickCount24Hour = 0L;
        for (HourDto hourDto : expHourData.getHourDtoMap().values()) {
            clickCount24Hour += hourDto.getClickCnt().longValue();
        }
        double mergeCvr24Hour = expHourData.getMergeCvr24Hour();
        if (clickCount24Hour <= controlClickCntThreshold || mergeCvr24Hour == 0.0) {
            return 0.0;
        }
        double cvr24Hour = expHourData.getCvr24Hour(convertSubType);
        double result = cvr24Hour / mergeCvr24Hour - 1.0;
        return result;
    }

    private static double responseFunc(double kt) {
        return kt + 1.0;
    }

    private static double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        }
        if (value < lowerBound) {
            return lowerBound;
        }
        return value;
    }
}

