/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialRec20;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialVal;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.WilsonInterval;
import java.util.Comparator;

public class AlgUtils {
    public static Comparator<? super MaterialRec20.MatchInfo> iComparator = new Comparator<MaterialRec20.MatchInfo>(){

        @Override
        public int compare(MaterialRec20.MatchInfo o1, MaterialRec20.MatchInfo o2) {
            return o2.score >= o1.score ? 1 : -1;
        }
    };
    public static Comparator<? super MaterialRec20.MatchInfo> normComparator = new Comparator<MaterialRec20.MatchInfo>(){

        @Override
        public int compare(MaterialRec20.MatchInfo o1, MaterialRec20.MatchInfo o2) {
            return o2.mat.score >= o1.score ? 1 : -1;
        }
    };

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static double getMatchScore(MaterialVal num, MaterialVal den, Double thr1, Double thr2, Boolean isUC) {
        double slotScore = WilsonInterval.wilsonCalc((double)num.getSlotVal(), (double)den.getSlotVal()).lowerBound;
        double globalScore = WilsonInterval.wilsonCalc((double)num.getGlobalVal(), (double)den.getGlobalVal()).lowerBound;
        double appScore = WilsonInterval.wilsonCalc((double)num.getAppVal(), (double)den.getAppVal()).lowerBound;
        if (isUC.booleanValue()) {
            slotScore = WilsonInterval.wilsonCalc((double)num.getSlotVal(), (double)(den.getSlotVal() / 100.0)).lowerBound;
            globalScore = WilsonInterval.wilsonCalc((double)num.getGlobalVal(), (double)(den.getGlobalVal() / 100.0)).lowerBound;
            appScore = WilsonInterval.wilsonCalc((double)num.getAppVal(), (double)(den.getAppVal() / 100.0)).lowerBound;
        }
        double sconfidence = Math.min(den.getSlotVal() / thr1, 1.0);
        double aconfidence = Math.min(den.getAppVal() / thr1, 1.0);
        double gconfidence = Math.min(den.getGlobalVal() / thr2, 1.0);
        double matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
        return matchscore;
    }

    public static double BetaDist(double alpha, double beta) {
        double a = alpha + beta;
        double b = Math.sqrt((a - 2.0) / (2.0 * alpha * beta - a));
        if (Math.min(alpha, beta) <= 1.0) {
            b = Math.max(1.0 / alpha, 1.0 / beta);
        }
        double c = alpha + 1.0 / b;
        double W = 0.0;
        boolean reject = true;
        while (reject) {
            double U1 = Math.random();
            double U2 = Math.random();
            double V = b * Math.log(U1 / (1.0 - U1));
            W = alpha * Math.exp(V);
            reject = a * Math.log(a / (beta + W)) + c * V - Math.log(4.0) < Math.log(U1 * U1 * U2);
        }
        return W / (beta + W);
    }
}

