/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import cn.com.duiba.nezha.alg.common.model.materialrecommend.AlgUtils;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.Constant;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialDataInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialMatchInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialNormInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialRankInfo;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.MaterialVal;
import cn.com.duiba.nezha.alg.common.model.materialrecommend.RankInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRec20 {
    private static final Logger logger = LoggerFactory.getLogger(MaterialRec20.class);

    public static List<MaterialMatchInfo> match(List<MaterialDataInfo> materialList, List<MaterialNormInfo> exScks) {
        int i;
        double prob = Constant.PROB;
        double exposureThreshold = Constant.EXPOSURE_THRESHOLD;
        int topn = Constant.RECALL_TOPN;
        int exTopN = Constant.EXCELLENT_TOPN;
        if (materialList.size() == 0) {
            return null;
        }
        PriorityQueue<? super MatchInfo> gCandisCTR = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> sCandisCTR = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> gCandisUC = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> sCandisUC = new PriorityQueue<MatchInfo>(materialList.size(), AlgUtils.iComparator);
        PriorityQueue<? super MatchInfo> normCandis = new PriorityQueue<MatchInfo>(exTopN, AlgUtils.normComparator);
        ArrayList<MaterialMatchInfo> result = new ArrayList<MaterialMatchInfo>();
        ArrayList<MaterialMatchInfo> sckModel = new ArrayList<MaterialMatchInfo>();
        double exposures = 0.0;
        double clicks = 0.0;
        double costs = 0.0;
        for (MaterialDataInfo mat2 : materialList) {
            exposures += mat2.getExposureCnt().getSlotVal();
            clicks += mat2.getClickCnt().getSlotVal();
            costs += mat2.getCost().getSlotVal();
        }
        double ctr = clicks / exposures;
        double uc = costs / exposures;
        HashMap<Long, MaterialNormInfo> exHashMap = new HashMap<Long, MaterialNormInfo>();
        if (exScks != null) {
            for (MaterialNormInfo exSck : exScks) {
                exHashMap.put(exSck.getMaterialId(), exSck);
            }
        }
        HashSet<Long> sckIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisSckIds = new HashSet(materialList.stream().map(MaterialDataInfo::getMaterialId).collect(Collectors.toSet()));
        HashSet<Long> idset = new HashSet<Long>();
        for (MaterialDataInfo materialDataInfo : materialList) {
            try {
                MaterialMatchInfo sckM = MaterialRec20.fillData(materialDataInfo, sckIds, exHashMap);
                sckM.setCtr(ctr);
                sckM.setUc(uc);
                sckModel.add(sckM);
                if (sckM.exposureCnt.getGlobalVal() < exposureThreshold) {
                    if (System.currentTimeMillis() - materialDataInfo.createTime < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(sckM);
                            --topn;
                            idset.add(sckM.materialId);
                        }
                    } else if (materialList.size() > topn && Math.random() < 0.1 * prob) {
                        result.add(sckM);
                        --topn;
                        idset.add(sckM.materialId);
                    }
                }
                double wctr = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100.0, 1000.0, false);
                double wuc = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100.0, 1000.0, true);
                if (sckM.isExcellent) {
                    MatchInfo emi = new MatchInfo();
                    emi.mat = sckM;
                    emi.score = sckM.score;
                    normCandis.add(emi);
                    continue;
                }
                MatchInfo wctrm = new MatchInfo();
                wctrm.mat = sckM;
                wctrm.score = wctr;
                gCandisCTR.add(wctrm);
                MatchInfo wucm = new MatchInfo();
                wucm.mat = sckM;
                wucm.score = wuc;
                gCandisUC.add(wucm);
                if (!(sckM.exposureCnt.getSlotVal() > 99.0) && !(sckM.clickCnt.getSlotVal() > 5.0)) continue;
                MatchInfo uctrm = new MatchInfo();
                uctrm.mat = sckM;
                uctrm.score = sckM.clickCnt.getSlotVal() / (100.0 * sckM.exposureCnt.getSlotVal());
                sCandisCTR.add(uctrm);
                MatchInfo uckmi = new MatchInfo();
                uckmi.mat = sckM;
                uckmi.score = sckM.cost.getSlotVal() / sckM.exposureCnt.getSlotVal();
                sCandisUC.add(uckmi);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < Constant.RECALL_SCTR_TOPN && i < sCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)sCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GCTR_TOPN && i < gCandisCTR.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)gCandisCTR.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_GUC_TOPN && i < gCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)gCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        for (i = 0; i < Constant.RECALL_SUC_TOPN && i < sCandisUC.size(); ++i) {
            MaterialMatchInfo materialMatchInfo = ((MatchInfo)sCandisUC.poll()).mat;
            if (idset.contains(materialMatchInfo.materialId)) continue;
            result.add(materialMatchInfo);
            idset.add(materialMatchInfo.materialId);
            --topn;
        }
        if (exScks != null) {
            for (MaterialNormInfo materialNormInfo : exScks) {
                if (hisSckIds.contains(materialNormInfo.getMaterialId())) continue;
                MatchInfo mci = new MatchInfo();
                MaterialMatchInfo aim = new MaterialMatchInfo();
                aim.setAppId(materialList.get(0).getAppId());
                aim.setSlotId(materialList.get(0).getSlotId());
                aim.setMaterialId(materialNormInfo.getMaterialId());
                aim.setnCtr(materialNormInfo.getnCtr());
                aim.setnPvCost(materialNormInfo.getnPvCost());
                aim.setScore(materialNormInfo.getScore());
                aim.setExcellent(true);
                mci.score = materialNormInfo.getScore();
                mci.mat = aim;
                normCandis.add(mci);
            }
            for (int i2 = 0; i2 < exTopN && i2 < normCandis.size(); ++i2) {
                MatchInfo matchInfo = (MatchInfo)normCandis.poll();
                if (idset.contains(matchInfo.mat.getMaterialId())) continue;
                result.add(matchInfo.mat);
                idset.add(matchInfo.mat.getMaterialId());
                --topn;
            }
        }
        return result;
    }

    public static MaterialRankInfo select(List<MaterialMatchInfo> matchInfos, List<MaterialRankInfo> materialModels) {
        HashMap map = new HashMap();
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }
        if (matchInfos.size() != materialModels.size()) {
            return null;
        }
        List<MaterialMatchInfo> matchInfoList = matchInfos.stream().sorted(Comparator.comparing(MaterialMatchInfo::getMaterialId).reversed()).collect(Collectors.toList());
        List<MaterialRankInfo> materialModelList = materialModels.stream().sorted(Comparator.comparing(MaterialRankInfo::getMaterialId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long modelMaterailId;
            long intoMaterialId = ((MaterialMatchInfo)matchInfoList.get(i)).getMaterialId();
            if (intoMaterialId != (modelMaterailId = ((MaterialRankInfo)materialModelList.get(i)).getMaterialId())) {
                return null;
            }
            materialModelList.get(i).setMatchScore(matchInfoList.get(i).getMatchScore());
            materialModelList.get(i).setExcellent(matchInfoList.get((int)i).isExcellent);
            materialModelList.get(i).setCtr(matchInfoList.get(i).getCtr());
            materialModelList.get(i).setUc(matchInfoList.get(i).getUc());
            materialModelList.get(i).setScore(matchInfoList.get(i).getScore());
        }
        ArrayList<RankInfo> ris = new ArrayList<RankInfo>();
        List<Object> mris = new ArrayList();
        mris = MaterialRec20.getSingleOptCandis(ris, matchInfoList, materialModelList, Constant.ALG_CTR, 100, 100);
        MaterialDetail md = MaterialRec20.selectMultiOptInfo(ris, matchInfoList, materialModelList);
        return materialModelList.get(md.index);
    }

    private static MaterialDetail selectMultiOptInfo(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList) {
        MaterialDetail md = new MaterialDetail();
        if (ris.size() > 0) {
            long excellentCnt = ris.stream().filter(e -> e.isExcellent()).count();
            double avgFcProb = Constant.EXCELLENT_FC_PROB / (double)excellentCnt;
            List ranks = ris.stream().sorted(Comparator.comparing(RankInfo::getReward).reversed()).collect(Collectors.toList());
            for (int i = 0; i < ranks.size(); ++i) {
                if (((RankInfo)ranks.get(i)).getExposure() < (double)Constant.EXPOSURE_THRESHOLD) {
                    if (((RankInfo)ranks.get(i)).isExcellent()) {
                        if (Math.random() < avgFcProb) {
                            md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                            md.index = ((RankInfo)ranks.get(i)).getIndex();
                            md.strategyType = 1;
                            break;
                        }
                    } else if (i > 1 && i < 5 && Math.random() < Constant.CTR_FC_PROB / 4.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 1;
                        break;
                    }
                } else if (((RankInfo)ranks.get(i)).getExposure() <= (double)Constant.DD_THRESHOLD) {
                    if (((RankInfo)ranks.get(i)).isExcellent() && i > 1 && i < 5 && Math.random() < Constant.DD_PROB_HIGH / 4.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 2;
                        break;
                    }
                    if (((RankInfo)ranks.get(i)).isExcellent() && i < 20 && Math.random() < Constant.DD_PROB_MID / 10.0) {
                        md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        md.index = ((RankInfo)ranks.get(i)).getIndex();
                        md.strategyType = 3;
                        break;
                    }
                }
                if (!(((RankInfo)ranks.get(i)).getCtr() >= 0.95 * ((RankInfo)ranks.get(i)).getsCtr())) continue;
                if (((RankInfo)ranks.get(i)).getHrpm() >= 0.95 * ((RankInfo)ranks.get(i)).getPvCost()) {
                    md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    md.index = ((RankInfo)ranks.get(i)).getIndex();
                    md.strategyType = 4;
                    break;
                }
                if (!(((RankInfo)ranks.get(i)).getCtr() > 1.2 * ((RankInfo)ranks.get(i)).getsCtr()) || !(((RankInfo)ranks.get(i)).getHrpm() < 0.6 * ((RankInfo)ranks.get(i)).getPvCost())) continue;
                md = MaterialRec20.getPairWise(matchInfoList, materialModelList);
                break;
            }
            if (md == null || md.strategyType == 0) {
                List rkf = ranks.stream().filter(e -> e.getHrpm() >= 0.8 * e.getPvCost()).collect(Collectors.toList());
                md.index = ((RankInfo)ranks.get(0)).getIndex();
                md.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                md.strategyType = 6;
            }
        } else {
            md.index = 0;
            md.condi = new ArrayList();
            md.strategyType = 0;
        }
        return md;
    }

    private static MaterialDetail getPairWise(List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList) {
        MaterialDetail md = new MaterialDetail();
        String oppAlg = Constant.ALG_UC;
        ArrayList<RankInfo> ris = new ArrayList<RankInfo>();
        List<MaterialRankInfo> mris = MaterialRec20.getSingleOptCandis(ris, matchInfoList, materialModelList, Constant.ALG_UC, 100, 100);
        if (mris.size() > 0) {
            List uc_ranks = ris.stream().sorted(Comparator.comparing(RankInfo::getReward).reversed()).collect(Collectors.toList());
            md.condi = new ArrayList(uc_ranks.subList(0, Math.min(uc_ranks.size(), 5)));
            md.index = ((RankInfo)uc_ranks.get(0)).getIndex();
            md.strategyType = 5;
        }
        return md;
    }

    private static List<MaterialRankInfo> getSingleOptCandis(List<RankInfo> ris, List<MaterialMatchInfo> matchInfoList, List<MaterialRankInfo> materialModelList, String oppAlg, int hthr, int athr) {
        ArrayList<Double> exposures = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Double> ctrs = new ArrayList<Double>();
        ArrayList<Double> pvCosts = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<MaterialRankInfo> candis = new ArrayList<MaterialRankInfo>();
        HashMap<Long, Material> mMap = new HashMap<Long, Material>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        double oppH = 0.0;
        double oppA = 0.0;
        double oppG = 0.0;
        for (int i = 0; i < matchInfoList.size(); ++i) {
            Material ml = mMap.getOrDefault(matchInfoList.get(i).getMaterialId(), new Material());
            if (oppAlg.equals(Constant.ALG_CTR)) {
                ml.grpm = oppG = matchInfoList.get((int)i).exposureCnt.getGlobalVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getGlobalVal() / matchInfoList.get((int)i).exposureCnt.getGlobalVal() : 0.0;
                ml.gexp = matchInfoList.get((int)i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);
                ml.arpm = oppA = matchInfoList.get((int)i).exposureCnt.getAppVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getAppVal() / matchInfoList.get((int)i).exposureCnt.getAppVal() : 0.0;
                ml.aexp = matchInfoList.get((int)i).exposureCnt.getAppVal();
                if (ml.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                ml.hrpm = oppH = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getSlotVal() / matchInfoList.get((int)i).exposureCnt.getSlotVal() : 0.0;
                ml.hexp = matchInfoList.get((int)i).exposureCnt.getSlotVal();
                if (ml.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            } else if (oppAlg.equals(Constant.ALG_UC)) {
                ml.grpm = oppG = matchInfoList.get((int)i).exposureCnt.getGlobalVal() > 0.0 ? matchInfoList.get((int)i).cost.getGlobalVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getGlobalVal()) : 0.0;
                ml.gexp = matchInfoList.get((int)i).exposureCnt.getGlobalVal();
                maxG = Math.max(oppG, maxG);
                ml.arpm = oppA = matchInfoList.get((int)i).exposureCnt.getAppVal() > 0.0 ? matchInfoList.get((int)i).cost.getAppVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getAppVal()) : 0.0;
                ml.aexp = matchInfoList.get((int)i).exposureCnt.getAppVal();
                if (ml.aexp > (double)athr) {
                    maxA = Math.max(oppA, maxA);
                }
                minA = Math.min(oppA, minA);
                ml.hrpm = oppH = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).cost.getSlotVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getSlotVal()) : 0.0;
                ml.hexp = matchInfoList.get((int)i).exposureCnt.getSlotVal();
                if (ml.hexp > (double)hthr) {
                    maxH = Math.max(oppH, maxH);
                }
                minH = Math.min(oppH, minH);
            }
            mMap.put(matchInfoList.get(i).getMaterialId(), ml);
        }
        double ctr = matchInfoList.get((int)0).ctr;
        double uc = matchInfoList.get((int)0).uc;
        for (int i = 0; i < matchInfoList.size(); ++i) {
            double sCtr = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).clickCnt.getSlotVal() / matchInfoList.get((int)i).exposureCnt.getSlotVal() : 0.0;
            double sUc = matchInfoList.get((int)i).exposureCnt.getSlotVal() > 0.0 ? matchInfoList.get((int)i).cost.getSlotVal() / (100.0 * matchInfoList.get((int)i).exposureCnt.getSlotVal()) : 0.0;
            ctrs.add(sCtr);
            pvCosts.add(sUc);
            exposures.add(matchInfoList.get((int)i).exposureCnt.getSlotVal());
            double hrpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).hrpm;
            double arpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).arpm;
            double grpm = ((Material)mMap.get((Object)Long.valueOf((long)matchInfoList.get((int)i).getMaterialId()))).grpm;
            hrpms.add(hrpm);
            arpms.add(arpm);
            grpms.add(grpm);
            excellents.add(matchInfoList.get((int)i).isExcellent);
            scores.add(matchInfoList.get((int)i).score);
            double reward = Constant.MIN_REWARD;
            double sconfidence = Math.min(matchInfoList.get((int)i).exposureCnt.getSlotVal() / (double)hthr, 1.0);
            double aconfidence = Math.min(matchInfoList.get((int)i).exposureCnt.getAppVal() / (double)athr, 1.0);
            reward = sconfidence * AlgUtils.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * AlgUtils.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * AlgUtils.normlize(grpm * 0.5, maxG, 0.6);
            reward *= reward;
            reward = Math.max(reward, 0.0);
            materialModelList.get((int)i).reward = materialModelList.get((int)i).reward * Constant.DECAY + reward;
            materialModelList.get((int)i).count = materialModelList.get((int)i).count * Constant.DECAY + 1.0;
            materialModelList.get((int)i).alpha = 1.5 + materialModelList.get((int)i).reward;
            materialModelList.get((int)i).beta = 2.0 + (materialModelList.get((int)i).count - materialModelList.get((int)i).reward);
            rewards.add(materialModelList.get((int)i).reward);
            counts.add(materialModelList.get((int)i).count);
            alphas.add(materialModelList.get((int)i).alpha);
            betas.add(materialModelList.get((int)i).beta);
            materialIds.add(materialModelList.get((int)i).materialId);
            candis.add(materialModelList.get(i));
        }
        mMap.clear();
        MaterialDetail md = new MaterialDetail();
        MaterialRec20.getSinfos(ris, candis.size(), alphas, betas, materialIds, hrpms, arpms, grpms, exposures, excellents, scores, ctrs, pvCosts, ctr, uc);
        return candis;
    }

    private static void getSinfos(List<RankInfo> ris, int numMachines, ArrayList<Double> alphas, ArrayList<Double> betas, ArrayList<Long> materialIds, ArrayList<Double> hrpms, ArrayList<Double> arpms, ArrayList<Double> grpms, ArrayList<Double> exposures, ArrayList<Boolean> excellents, ArrayList<Double> scores, ArrayList<Double> ctrs, ArrayList<Double> pvCosts, double ctr, double uc) {
        for (int i = 0; i < numMachines; ++i) {
            double theta = AlgUtils.BetaDist(alphas.get(i), betas.get(i));
            RankInfo rankInfo = new RankInfo();
            rankInfo.setReward(theta);
            rankInfo.setIndex(i);
            rankInfo.setMaterialId(materialIds.get(i));
            rankInfo.setHrpm(hrpms.get(i));
            rankInfo.setArpm(arpms.get(i));
            rankInfo.setGrpm(grpms.get(i));
            rankInfo.setExposure(exposures.get(i));
            rankInfo.setExcellent(excellents.get(i));
            rankInfo.setScores(scores.get(i));
            rankInfo.setCtr(ctrs.get(i));
            rankInfo.setPvCost(pvCosts.get(i));
            rankInfo.setsCtr(ctr);
            ris.add(rankInfo);
        }
    }

    private static MaterialMatchInfo fillData(MaterialDataInfo mat, Set<Long> sckIds, Map<Long, MaterialNormInfo> exHashMap) {
        MaterialMatchInfo sckM = new MaterialMatchInfo();
        sckM.slotId = mat.slotId;
        sckM.appId = mat.appId;
        sckM.materialId = mat.materialId;
        sckM.setExcellent(sckIds.contains(mat.materialId));
        sckM.exposureCnt = new MaterialVal();
        sckM.exposureCnt.setAlgSlotVal(mat.exposureCnt.getAlgSlotVal());
        sckM.exposureCnt.setSlotVal(mat.exposureCnt.getSlotVal());
        sckM.exposureCnt.setAppVal(mat.exposureCnt.getAppVal());
        sckM.exposureCnt.setGlobalVal(mat.exposureCnt.getGlobalVal());
        sckM.clickCnt = new MaterialVal();
        sckM.clickCnt.setAlgSlotVal(mat.clickCnt.getAlgSlotVal());
        sckM.clickCnt.setSlotVal(mat.clickCnt.getSlotVal());
        sckM.clickCnt.setAppVal(mat.clickCnt.getAppVal());
        sckM.clickCnt.setGlobalVal(mat.clickCnt.getGlobalVal());
        sckM.cost = new MaterialVal();
        sckM.cost.setAlgSlotVal(mat.cost.getAlgSlotVal());
        sckM.cost.setSlotVal(mat.cost.getSlotVal());
        sckM.cost.setAppVal(mat.cost.getAppVal());
        sckM.cost.setGlobalVal(mat.cost.getGlobalVal());
        return sckM;
    }

    static class MaterialDetail {
        int index;
        ArrayList<RankInfo> condi;
        int strategyType;

        MaterialDetail() {
        }
    }

    static class MatchInfo {
        double score = 0.0;
        MaterialMatchInfo mat;

        MatchInfo() {
        }
    }

    static class Material {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        Material() {
        }
    }
}

