package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import java.util.*;

/**
 * @author lijingzhe
 * @description 广告位算法推荐状态描述
 * @date 2019/11/19
 */
public class SlotAlgRecInfo {
    /**
     * 算法版本
     */
    String algVersion;
    /**
     * 广告位id
     */
    long slotId;
    /**
     * 活动id
     */
    long activityId;
    /**
     * 活动id算法推荐次数
     */
    long algCnt;

    public String getAlgVersion() {
        return algVersion;
    }

    public void setAlgVersion(String algVersion) {
        this.algVersion = algVersion;
    }

    public long getSlotId() {
        return slotId;
    }

    public void setSlotId(long slotId) {
        this.slotId = slotId;
    }

    public long getActivityId() {
        return activityId;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public long getAlgCnt() {
        return algCnt;
    }

    public void setAlgCnt(long algCnt) {
        this.algCnt = algCnt;
    }

    public static void main(String[] args) {
        Map<String,Double> rates = new HashMap<>();
        rates.put("uc",0.9);
        rates.put("uck",0.89);
        rates.put("cvr",0.895);
        rates.put("ur",0.99);
        String oppAlg = "uc";
        double minAlg = rates.getOrDefault("uc",0d);
        for(Map.Entry<String,Double> rate : rates.entrySet()){
            if(minAlg > rate.getValue()){
                minAlg = rate.getValue();
                oppAlg = rate.getKey();
            }
        }
        System.out.println(oppAlg);
    }
}
