/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.common.model.deeptarget.ConsumeInfo;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepTargetControl {
    private static final Logger logger = LoggerFactory.getLogger(DeepTargetControl.class);

    public static DeepTargetInfo getFactor(DeepTargetInfo info) {
        if (AssertUtil.isEmpty(info)) {
            return null;
        }
        double selectFactor = 0.02;
        double sdkSelectFactor = 0.02;
        if ((double)info.getAdDeepConvert().longValue() > Constant.THRESHOLD) {
            double ratio;
            double lastSdkSelectFactor;
            double lastSelectFactor = info.getSelectFactor() != 0.0 ? info.getSelectFactor() : selectFactor;
            double d = lastSdkSelectFactor = info.getSdkSelectFactor() != 0.0 ? info.getSdkSelectFactor() : sdkSelectFactor;
            if (info.getAdDCvr() < info.getTargetCvr() && info.getTargetCvr() > 0.0) {
                ratio = info.getAdDCvr() / info.getTargetCvr();
                double factor = DeepTargetControl.getPredLevelFactor(info.getPreDcvrSum(), info.getPreDcvrPost(), info.getTargetCvr());
                double sdkFactor = DeepTargetControl.getPredLevelFactor(info.getPreDcvrSum(), info.getPreDcvrPost(), info.getTargetCvr());
                sdkSelectFactor = selectFactor = Math.min(Math.max(factor / 100.0, lastSelectFactor), 0.85 * info.getTargetCvr());
            }
            if (info.getAdDCvr() >= info.getTargetCvr() && info.getAdDCvr() > 0.0) {
                ratio = info.getTargetCvr() / info.getAdDCvr();
                selectFactor = lastSelectFactor * Math.sqrt(ratio);
                selectFactor = Math.min(Math.max(selectFactor, 0.005), 0.9 * lastSelectFactor);
                sdkSelectFactor = lastSdkSelectFactor * ratio;
                sdkSelectFactor = Math.min(Math.max(sdkSelectFactor, 0.005), 0.9 * lastSdkSelectFactor);
                sdkSelectFactor = selectFactor;
            }
        }
        info.setSelectFactor(selectFactor);
        info.setSdkSelectFactor(sdkSelectFactor);
        logger.info("pkg :{}, selectFactor :{}, sdkSelectFactor: {}", new Object[]{info.getPlanId(), selectFactor, sdkSelectFactor});
        return info;
    }

    private static Double getLevelPostRatio(double target, double interval, Set<Double> preLevel, Map<Double, Long> preDcvrSum, Map<Double, Long> preDcvrPost) {
        double targetLevel = target % interval == 0.0 ? Math.floor(target / interval) * interval : Math.floor(target / interval) * interval + interval;
        double sum_preDcvrSum = (double)preDcvrSum.get(targetLevel).longValue() * (targetLevel - target) / interval;
        double sum_preDcvrPost = (double)preDcvrPost.get(targetLevel).longValue() * (targetLevel - target) / interval;
        for (Double level : preLevel) {
            if (!(targetLevel < level)) continue;
            sum_preDcvrSum += (double)preDcvrSum.get(level).longValue();
            sum_preDcvrPost += (double)preDcvrPost.get(level).longValue();
        }
        double sum_preDcvrConvert = sum_preDcvrSum != 0.0 ? sum_preDcvrSum : 1.0;
        return sum_preDcvrPost / sum_preDcvrConvert;
    }

    public static Double getPredLevelFactor(Map<Double, Long> preDcvrSum, Map<Double, Long> preDcvrPost, double target) {
        if (AssertUtil.isAnyEmpty(preDcvrSum, preDcvrPost, target)) {
            return 0.02;
        }
        Set<Double> preLevel = preDcvrSum.keySet();
        double minLevel = Constant.minLevel;
        for (Double level : preLevel) {
            double ratio = level - target * 100.0;
            if (!(ratio >= 0.0) || !(ratio < 5.0)) continue;
            minLevel = level;
        }
        int interval = 5;
        int start = (int)minLevel;
        double ratio_minlevel = DeepTargetControl.getLevelPostRatio(target * 100.0, interval, preLevel, preDcvrSum, preDcvrPost);
        double minGap = Math.abs(target - ratio_minlevel);
        double targetLevel = minLevel;
        for (int i = start; i > 0; --i) {
            double postRatio = DeepTargetControl.getLevelPostRatio(i, interval, preLevel, preDcvrSum, preDcvrPost);
            if (!(Math.abs(postRatio - target) < minGap)) continue;
            targetLevel = i;
            minGap = Math.abs(postRatio - target);
        }
        return targetLevel;
    }

    public static ConsumeInfo getConsumeFactor(ConsumeInfo info) {
        if (AssertUtil.isEmpty(info)) {
            return null;
        }
        double costRatio = 1.0;
        double consume = info.getConsume().longValue();
        Double costConfWeight = DeepTargetControl.getConfidenceWeight(consume, Constant.costWeightBucket, Constant.costWeight, 0.5);
        Double costDayRatio = (double)info.getLastConsume().longValue() != 0.0 ? consume / (double)info.getLastConsume().longValue() : costConfWeight;
        Double ratioWeight = DeepTargetControl.getConfidenceWeight(costDayRatio, Constant.costRatioBucket, Constant.ratioWeight, 0.5);
        costRatio = 1.0 + costConfWeight * ratioWeight;
        info.setConsumeFactor(costRatio);
        return info;
    }

    public static Double getConfidenceWeight(Double value, double[] bucketList, double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }

    public static Double getConfidenceWeight2(Double value, double[] bucketList, double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = curWeight;
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i != size - 1) continue;
                ret = weightList[size - 1];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }

    public static void main(String[] args) {
        double target = 39.0;
        int interval = 5;
        double targetLevel = target % (double)interval == 0.0 ? Math.floor(target / (double)interval) * (double)interval : Math.floor(target / (double)interval) * (double)interval + (double)interval;
        System.out.println(targetLevel);
        HashMap<Double, Long> preDcvrSum = new HashMap<Double, Long>();
        HashMap<Double, Long> preDcvrPost = new HashMap<Double, Long>();
        preDcvrSum.put(5.0, 1322L);
        preDcvrSum.put(10.0, 21725L);
        preDcvrSum.put(15.0, 23613L);
        preDcvrSum.put(20.0, 11826L);
        preDcvrSum.put(25.0, 4702L);
        preDcvrSum.put(30.0, 1096L);
        preDcvrSum.put(35.0, 292L);
        preDcvrSum.put(40.0, 61L);
        preDcvrSum.put(45.0, 12L);
        preDcvrSum.put(50.0, 5L);
        preDcvrSum.put(55.0, 0L);
        preDcvrSum.put(60.0, 1L);
        preDcvrSum.put(65.0, 0L);
        preDcvrSum.put(70.0, 0L);
        preDcvrSum.put(75.0, 0L);
        preDcvrSum.put(80.0, 0L);
        preDcvrSum.put(85.0, 0L);
        preDcvrSum.put(90.0, 0L);
        preDcvrSum.put(95.0, 0L);
        preDcvrSum.put(100.0, 0L);
        preDcvrPost.put(5.0, 28L);
        preDcvrPost.put(10.0, 992L);
        preDcvrPost.put(15.0, 1575L);
        preDcvrPost.put(20.0, 983L);
        preDcvrPost.put(25.0, 467L);
        preDcvrPost.put(30.0, 128L);
        preDcvrPost.put(35.0, 42L);
        preDcvrPost.put(40.0, 6L);
        preDcvrPost.put(45.0, 1L);
        preDcvrPost.put(50.0, 0L);
        preDcvrPost.put(55.0, 0L);
        preDcvrPost.put(60.0, 0L);
        preDcvrPost.put(65.0, 0L);
        preDcvrPost.put(70.0, 0L);
        preDcvrPost.put(75.0, 0L);
        preDcvrPost.put(80.0, 0L);
        preDcvrPost.put(85.0, 0L);
        preDcvrPost.put(90.0, 0L);
        preDcvrPost.put(95.0, 0L);
        preDcvrPost.put(100.0, 0L);
        double ret = DeepTargetControl.getPredLevelFactor(preDcvrSum, preDcvrPost, 0.5);
        System.out.println(ret);
        DeepTargetInfo info = new DeepTargetInfo();
        info.setTargetCvr(0.2);
        info.setPreDcvrPost(preDcvrPost);
        info.setPreDcvrSum(preDcvrSum);
        info.setAdDeepConvert(1000L);
        info.setAdDCvr(0.067);
        info.setSelectFactor(0.0);
        info.setSdkSelectFactor(0.0);
        info = DeepTargetControl.getFactor(info);
        System.out.println(JSON.toJSONString((Object)info));
    }

    static class Constant {
        static double THRESHOLD = 50.0;
        static double minLevel = 5.0;
        static double minDeltaFactor = 0.5;
        static double[] costRatioBucket = new double[]{0.0, 0.1, 0.2, 0.5, 0.8, 1.0};
        static double[] ratioWeight = new double[]{0.0, 0.1, 0.2, 0.5, 0.8, 1.0};
        static double[] costWeightBucket = new double[]{0.0, 10000.0, 40000.0, 80000.0, 200000.0, 300000.0};
        static double[] costWeight = new double[]{0.0, 0.1, 0.2, 0.5, 0.6, 1.0};

        Constant() {
        }
    }
}

