package cn.com.duiba.nezha.alg.common.model.roipid;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

public class RoiPidRectify {
    private static final Logger logger = LoggerFactory.getLogger(cn.com.duiba.nezha.alg.common.model.roipid.RoiPidRectify.class);


    public static List<StatInfo> getPriceFactorRectify(PIDControlInfo pidControlInfo, List<StatInfo> infos,
                                                double orientTargetCpa, double budget, int mode)
    {

        if (AssertUtil.isAnyEmpty(infos,pidControlInfo)) {
            return infos;
        }
        List<StatInfo> result = new ArrayList<>();
        double costDay = pidControlInfo.costDay;
        double convertDay = pidControlInfo.convertDay;//累计转化
        double targetCpa = pidControlInfo.targetCpa;//目标出价
        double actualCpaDay = convertDay > 0 ? costDay / convertDay : costDay ;
        double biasDay = targetCpa > 0 ? actualCpaDay / targetCpa :  1.0;

        for(StatInfo info : infos) {
            info.factor1 = info.factor;
            double actual = info.sumConv > 0 ? info.sumFee / info.sumConv : orientTargetCpa;
            if (info.id.contains("DEFAULT")) {
                double bias = orientTargetCpa > 0 ? actual / orientTargetCpa : 1.0;
                if((bias <= 1.1 || biasDay <= 1.1) && info.factor < 1.0){
                    double factor = Math.max(1.0,Math.min(1.1,info.factor*1.1));
                    info.factor = factor;
                }
                if(info.factor < 0.8 * 1/bias) {
                    double factor = info.factor * 1.1;
                    info.factor = factor;
                }
            }

            if (info.id.contains("APP") || info.id.contains("SLOT")) {
                double appTargetCpa = info.appTargetCpa;
                double appbias = appTargetCpa > 0 ? actual / appTargetCpa : 1.0;
                if (appbias <= 1.1 && info.factor < 1.0){
                    double factor = Math.min(1.1,info.factor * 1.1);
                    info.factor = factor;
                }
                if (appbias <= 0.9 && info.factor < 1.5){
                    double factor = info.factor * 1.05;
                    info.factor = factor;
                }
            }
            result.add(info);
        }
        return result;
    }


    public static void main(String[] args) {
        RoiPidRectify re = new RoiPidRectify();
        String str ="{\"convertDay\":100,\"convertHour\":2,\"convertLastHour\":3,\"costDay\":14190," +
                "\"costHour\":2,\"costLastHour\":3,\"factor\":0.6,\"lastFactorExplorationDo\":{\"fa\n" +
                "ctorExploreMap\":{\"0\":0.999999,\"1\":1.0,\"2\":1.0}," +
                "\"factorFlowRateMap\":{\"0\":0.0,\"1\":0.101,\"2\":0.901}},\"targetCpa\":10000.0}";

        JSONObject object = JSON.parseObject(str);
        PIDControlInfo pidControlDoInfo = JSONObject.parseObject(str, PIDControlInfo.class);

        String str1 = "[{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":0.85,\"fee7d\":0.0,\"id\":\"DEFAULT\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":207.0,\"sumConv\":22.0,\"sumFee\":21000.0},{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":0.9,\"fee7d\":0.0,\"id\":\"APP\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":200.0,\"sumConv\":22.0,\"sumFee\":10000.0,\"appTargetCpa\":500.0},{\"click7d\":0.0,\"conv7d\":0.0,\"factor\":1.0,\"fee7d\":0.0,\"id\":\"TAG_02.12.0001-0_68657\",\"lastSumConv\":0.0,\"lastSumFee\":0.0,\"parentFactor\":0.9999999999999998,\"sumClick\":207.0,\"sumConv\":22.0,\"sumFee\":13940.0}]";
//        StatInfo exp = JSONObject.parseObject(str1, StatInfo.class);
//
//        List<StatInfo> infos = new ArrayList<>();
//        infos.add(exp);

        List<StatInfo> statInfos = JSONObject.parseArray(str1, StatInfo.class);

        List<StatInfo> ret = getPriceFactorRectify(pidControlDoInfo, statInfos,1000,0.0,4);
        for (StatInfo f :ret) {
//            Double factor = f.factor;
            System.err.println(JSON.toJSONString(f));
        }
    }
}
