package cn.com.duiba.nezha.alg.common.util;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


/**
 * Created by pc on 2017/9/7.
 */
public class DataUtil {

    public static int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();  // 关闭 FastJson 使用 BigDecimal 装载数字

    public static <T> T getValueOrDefault(T value, T defaultValue) {

        if (value != null) {
            return value;
        } else {
            return defaultValue;
        }
    }

    /**
     * 判断是否比阈值大
     *
     * @param value1
     * @param value2
     * @return
     */
    public static boolean isLarger(Long value1, Long value2) {

        boolean ret = false;

        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }

        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Double toDouble(Long value) {
        return long2Double(value, 1L, 0);
    }


    public static double todouble(Double value) {
        double ret = 0;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static int toInt(Long value) {
        int ret = 0;
        if (value != null) {
            ret = value.intValue();
        }
        return ret;
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Double long2Double(Long value, Long amplification, int newScala) {
        Double ret = null;
        if (value != null) {
            ret = (value + 0.0) / amplification;

            if (ret != null) {
                ret = formatDouble(ret.doubleValue(), newScala);
            }

        }
        return ret;
    }


    /**
     * @param value
     * @param amplification
     * @return
     */
    public static double long2double(long value, long amplification, int newScala) {
        double ret = formatdouble((value + 0.0) / amplification, newScala);
        return ret;
    }


    /**
     * 位数截取
     *
     * @param d
     * @return
     */
    public static Double formatDouble(Double d, int newScala) {
        Double ret = null;
        if (d != null) {
            BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
            ret = bg.doubleValue();
        }
        return ret;
    }


    /**
     * 位数截取
     *
     * @param d
     * @return
     */
    public static double formatdouble(double d, int newScala) {

        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
        double ret = bg.doubleValue();
        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Long double2Long(Double value) {
        if (value != null) {
            return double2Long(value, 1L);
        } else {
            return null;
        }

    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Long double22Long(Double value, Long amplification) {
        Long ret = null;
        if (amplification == null) {
            amplification = 1L;
        }

        if (value != null) {
            ret = Math.round(value * amplification);
        }
        return ret;
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static long double2long(double value, long amplification) {
        return Math.round(value * amplification);
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Long double2Long(double value, Long amplification) {
        return Math.round(value * amplification);
    }

    public static String listToString(List<String> v1) {
        if (v1 == null || v1.size() < 1) {
            return null;
        }
        return String.join(",", v1);
    }
    public static String SetToString(Set<String> v1) {
        if (v1 == null || v1.size() < 1) {
            return null;
        }
        return String.join(",", v1);
    }


    public static String longListToString(List<Long> v1) {
        if (v1 == null || v1.size() < 1) {
            return null;
        }

        List<String> strings = v1.stream().map(x -> x + "").collect(Collectors.toList());
        return listToString(strings);
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Long addLong(Long v1, Long v2) {
        Long ret = 0L;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double addDouble(Double v1, Double v2, int newScala) {

        return formatDouble(addDouble(v1, v2), newScala);
    }

    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double addDouble(Double v1, Double v2) {
        Double ret = 0.0;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double multiplyDouble(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double multiply(Double v1, Long v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Long multiplyLong(Long v1, Long v2) {
        Long ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static Double division(Double v1, Long v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }

    public static Double division(Double v1, Long v2) {
        return division(v1, toDouble(v2));
    }

    public static Double division(Long v1, Double v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }


    public static Double division(Long v1, Double v2) {
        return division(toDouble(v1), v2);
    }


    /**
     * @param v1       分子
     * @param v2       分母
     * @param newScala 保留小数位数
     * @return
     */
    public static Double division(Long v1, Long v2, int newScala) {

        return formatDouble(division(v1, v2), newScala);
    }

    public static Double division(Long v1, Long v2) {

        return division(toDouble(v1), toDouble(v2));
    }


    public static Double division(Double v1, Double v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }


    public static boolean between(double value, double low, double high) {

        boolean ret = false;
        if (value >= low && value <= high) {
            ret = true;
        }
        return ret;
    }

    public static Double division(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 / (v2 + 0.0000000001);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Long str2Long(String value, Long defaultVal) {
        Long ret = defaultVal;
        if (value != null && value != "" && value != "null") {
            try {
                ret = Long.valueOf(value);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return ret;
    }

    public static String stringStd(String src) {
        if (src == "") {
            return null;
        } else {
            return src;
        }
    }

    public static String Long2String(Long src) {
        String ret = null;
        if (src != null) {
            ret = Long.toString(src);
        }
        return ret;

    }


    public static Long string2Long(String src) {
        Long ret = null;
        if (src != null) {
            ret = Long.valueOf(src);
        }
        return ret;

    }


    public static Double string2Double(String src) {
        Double ret = null;
        if (src != null) {
            ret = Double.valueOf(src);
        }
        return ret;

    }

    public static String Integer2String(Integer src) {
        String ret = null;
        if (src != null) {
            ret = Integer.toString(src);
        }
        return ret;

    }

    public static String Integer2String(Integer src, String defaultValue) {
        String ret = defaultValue;
        if (src != null) {
            ret = Integer.toString(src);
        }
        return ret;

    }

    public static String double2String(Double src) {
        String ret = null;
        if (src != null) {
            ret = Double.toString(src);
        }
        return ret;

    }


    public static List<String> stringToList(String src, String sep) {
        List<String> ret = null;
        if (src != null && sep != null) {
            String[] tmp = src.split(sep);
            ret = Arrays.asList(tmp);
        }
        return ret;
    }


    /**
     * 未进行数据类型校验
     * 自行确保 value的类型为 传进来的 T 类型， 否则get时可能会报类型转换错误！
     *
     * @param src
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> Map<String, T> stringToMap(String src, T cls) {
        if (src == null) return null;

        try {
            return (Map<String, T>) JSON.parseObject(src, Map.class, disableDecimalFeature);
        } catch (Exception e) {
            return null;
        }
    }

    public static JSONObject stringToJson(String src) {
        if (src == null) return null;

        try {
            return JSONObject.parseObject(src);
        } catch (Exception e) {
            return null;
        }
    }


    public static <T> T[] addAll(final T[] array1, final T... array2) {
        if (array1 == null) {
            return array2.clone();
        } else if (array2 == null) {
            return array1.clone();
        }
        final Class<?> type1 = array1.getClass().getComponentType();
        @SuppressWarnings("unchecked") // OK, because array is of type T
        final
        // a处
        T[] joinedArray = (T[]) Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            // b处
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        } catch (final ArrayStoreException ase) {
            // Check if problem was due to incompatible types
            /*
             * We do this here, rather than before the copy because:
             * - it would be a wasted check most of the time
             * - safer, in case check turns out to be too strict
             */
            final Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of "
                        + type1.getName(), ase);
            }
            throw ase; // No, so rethrow original
        }
        return joinedArray;
    }

    public static double[] insertElement(double original[], double element, int index) {

        int length = original.length;

        double destination[] = new double[length + 1];

        System.arraycopy(original, 0, destination, 0, index);

        destination[index] = element;

        System.arraycopy(original, index, destination, index + 1, length - index);

        return destination;
    }

    public static double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) return 0.0;

        if (baseCnt <= 0) return 0.0;

        double ratio = targetCnt * 1.0 / baseCnt;
        double faithSquare = faithLevel * faithLevel;

        return (ratio + (faithSquare / (2 * baseCnt)) - faithLevel * Math.sqrt(4 * baseCnt * ratio * (1 - ratio) + faithSquare) / (2 * baseCnt)) / (1 + faithSquare / baseCnt);
    }

    public static String featureFormat(String realTime, String offline) {
        if (realTime == null) {
            return offline;
        } else {
            return realTime;
        }
    }

}
