/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade;

import cn.com.duiba.nezha.alg.common.model.adjustprice.AdjustPrice;
import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb;
import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.expupgrade.ExploreResultV2;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvertExploreV2 {
    private static final Logger logger = LoggerFactory.getLogger(AdvertExploreV2.class);

    public static List<ExploreResultV2> exploreV2(List<ExploreInfo> exploreInfos, ExploreParams exploreParams, AdExploreUcbData adExploreUcbData, String expNum) {
        if (AssertUtil.isAnyEmpty(exploreInfos, exploreParams)) {
            return null;
        }
        if (Math.random() < 1.0E-4) {
            logger.info("params AdvertExplore2:{}", (Object)exploreParams.toString());
        }
        Double expratio = exploreParams.getExpratio();
        Integer activeReTarget = exploreParams.getActiveReTarget();
        List<String> expATrade = exploreParams.getExpATrade();
        List<String> expBTrade = exploreParams.getExpBTrade();
        List<String> expCTrade = exploreParams.getExpCTrade();
        Long expCnt1 = exploreParams.getAppAdExpCnt1();
        Long expCnt2 = exploreParams.getAppAdExpCnt2();
        double bidfactor = exploreParams.getBidfactor();
        double afeefactor = exploreParams.getAfeefactor();
        double expFactor = exploreParams.getExpFactor().longValue();
        List<Double> biasBucket = exploreParams.getBiasBucket();
        List<Double> factorBucket = exploreParams.getFactorBucket();
        List<Double> expBiasBucket = exploreParams.getExpBiasBucket();
        List<Double> expFactorBucket = exploreParams.getExpFactorBucket();
        List<Double> bidRatioBucket = exploreParams.getBidRatioBucket();
        List<Double> bidFactorBucket = exploreParams.getBidFactorBucket();
        double biasWeight = exploreParams.getBiasWeight();
        double limitFactor = exploreParams.getLimitFactor();
        Double[] finalBiasBucket = biasBucket.toArray(new Double[biasBucket.size()]);
        Double[] finalFactorBucket = factorBucket.toArray(new Double[factorBucket.size()]);
        Double[] expbiasBucket1 = expBiasBucket.toArray(new Double[expBiasBucket.size()]);
        Double[] expFactorBucket1 = expFactorBucket.toArray(new Double[expFactorBucket.size()]);
        Double[] bidRatioBucket1 = bidRatioBucket.toArray(new Double[bidRatioBucket.size()]);
        Double[] bidFactorBucket1 = bidFactorBucket.toArray(new Double[bidFactorBucket.size()]);
        ArrayList<ExploreResultV2> resList = new ArrayList<ExploreResultV2>();
        for (ExploreInfo info : exploreInfos) {
            ExploreResultV2 res = new ExploreResultV2(info.getAdvertId(), info.getOrientationId());
            Map<Integer, Double> scoreMap = info.getScoreMap();
            res.setScoreMap(scoreMap);
            double exploreRatio = AdExploreUcb.division(info.getAppAdvertInfo().getAdvertExploreConsume(), info.getAppAdvertInfo().getAdvertOcpcConsume());
            HashSet<Integer> expWays = new HashSet<Integer>();
            if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000L || exploreRatio < expratio) && info.getAppAdvertInfo().getAppAdExpCnt() < expCnt1 && info.getIsCandidate1().booleanValue() && info.getRealseTarget() == activeReTarget) {
                double bid = 0.0;
                double orientProb1 = 0.1;
                if (info.getConvertType() == 0 && info.getAppTradeInfo().getData3day().getConv() != null && info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()) != null) {
                    double tradeCvr = AdExploreUcb.division(info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()), info.getAppTradeInfo().getData3day().getClick());
                    bid = (double)info.getTarget().longValue() * tradeCvr;
                    orientProb1 = info.getAppTradeInfo().getData3day().getConv().get(info.getConvertType()) >= 5L ? bid * bidfactor : 0.1;
                }
                double afee = info.getTarget().longValue();
                double orientProb2 = afee * afeefactor;
                double orientProb = Math.max(orientProb1, orientProb2);
                orientProb = Math.max(Math.min(orientProb, 0.8), 0.1);
                Random r1 = new Random();
                if ("expA".equals(expNum) && r1.nextDouble() < orientProb && expATrade.contains(info.getTradeId()) || "expB".equals(expNum) && r1.nextDouble() < orientProb && expBTrade.contains(info.getTradeId()) || "expC".equals(expNum) && r1.nextDouble() < orientProb && expCTrade.contains(info.getTradeId())) {
                    expWays.add(1);
                    res.setExpWays(expWays);
                    double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket, expbiasBucket1, expFactorBucket1, bidRatioBucket1, bidFactorBucket1, biasWeight, limitFactor);
                    scoreMap.put(4, factor);
                    res.setScoreMap(scoreMap);
                    res.setExpAdjustFactor(factor);
                }
            }
            if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000L || exploreRatio < expratio) && info.getAppAdvertInfo().getAppAdExpCnt() < expCnt2 && info.getIsCandidate2().booleanValue() && info.getRealseTarget() == activeReTarget && ("expA".equals(expNum) && expATrade.contains(info.getTradeId()) || "expB".equals(expNum) && expBTrade.contains(info.getTradeId()) || "expC".equals(expNum) && expCTrade.contains(info.getTradeId()))) {
                expWays.add(2);
                res.setExpWays(expWays);
                double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket, expbiasBucket1, expFactorBucket1, bidRatioBucket1, bidFactorBucket1, biasWeight, limitFactor);
                scoreMap.put(4, factor);
                res.setScoreMap(scoreMap);
                res.setExpAdjustFactor(factor);
            }
            if ((info.getAppAdvertInfo().getAdvertExploreConsume() < 5000L || exploreRatio < expratio) && info.getAppAdvertInfo().getAppAdExpCnt() < expCnt2 && MapUtils.isNotEmpty(info.getScoreMap()) && info.getRealseTarget() == activeReTarget) {
                double prob = Math.max(Math.min(AdExploreUcb.division((Double)expFactor, info.getAppAdvertInfo().getAppAdExpCnt()), 0.8), 0.2);
                Random r2 = new Random();
                if ("expA".equals(expNum) && r2.nextDouble() < prob && expATrade.contains(info.getTradeId()) || "expB".equals(expNum) && r2.nextDouble() < prob && expBTrade.contains(info.getTradeId()) || "expC".equals(expNum) && r2.nextDouble() < prob && expCTrade.contains(info.getTradeId())) {
                    expWays.add(3);
                    res.setExpWays(expWays);
                    double factor = AdjustPrice.adjustFactor(info, finalBiasBucket, finalFactorBucket, expbiasBucket1, expFactorBucket1, bidRatioBucket1, bidFactorBucket1, biasWeight, limitFactor);
                    scoreMap.put(4, factor);
                    res.setScoreMap(scoreMap);
                    res.setExpAdjustFactor(factor);
                }
            }
            resList.add(res);
        }
        return resList;
    }

    public static void main(String[] args) {
    }
}

