package cn.com.duiba.nezha.alg.common.model.advertexplore;


import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ExploreV1PkgData {

    private Long orientationId;    // 配置ID
    private Long advertId;  // 广告ID

    private Integer exploit = 0;    // 是否利用，0-探索，1-利用

    private Long target = 1000L;    // 目标成本

    private Double e1;  // 探索CTR
    private Double e2;  // 探索CVR

    private WeightInfoList c1;  // CTR权重信息
    private WeightInfoList c2;  // CVR权重信息

    private WeightInfo c3;  // 成本权重信息

    private WeightInfo n1;    // CTR数量权重信息
    private WeightInfo n2;    // CVR数量权重信息

    public ExploreV1PkgData(Long orientationId, Long advertId, Integer exploit, Long target, Double e1, Double e2, WeightInfoList c1, WeightInfoList c2, WeightInfo c3, WeightInfo n1, WeightInfo n2) {
        this.orientationId = orientationId;
        this.advertId = advertId;
        this.exploit = exploit;
        this.target = target;
        this.e1 = e1;
        this.e2 = e2;
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.n1 = n1;
        this.n2 = n2;
    }

    public ExploreV1PkgData(Long orientationId, Long advertId, Integer exploit, Long target, Double e1, Double e2) {
        this.orientationId = orientationId;
        this.advertId = advertId;
        this.exploit = exploit;
        this.target = target;
        this.e1 = e1;
        this.e2 = e2;
    }
}
