package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl.getConfidenceWeight2;

public class DeepAdjustFactor {


    private static final Logger logger = LoggerFactory.getLogger(cn.com.duiba.nezha.alg.common.model.deeptarget.DeepAdjustFactor.class);


    static class Constant {

        static double THRESHOLD = 0;//后端转化个数置信阈值
    }


    /**
     * 计算加价因子
     * @param preDcvrStatInfo
     * @param preDcvr
     * @param preCvr
     * @return
     */
    public static double deepAdjustFactor(PreDcvrStatInfo preDcvrStatInfo,
                                          Double preDcvr,
                                          Double preCvr,
                                          Long adDeepConvert,
                                          Double minFactor,
                                          Double maxFactor) {


        double factor = 1.0;
        if(AssertUtil.isAnyEmpty(preDcvrStatInfo,preDcvr)){
            return factor;
        }

        if( adDeepConvert == null || adDeepConvert < Constant.THRESHOLD){
            return factor;
        }
        Double mergeMean = preDcvrStatInfo.getMergeMean();//指数衰减加权融均值
        Double mergeSD = preDcvrStatInfo.getMergeSD();//指数衰减加权融标准差


        minFactor = minFactor != null ? minFactor : 0.85;
        maxFactor = maxFactor != null ? maxFactor : 1.2;

        if(mergeMean != null && mergeSD != null && preDcvr != null && preDcvr > 0.0) {
            double level1 = Math.max(mergeMean * 0.2,0.0);
            double level2 = Math.max(mergeMean * 0.4,0.0);
            double level3 = Math.max(mergeMean * 0.8,0.0);
            double level4 = Math.min(mergeMean * 1.2,1.0);
            double level5 = Math.min(mergeMean * 1.6,1.0);
            double level6 = Math.min(mergeMean * 2,1.0);

            double step_0 = (1.0 - minFactor) / 3;
            double step_1 = (maxFactor - 1.0) / 3 ;

            double[] bucket = {0, level1, level2, level3, mergeMean, level4, level5, level6, 1.0};
            double[] weight = {minFactor, minFactor, minFactor + step_0, minFactor+step_0 * 2, 1.0, 1.0+step_1, 1.0+step_1 * 2, maxFactor, maxFactor};

            factor = getConfidenceWeight2(preDcvr, bucket, weight, 1.0);

        }

        return factor;

    }



    public static void main(String[] args) {
        PreDcvrStatInfo preDcvrStatInfo = new PreDcvrStatInfo();
        preDcvrStatInfo.setMergeMean(0.2);
        preDcvrStatInfo.setMergeSD(0.05);
        double ret = deepAdjustFactor(preDcvrStatInfo,0.1,0.2,5000L,0.85,null);
        System.out.println(ret);

    }

}

