/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.roipid;

import cn.com.duiba.nezha.alg.common.model.roipid.PIDControlInfo;
import cn.com.duiba.nezha.alg.common.model.roipid.PIDFactorExplorationDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIDFactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(PIDFactorExploration.class);
    static double[] costWeightBucket = new double[]{0.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0};
    static double[] costWeight = new double[]{1.0, 1.0, 0.9, 0.8, 0.7, 0.5};
    static double[] biasWeightBucket = new double[]{0.0, 1.0, 1.2, 1.5, 2.0, 5.0};
    static double[] biasWeight = new double[]{1.0, 1.0, 0.9, 0.8, 0.7, 0.5};

    public static PIDFactorExplorationDo exploreFactor(PIDControlInfo pidControlInfo) {
        if (AssertUtil.isEmpty(pidControlInfo)) {
            return null;
        }
        PIDFactorExplorationDo ret = new PIDFactorExplorationDo();
        PIDFactorExploration.circuitBreaker(pidControlInfo, ret);
        try {
            Double lastFactor = pidControlInfo.factor != null ? pidControlInfo.factor : 1.0;
            Double lowerLimit = 0.4;
            Double upperLimit = 1.2;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double baseValue = lastFactor;
            Double defaultValue = lastFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.5, 0.3};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(FactorLevel.values().length);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(FactorLevel.values().length);
            if (AssertUtil.isNotEmpty(pidControlInfo)) {
                double costDay = pidControlInfo.costDay.longValue();
                double costHour = pidControlInfo.costHour.longValue();
                double costLastHour = pidControlInfo.costLastHour.longValue();
                double convertDay = pidControlInfo.costLastHour.longValue();
                double convertHour = pidControlInfo.convertHour.longValue();
                double convertLastHour = pidControlInfo.convertLastHour.longValue();
                double targetCpa = pidControlInfo.targetCpa;
                double actualCpaHour = convertHour > 0.0 ? costHour / convertHour : costHour;
                double actualCpaDay = convertDay > 0.0 ? costDay / convertDay : costDay;
                double actualCpaLastHour = convertLastHour > 0.0 ? costLastHour / convertLastHour : costLastHour;
                double biasDay = targetCpa > 0.0 ? actualCpaDay / targetCpa : 1.0;
                double biasHour = targetCpa > 0.0 ? actualCpaHour / targetCpa : 1.0;
                double biasLastHour = targetCpa > 0.0 ? actualCpaLastHour / targetCpa : 1.0;
                double actual = convertHour > 0.0 ? costHour / convertHour : targetCpa;
                double initFactor = targetCpa / actual;
                if (convertHour >= 3.0 && convertHour < 5.0) {
                    initFactor = initFactor > 1.2 ? 1.2 : initFactor;
                    initFactor = initFactor < 0.8 ? 0.8 : initFactor;
                } else if (convertHour >= 5.0 && convertHour < 10.0) {
                    if (initFactor < 1.0) {
                        initFactor = Math.pow(initFactor, 1.5);
                    }
                    initFactor = initFactor > 1.5 ? 1.5 : initFactor;
                    initFactor = initFactor < 0.7 ? 0.7 : initFactor;
                } else if (convertHour >= 10.0) {
                    if (initFactor < 1.0) {
                        initFactor = Math.pow(initFactor, 2.0);
                    }
                    initFactor = initFactor > 2.0 ? 2.0 : initFactor;
                    initFactor = initFactor < 0.5 ? 0.5 : initFactor;
                } else if (costHour < 5.0 * targetCpa) {
                    initFactor = 1.0;
                } else {
                    initFactor = targetCpa / costHour;
                    initFactor = initFactor > 1.5 ? 1.5 : initFactor;
                    initFactor = initFactor < 0.5 ? 0.5 : initFactor;
                }
                baseValue = initFactor;
                defaultValue = baseValue - lastFactor > 0.2 || baseValue - lastFactor < -0.2 ? baseValue : lastFactor;
                Double costBias = costLastHour != 0.0 ? costHour / costLastHour : 1.0;
                Double costConfWeight = PIDFactorExploration.getConfidenceWeight(costHour, costWeightBucket, costWeight, 0.5);
                Double biasConfWeight = PIDFactorExploration.getConfidenceWeight(biasHour, biasWeightBucket, biasWeight, 0.5);
                if (costDay <= 0.0 || biasHour >= 5.0) {
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division((Double)biasHour, costConfWeight), -0.3), -0.01);
                    stepList[2] = Math.min(0.2 * DataUtil.division((Double)(costConfWeight * biasConfWeight), costBias), 0.1);
                    baseFlowRate[0] = 0.9;
                    baseFlowRate[2] = 0.0;
                } else if ((costHour <= 5000.0 || costBias <= 0.7) && biasHour <= 2.0) {
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division((Double)biasHour, costConfWeight), -0.1), -0.01);
                    stepList[2] = Math.min(Math.max(0.2 * DataUtil.division((Double)(costConfWeight * biasConfWeight), costBias), 0.1), 0.3);
                    baseFlowRate[2] = Math.min(Math.max(costConfWeight * biasConfWeight, 0.6), 0.9);
                    baseFlowRate[0] = baseFlowRate[2] > 0.8 ? 0.0 : 0.15;
                } else {
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division((Double)biasHour, costConfWeight), -0.1), -0.01);
                    stepList[2] = Math.min(Math.max(0.2 * DataUtil.division((Double)(costConfWeight * biasConfWeight), costBias), 0.1), 0.2);
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                }
                baseFlowRate[1] = DataUtil.formatDouble(1.0 - baseFlowRate[2] - baseFlowRate[0], 3);
            }
            for (FactorLevel factorLevel : FactorLevel.values()) {
                String key = factorLevel.getCode();
                int i = DataUtil.toInt(DataUtil.string2Long(key));
                Double factor = DataUtil.formatDouble(PIDFactorExploration.getNormalValue(defaultValue + stepList[i], baseValue, lowerLimit, upperLimit), 6);
                Double flowRate = DataUtil.formatDouble(baseFlowRate[i], 3);
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            if (Math.random() < 0.01) {
                logger.info("FactorExploration:{} ", (Object)JSON.toJSONString((Object)ret));
            }
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;
        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = curWeight;
                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }

    public static void circuitBreaker(PIDControlInfo pidControlInfo, PIDFactorExplorationDo ret) {
        Boolean label = false;
        Double target = pidControlInfo.targetCpa != 0.0 ? pidControlInfo.targetCpa : 1.0;
        Double orientCostG1d = pidControlInfo.costDay != null ? (double)pidControlInfo.costDay.longValue() : 0.0;
        Long orientConvert = pidControlInfo.convertDay;
        Double orientConfidence = orientCostG1d / (target * 5.0);
        Double orientCostConvert = orientConvert != 0L && orientCostG1d != 0.0 ? orientCostG1d / (double)orientConvert.longValue() : target;
        Double orientCostConvertbias = orientConvert != 0L ? orientCostConvert / target : orientCostG1d / target;
        if (orientCostG1d >= 50000.0 && orientCostConvertbias >= 1.1) {
            ret.setCirBreaker(true);
            ret.setCostConvertbias(orientCostConvertbias);
        }
    }

    public static void main(String[] args) {
        String str = "{\"convertDay\":100,\"convertHour\":10,\"convertLastHour\":2000,\"costDay\":60000,\"costHour\":60000,\"costLastHour\":0,\"factor\":0.6,\"lastFactorExplorationDo\":{\"fa\nctorExploreMap\":{\"0\":0.999999,\"1\":1.0,\"2\":1.0},\"factorFlowRateMap\":{\"0\":0.0,\"1\":0.101,\"2\":0.901}},\"targetCpa\":100.0}";
        JSONObject object = JSON.parseObject((String)str);
        PIDControlInfo pidControlDoInfo = (PIDControlInfo)JSONObject.parseObject((String)str, PIDControlInfo.class);
        PIDFactorExplorationDo ret3 = PIDFactorExploration.exploreFactor(pidControlDoInfo);
        System.out.println("ret3:" + JSON.toJSONString((Object)ret3));
    }

    public static enum FactorLevel {
        LOW("0", "level-0"),
        STABLE("1", "level-1"),
        HIGH("2", "level-2");

        private String code;
        private String dec;

        private FactorLevel(String code, String dec) {
            this.code = code;
            this.dec = dec;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDec() {
            return this.dec;
        }

        public void setDec(String dec) {
            this.dec = dec;
        }
    }
}

