/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.slotmaterialselect;

import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.AppSlot;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.MatchInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.NormInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SelectInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotCtr;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialModel;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.Val;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotMaterialSelect {
    private static final Logger logger = LoggerFactory.getLogger(SlotMaterialSelect.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.matchScore - c1.matchScore >= 0.0 ? 1 : -1;
        }
    };
    public static Comparator<MatchInfo> normComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return m2.nCtr - m1.nCtr >= 0.0 ? 1 : -1;
        }
    };

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static double getRate(double cnt, double partCnt) {
        return cnt > 0.0 ? (partCnt < cnt ? partCnt / cnt : 0.0) : 0.0;
    }

    private double getCtr(double ... parms) {
        if (parms.length == 2) {
            double exposure = parms[0];
            double click = parms[1];
            double ctr = SlotMaterialSelect.getRate(exposure, click);
            return exposure > 5000.0 ? SlotMaterialSelect.getRate(exposure, click) : Math.min(ctr, Constant.MIN_REWARD);
        }
        if (parms.length == 3) {
            double exposure = parms[0];
            double click = parms[1];
            double biasCtr = parms[2];
            double ctr = SlotMaterialSelect.getRate(exposure, click);
            return ctr <= 2.0 * biasCtr ? (exposure > 5000.0 ? ctr : Math.min(ctr, Constant.MIN_REWARD)) : 0.0;
        }
        return 0.0;
    }

    public double getWilsonCtr(double ... parms) {
        if (parms.length == 2) {
            double exposure = parms[0];
            double click = parms[1];
            double ctr = this.getCtr(exposure, click);
            return WilsonInterval.wilsonCalc((long)((long)(exposure * ctr)), (long)((long)exposure)).lowerBound;
        }
        if (parms.length == 3) {
            double exposure = parms[0];
            double click = parms[1];
            double biasCtr = parms[2];
            double ctr = this.getCtr(exposure, click, biasCtr);
            return WilsonInterval.wilsonCalc((long)((long)(exposure * ctr)), (long)((long)exposure)).lowerBound;
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public List<MatchInfo> matchSDK(List<SlotMaterialInfo> materialList) {
        void var20_30;
        double prob = 1.0E-4;
        int exposureThreshold = 200;
        if (materialList.size() == 0) {
            return null;
        }
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> normCandis = new PriorityQueue<MatchInfo>(materialList.size(), normComparator);
        ArrayList<MatchInfo> result = new ArrayList<MatchInfo>();
        HashMap<Long, NormInfo> materialSet = new HashMap<Long, NormInfo>();
        HashMap normMap = new HashMap();
        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet<Long>();
        int limitTopn = topn;
        HashMap<Long, MatchInfo> mMap = new HashMap<Long, MatchInfo>();
        HashMap<Long, SlotCtr> sMap = new HashMap<Long, SlotCtr>();
        for (SlotMaterialInfo slotMaterialInfo : materialList) {
            if (slotMaterialInfo.type != 1) continue;
            long slot_id = slotMaterialInfo.slotId;
            SlotCtr slotCtr = sMap.getOrDefault(slot_id, new SlotCtr());
            double slotExposure = slotMaterialInfo.getExposureCnt().getSlotVal();
            double globalExposure = slotMaterialInfo.getExposureCnt().getGlobalVal();
            double slotClick = slotMaterialInfo.getClickCnt().getSlotVal();
            double globalClick = slotMaterialInfo.getClickCnt().getGlobalVal();
            slotCtr.click += slotClick;
            slotCtr.exposure += slotExposure;
            sMap.put(slot_id, slotCtr);
            double slotCtr2 = this.getCtr(slotExposure, slotClick);
            double globalCtr = this.getCtr(globalExposure, globalClick);
            NormInfo nf = materialSet.containsKey(slotMaterialInfo.materialId) ? (NormInfo)materialSet.get(slotMaterialInfo.materialId) : new NormInfo();
            nf.materialId = slotMaterialInfo.materialId;
            nf.nCtr += slotExposure / globalExposure * globalCtr / slotCtr2;
            materialSet.put(slotMaterialInfo.materialId, nf);
        }
        List materials = new ArrayList(materialSet.values()).stream().sorted(Comparator.comparing(NormInfo::getnCtr).reversed()).limit(30L).collect(Collectors.toList());
        for (SlotMaterialInfo m : materialList) {
            AppSlot appSlot = new AppSlot();
            appSlot.setAppId(m.appId);
            appSlot.setSlotId(m.slotId);
            HashSet<Long> hashSet = normMap.getOrDefault(appSlot, new HashSet());
            hashSet.add(m.materialId);
            normMap.put(appSlot, hashSet);
            try {
                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();
                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();
                MatchInfo info = mMap.containsKey(m.materialId) ? (MatchInfo)mMap.get(m.materialId) : new MatchInfo();
                this.fillMatchInfo(info, m);
                info.setnCtr(((NormInfo)materialSet.get((Object)Long.valueOf((long)m.materialId))).nCtr);
                double biasCtr = SlotMaterialSelect.getRate(((SlotCtr)sMap.get((Object)Long.valueOf((long)m.slotId))).exposure, ((SlotCtr)sMap.get((Object)Long.valueOf((long)m.slotId))).click);
                if (globalExposure < (double)exposureThreshold) {
                    if (System.currentTimeMillis() - m.getCreateTime() < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(info);
                            --topn;
                            idset.add(info.materialId);
                        }
                    } else if (materialList.size() > limitTopn && Math.random() < 0.1 * prob) {
                        result.add(info);
                        --topn;
                        idset.add(info.materialId);
                    }
                }
                double slotScore = this.getWilsonCtr(slotExposure, slotClick);
                double matchscore = 0.0;
                if (info.type == 1) {
                    double globalScore = this.getWilsonCtr(globalExposure, globalClick);
                    double appScore = this.getWilsonCtr(appExposure, appClick);
                    double sconfidence = Math.min(slotExposure / 200.0, 1.0);
                    double aconfidence = Math.min(appExposure / 200.0, 1.0);
                    double gconfidence = Math.min(globalExposure / 2000.0, 1.0);
                    matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    info.setMatchScore(matchscore);
                    candis.add(info);
                }
                mMap.put(m.materialId, info);
                if (!(slotExposure > 199.0) && !(slotClick > 60.0)) continue;
                double matchScore3 = this.getCtr(slotExposure, slotClick);
                MatchInfo info3 = new MatchInfo();
                this.fillMatchInfo(info3, m);
                info3.setnCtr(((NormInfo)materialSet.get((Object)Long.valueOf((long)m.materialId))).nCtr);
                info3.setMatchScore(matchScore3);
                if (info3.type != 1) continue;
                slotCandis.add(info3);
            }
            catch (Exception e) {
                logger.error("error,materialId: m.materialId= " + m.materialId);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        int n = slotCandis.size();
        for (int i = 0; i < 10 && i < n; ++i) {
            MatchInfo infoSlot = (MatchInfo)slotCandis.poll();
            if (idset.contains(infoSlot.materialId)) continue;
            result.add(infoSlot);
            idset.add(infoSlot.materialId);
            --topn;
            if (result.size() >= limitTopn) break;
        }
        int candiSize = candis.size();
        for (Map.Entry entry : normMap.entrySet()) {
            AppSlot appSlot = (AppSlot)entry.getKey();
            Set set1 = (Set)entry.getValue();
            for (NormInfo nf : materials) {
                if (set1.contains(nf.materialId)) continue;
                MatchInfo mci = new MatchInfo();
                mci.setAppId(appSlot.appId);
                mci.setSlotId(appSlot.slotId);
                mci.setMaterialId(nf.materialId);
                mci.setnCtr(nf.nCtr);
                mci.setType(1);
                normCandis.add(mci);
            }
        }
        for (int i = 0; i < 10 && i < normCandis.size(); ++i) {
            MatchInfo matchInfo = (MatchInfo)normCandis.poll();
            matchInfo.setNorm(true);
            if (idset.contains(matchInfo.materialId)) continue;
            result.add(matchInfo);
            idset.add(matchInfo.materialId);
            --topn;
            if (result.size() >= limitTopn) break;
        }
        int resultSize = result.size();
        boolean bl = false;
        while (resultSize < limitTopn && var20_30 < candiSize) {
            MatchInfo candisInfo = (MatchInfo)candis.poll();
            if (!idset.contains(candisInfo.materialId)) {
                result.add(candisInfo);
                resultSize = result.size();
                idset.add(candisInfo.materialId);
                --topn;
                if (result.size() >= limitTopn) break;
            }
            ++var20_30;
        }
        return result;
    }

    public List<MatchInfo> matchAPI(List<SlotMaterialInfo> materialList) {
        double prob = 1.0E-4;
        int exposureThreshold = 200;
        if (materialList.size() == 0) {
            return null;
        }
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        ArrayList<MatchInfo> result = new ArrayList<MatchInfo>();
        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet<Long>();
        int limitTopn = topn;
        HashMap<Long, MatchInfo> mMap = new HashMap<Long, MatchInfo>();
        HashMap<Long, SlotCtr> sMap = new HashMap<Long, SlotCtr>();
        for (SlotMaterialInfo m : materialList) {
            if (m.type != 2) continue;
            long slot_id = m.slotId;
            SlotCtr sctr = sMap.getOrDefault(slot_id, new SlotCtr());
            double slotExposure = m.getExposureCnt().getSlotVal();
            double slotClick = m.getClickCnt().getSlotVal();
            sctr.click += slotClick;
            sctr.exposure += slotExposure;
            sMap.put(slot_id, sctr);
        }
        for (SlotMaterialInfo m : materialList) {
            try {
                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();
                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();
                double biasCtr = SlotMaterialSelect.getRate(((SlotCtr)sMap.get((Object)Long.valueOf((long)m.slotId))).exposure, ((SlotCtr)sMap.get((Object)Long.valueOf((long)m.slotId))).click);
                MatchInfo info = mMap.containsKey(m.materialId) ? (MatchInfo)mMap.get(m.materialId) : new MatchInfo();
                this.fillMatchInfo(info, m);
                if (globalExposure < (double)exposureThreshold) {
                    if (System.currentTimeMillis() - m.getCreateTime() < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(info);
                            --topn;
                            idset.add(info.materialId);
                        }
                    } else if (materialList.size() > limitTopn && Math.random() < 0.1 * prob) {
                        result.add(info);
                        --topn;
                        idset.add(info.materialId);
                    }
                }
                double slotScore = this.getWilsonCtr(slotExposure, slotClick);
                double matchscore = 0.0;
                if (info.type == 2) {
                    double globalScore = this.getWilsonCtr(globalExposure, globalClick);
                    double appScore = this.getWilsonCtr(appExposure, appClick);
                    double sconfidence = Math.min(slotExposure / 200.0, 1.0);
                    double aconfidence = Math.min(appExposure / 200.0, 1.0);
                    double gconfidence = Math.min(globalExposure / 2000.0, 1.0);
                    matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    info.setMatchScore(matchscore);
                    candis.add(info);
                }
                if (slotExposure > 199.0 || slotClick > 60.0) {
                    double matchScore3 = this.getCtr(slotExposure, slotClick);
                    MatchInfo info3 = new MatchInfo();
                    this.fillMatchInfo(info3, m);
                    info3.setMatchScore(matchScore3);
                    if (info3.type == 2) {
                        slotCandis.add(info3);
                    }
                }
                mMap.put(m.materialId, info);
            }
            catch (Exception e) {
                logger.error("error,materialId: m.materialId= " + m.materialId);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        int slotCandiSize = slotCandis.size();
        for (int i = 0; i < 10 && i < slotCandiSize; ++i) {
            MatchInfo infoSlot = (MatchInfo)slotCandis.poll();
            if (idset.contains(infoSlot.materialId)) continue;
            result.add(infoSlot);
            idset.add(infoSlot.materialId);
            --topn;
            if (result.size() >= limitTopn) break;
        }
        int resultSize = result.size();
        for (int i = 0; resultSize < limitTopn && i < candis.size(); ++i) {
            MatchInfo candisInfo = (MatchInfo)candis.poll();
            if (idset.contains(candisInfo.materialId)) continue;
            result.add(candisInfo);
            resultSize = result.size();
            idset.add(candisInfo.materialId);
            --topn;
            if (result.size() >= limitTopn) break;
        }
        return result;
    }

    public SlotMaterialModel selectSDK(List<MatchInfo> matchInfos, List<SlotMaterialModel> materialModels) {
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }
        if (matchInfos.size() != materialModels.size()) {
            return null;
        }
        List<MatchInfo> matchInfoList = SlotMaterialSelect.sortByIdWithMatchInfo(matchInfos);
        List<SlotMaterialModel> materialModelList = SlotMaterialSelect.sortByIdWithMaterials(materialModels);
        ArrayList<MatchInfo> normInfos = new ArrayList<MatchInfo>();
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long intoMaterialId = matchInfoList.get(i).getMaterialId();
            long modelMaterailId = materialModelList.get(i).getMaterialId();
            if (matchInfoList.get((int)i).isNorm) {
                normInfos.add(matchInfoList.get(i));
            }
            if (intoMaterialId != modelMaterailId) {
                return null;
            }
            materialModelList.get((int)i).matchScore = matchInfoList.get((int)i).matchScore;
        }
        double decay = Constant.DECAY;
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> matchscores = new ArrayList<Double>();
        ArrayList<Long> materials = new ArrayList<Long>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Double> arpus = new ArrayList<Double>();
        List<SlotMaterialModel> modeCopyList = materialModelList;
        SlotMaterialModel result = new SlotMaterialModel();
        ArrayList candiList = new ArrayList();
        ArrayList<SlotMaterialModel> candis = new ArrayList<SlotMaterialModel>();
        try {
            for (int i = 0; i < matchInfoList.size(); ++i) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);
                if (!(info.exposureCnt.globalVal > 0.0)) continue;
                double spc = Math.min(info.cost.slotVal / 200.0, 1.0);
                double apc = Math.min(info.cost.appVal / 200.0, 1.0);
                double gpc = Math.min(info.cost.globalVal / 1000.0, 1.0);
                double spr = SlotMaterialSelect.getRate(info.exposureCnt.slotVal, info.cost.slotVal);
                double apr = SlotMaterialSelect.getRate(info.exposureCnt.appVal, info.cost.appVal);
                double gpr = SlotMaterialSelect.getRate(info.exposureCnt.globalVal, info.cost.globalVal);
                double arpu = spc * spr + (1.0 - spc) * apc * apr + (1.0 - spc - (1.0 - spc) * apc) * gpc * gpr;
                double reward = 0.04;
                double sConfidence = Math.min(info.exposureCnt.slotVal / 200.0, 1.0);
                double aConfidence = Math.min(info.exposureCnt.appVal / 200.0, 1.0);
                double gConfidence = Math.min(info.exposureCnt.globalVal / 2000.0, 1.0);
                double globalCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.globalVal, info.clickCnt.globalVal) * 0.8, reward, 0.8);
                double slotCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.slotVal, info.clickCnt.slotVal) * 0.7, reward, 0.7);
                double appCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.appVal, info.clickCnt.appVal) * 0.5, reward, 0.6);
                reward = sConfidence * slotCtr + (1.0 - sConfidence) * aConfidence * appCtr + (1.0 - sConfidence - (1.0 - sConfidence) * aConfidence) * gConfidence * globalCtr;
                reward *= reward;
                reward = Math.max(reward, 0.0);
                modeCopyList.get((int)i).reward = modeCopyList.get((int)i).reward * decay + reward;
                modeCopyList.get((int)i).count = modeCopyList.get((int)i).count * decay + 1.0;
                modeCopyList.get((int)i).alpha = 0.25 + modeCopyList.get((int)i).reward;
                modeCopyList.get((int)i).beta = 0.91 + (modeCopyList.get((int)i).count - modeCopyList.get((int)i).reward);
                counts.add(modeCopyList.get((int)i).count);
                alphas.add(modeCopyList.get((int)i).alpha);
                betas.add(modeCopyList.get((int)i).beta);
                matchscores.add(modeCopyList.get((int)i).matchScore);
                materials.add(modeCopyList.get((int)i).materialId);
                types.add(modeCopyList.get((int)i).type);
                arpus.add(arpu);
                candis.add(modeCopyList.get(i));
            }
            int numMachines = alphas.size();
            if (numMachines > 0) {
                int bestSelect = this.selectMachine(alphas, betas, matchscores, arpus, materials, types, numMachines);
                result = (SlotMaterialModel)candis.get(bestSelect);
            } else {
                result.materialId = matchInfos.get((int)0).materialId;
                result.appId = matchInfos.get((int)0).appId;
                result.slotId = matchInfos.get((int)0).slotId;
                result.matchScore = matchInfos.get((int)0).matchScore;
            }
            if (Math.random() < 0.1 && normInfos.size() > 0) {
                MatchInfo norminfo = (MatchInfo)normInfos.stream().sorted(Comparator.comparing(MatchInfo::getnCtr).reversed()).collect(Collectors.toList()).get(0);
                SlotMaterialModel smi = new SlotMaterialModel();
                smi.setMaterialId(norminfo.materialId);
                smi.setSlotId(norminfo.slotId);
                smi.setAppId(norminfo.appId);
                smi.setType(norminfo.type);
                smi.setnCtr(norminfo.nCtr);
                smi.setnPartRate(norminfo.nPartRate);
                return smi;
            }
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    public SlotMaterialModel selectAPI(List<MatchInfo> matchInfos, List<SlotMaterialModel> materialModels) {
        HashMap map = new HashMap();
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }
        if (matchInfos.size() != materialModels.size()) {
            return null;
        }
        List<MatchInfo> matchInfoList = SlotMaterialSelect.sortByIdWithMatchInfo(matchInfos);
        List<SlotMaterialModel> materialModelList = SlotMaterialSelect.sortByIdWithMaterials(materialModels);
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long modelMaterailId;
            long intoMaterialId = matchInfoList.get(i).getMaterialId();
            if (intoMaterialId != (modelMaterailId = materialModelList.get(i).getMaterialId())) {
                return null;
            }
            materialModelList.get((int)i).matchScore = matchInfoList.get((int)i).matchScore;
        }
        double decay = Constant.DECAY;
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> matchscores = new ArrayList<Double>();
        ArrayList<Long> materials = new ArrayList<Long>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Double> arpus = new ArrayList<Double>();
        List<SlotMaterialModel> modeCopyList = materialModelList;
        SlotMaterialModel result = new SlotMaterialModel();
        ArrayList candiList = new ArrayList();
        ArrayList<SlotMaterialModel> candis = new ArrayList<SlotMaterialModel>();
        try {
            for (int i = 0; i < matchInfoList.size(); ++i) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);
                if (!(info.exposureCnt.globalVal > 0.0)) continue;
                double spc = Math.min(info.cost.slotVal / 200.0, 1.0);
                double apc = Math.min(info.cost.appVal / 200.0, 1.0);
                double gpc = Math.min(info.cost.globalVal / 1000.0, 1.0);
                double spr = info.cost.slotVal / (100.0 * info.exposureCnt.slotVal);
                double apr = info.cost.appVal / (100.0 * info.exposureCnt.appVal);
                double gpr = info.cost.globalVal / (100.0 * info.exposureCnt.globalVal);
                double arpu = spc * spr + (1.0 - spc) * apc * apr + (1.0 - spc - (1.0 - spc) * apc) * gpc * gpr;
                double reward = 0.04;
                double sConfidence = Math.min(info.exposureCnt.slotVal / 200.0, 1.0);
                double aConfidence = Math.min(info.exposureCnt.appVal / 200.0, 1.0);
                double gConfidence = Math.min(info.exposureCnt.globalVal / 2000.0, 1.0);
                double globalCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.globalVal, info.clickCnt.globalVal) * 0.8, reward, 0.8);
                double slotCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.slotVal, info.clickCnt.slotVal) * 0.7, reward, 0.7);
                double appCtr = SlotMaterialSelect.normlize(this.getCtr(info.exposureCnt.appVal, info.clickCnt.appVal) * 0.5, reward, 0.6);
                reward = sConfidence * slotCtr + (1.0 - sConfidence) * aConfidence * appCtr + (1.0 - sConfidence - (1.0 - sConfidence) * aConfidence) * gConfidence * globalCtr;
                reward *= reward;
                reward = Math.max(reward, 0.0);
                modeCopyList.get((int)i).reward = modeCopyList.get((int)i).reward * decay + reward;
                modeCopyList.get((int)i).count = modeCopyList.get((int)i).count * decay + 1.0;
                modeCopyList.get((int)i).alpha = 0.25 + modeCopyList.get((int)i).reward;
                modeCopyList.get((int)i).beta = 0.91 + (modeCopyList.get((int)i).count - modeCopyList.get((int)i).reward);
                counts.add(modeCopyList.get((int)i).count);
                alphas.add(modeCopyList.get((int)i).alpha);
                betas.add(modeCopyList.get((int)i).beta);
                matchscores.add(modeCopyList.get((int)i).matchScore);
                materials.add(modeCopyList.get((int)i).materialId);
                types.add(modeCopyList.get((int)i).type);
                candis.add(modeCopyList.get(i));
                arpus.add(arpu);
            }
            int numMachines = alphas.size();
            if (numMachines > 0) {
                int bestSelect = this.selectMachine(alphas, betas, matchscores, arpus, materials, types, numMachines);
                result = (SlotMaterialModel)candis.get(bestSelect);
                return result;
            }
            result.materialId = matchInfos.get((int)0).materialId;
            result.appId = matchInfoList.get((int)0).appId;
            result.slotId = matchInfoList.get((int)0).slotId;
            result.matchScore = matchInfoList.get((int)0).matchScore;
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    private int selectMachine(List<Double> alphas, List<Double> betas, List<Double> matchScore, List<Double> arpus, List<Long> materials, List<Integer> types, int numMachines) {
        ArrayList<SelectInfo> selectInfos = new ArrayList<SelectInfo>();
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo selectInfo = new SelectInfo();
            selectInfo.materialId = materials.get(i);
            selectInfo.index = i;
            selectInfo.matchscore = matchScore.get(i);
            selectInfo.arpu = arpus.get(i);
            selectInfo.reward = theta;
            selectInfo.type = types.get(i);
            selectInfos.add(selectInfo);
        }
        SelectInfo info = (SelectInfo)selectInfos.stream().sorted(Comparator.comparing(SelectInfo::getArpu).reversed()).limit(numMachines / 4 + 1).sorted(Comparator.comparing(SelectInfo::getReward).reversed()).limit(numMachines / 8 + 1).sorted(Comparator.comparing(SelectInfo::getMatchscore).reversed()).collect(Collectors.toList()).get(0);
        return info.index;
    }

    private int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private void fillMatchInfo(MatchInfo info, SlotMaterialInfo m) {
        info.setMaterialId(m.materialId);
        info.setMaterialTag(m.materialTag);
        info.setType(m.type);
        info.setAppId(m.appId);
        info.setSlotId(m.slotId);
        info.exposureCnt = new Val();
        info.exposureCnt.globalVal = m.getExposureCnt().globalVal;
        info.exposureCnt.slotVal = m.getExposureCnt().slotVal;
        info.exposureCnt.appVal = m.getExposureCnt().appVal;
        info.clickCnt = new Val();
        info.clickCnt.globalVal = m.getClickCnt().globalVal;
        info.clickCnt.slotVal = m.getClickCnt().slotVal;
        info.clickCnt.appVal = m.getClickCnt().appVal;
        info.setDiffTime(System.currentTimeMillis() - m.createTime);
        info.cost = new Val();
        info.cost.globalVal = m.getCost().globalVal;
        info.cost.slotVal = m.getCost().slotVal;
        info.cost.appVal = m.getCost().appVal;
    }

    private static List<MatchInfo> sortByIdWithMatchInfo(List<MatchInfo> infos) {
        List<MatchInfo> info = infos;
        Collections.sort(info, new Comparator<MatchInfo>(){

            @Override
            public int compare(MatchInfo info1, MatchInfo info2) {
                if (info1.materialId > info2.materialId) {
                    return -1;
                }
                return 1;
            }
        });
        return info;
    }

    private static List<SlotMaterialModel> sortByIdWithMaterials(List<SlotMaterialModel> materials) {
        List<SlotMaterialModel> material = materials;
        Collections.sort(material, new Comparator<SlotMaterialModel>(){

            @Override
            public int compare(SlotMaterialModel material1, SlotMaterialModel material2) {
                if (material1.materialId > material2.materialId) {
                    return -1;
                }
                return 1;
            }
        });
        return material;
    }

    static class Constant {
        static double MIN_REWARD = 0.3;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

