package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.OrientExpInfo;

import java.util.ArrayList;

class PIDController {
    //抄知乎上的pid控制出价的策略https://zhuanlan.zhihu.com/p/265215568

    double calcControlFactor(OrientExpInfo orientExpInfo,
                             Double upperBound, Double lowerBound,
                             Double kp, Double ki) {
        ArrayList<Long> realConsumeList=orientExpInfo.getRealConsume();
        ArrayList<Long> targetConsumeList=orientExpInfo.getTargetConsume();
        double errorCurrent=errorDiff(realConsumeList.get(realConsumeList.size()-1),targetConsumeList.get(targetConsumeList.size()-1));
        double errorIntegral=errorIntegral(realConsumeList,targetConsumeList);
        double kt=kp*errorCurrent+ki*errorIntegral;
        double unboundK=responseFunc(kt);
        double k=bound(unboundK,upperBound,lowerBound);
        return k;
    }

    //差分形式算偏差
    private double errorDiff(Long realConsume, Long targetConsume) {
        return new Double(targetConsume-realConsume);
    }

    //累计偏差
    private double errorIntegral(ArrayList<Long> realConsumeList, ArrayList<Long> targetConsumeList) {
        Long realConsumeSum=realConsumeList.stream().reduce(0L,Long::sum);
        Long targetConsumeSum=targetConsumeList.stream().reduce(0L,Long::sum);
        return new Double(targetConsumeSum-realConsumeSum);
    }

    //响应函数
    private double responseFunc(double kt) {
        return Math.exp(kt);
    }

    private double bound(Double value,Double upperBound,Double lowerBound) {
        if(value>upperBound) {
            return upperBound;
        }
        else if (value<lowerBound) {
            return lowerBound;
        }
        else {
            return value;
        }
    }
}
