package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: lijingzhe
 * @date: 2020/3/31
 * @methodParameters:
 * @methodReturnType:
 * @description: 活动推荐4.8: 热点活动扶持
 */
public class ActivityRec48 {
    private static final Logger logger= LoggerFactory.getLogger(ActivityRec48.class);

    static class Constant {
        static double MIN_REWARD=0.1;
        static double DECAY=0.99;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;
    }

    /**
     * @author: lijingzhe
     * @date: 2020/3/31
     * @methodParameters: [actData, actAds, exActs]
     * @methodReturnType: java.util.List<cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo>
     * @description: 4.8海选
     */
    public static List<ActivityMatchInfo> match (List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        return ActivityRec42.match(actData, actAds, exActs);
    }

    /**
     * @author: lijingzhe
     * @date: 2020/3/31
     * @methodParameters: [actModel, actData]
     * @methodReturnType: cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult
     * @description: 4.8优选
     */
    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {

        RankResult rankResult=new RankResult();

        //判断列表长度，不一致抛异常
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }

        if (actModel.size() != actData.size()) {
            rankResult.activityModel=actModel.get(0);
            rankResult.similarCostActivitiesInfo=null;
            return rankResult; //todo 抛异常
        }
        //活动id倒排
        List<ActivityRankInfo> actModelCopy =
                actModel.stream()
                        .sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed())
                        .collect(Collectors.toList());
        List<ActivityMatchInfo> actDataCopy =
                actData.stream()
                        .sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed())
                        .collect(Collectors.toList());

        //活动 id 对不上返回空
        for (int i=0; i < actModelCopy.size(); ++i) {
            long activityIdMode=actModelCopy.get(i).activityId;
            long activityIdData=actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                rankResult.activityModel=actModel.get(0);
                rankResult.similarCostActivitiesInfo=null;
                return rankResult; // todo 抛异常
            }
        }

        // 活动访问pv
        ArrayList<Double> requests=new ArrayList<>();
        // 每pv消耗收益
        ArrayList<Double> rewards=new ArrayList<>();
        ArrayList<Double> counts=new ArrayList<>();
        // 贝塔分布alpha和beta
        ArrayList<Double> alphas=new ArrayList<>();
        ArrayList<Double> betas=new ArrayList<>();
        // 转化分
        ArrayList<Double> changeScores=new ArrayList<>();
        // 广告位置信cvr
        ArrayList<Double> cvrBiass = new ArrayList<>();
        ArrayList<Long> activityIds=new ArrayList<>();
        ArrayList<Long> activityTypes=new ArrayList<>();
        // 每pv消耗
        ArrayList<Double> grpms=new ArrayList<>();
        ArrayList<Double> arpms=new ArrayList<>();
        ArrayList<Double> hrpms=new ArrayList<>();
        // 是否是优质活动
        ArrayList<Boolean> excellents=new ArrayList<>();
        ArrayList<Integer> subTypes=new ArrayList<>();
        // 是否是热点活动
        ArrayList<Boolean> supports=new ArrayList<>();
        // 归一化score
        ArrayList<Double> scores=new ArrayList<>();
        List<ActivityRankInfo> candiList=new ArrayList<>();

        double decay= Constant.DECAY;

        int size=0;

        Map<Long, RankInfo> mMap=new HashMap();
        double maxG= Constant.MIN_REWARD, maxH= Constant.MIN_REWARD, maxA= Constant.MIN_REWARD;
        double minG=0, minH= Constant.MIN_REWARD, minA= Constant.MIN_REWARD;
        ActivityRankInfo result=new ActivityRankInfo();

        try {
            for (int i=0;i<actDataCopy.size();++i) {
                RankInfo info=mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                // 全局每pv消耗
                double grpm=actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / (100 * actDataCopy.get(i).hisRequest.globalVal) : 0;
                info.grpm=grpm;
                info.gexp=actDataCopy.get(i).hisRequest.globalVal;
                maxG=Math.max(grpm, maxG);

                // 媒体每pv消耗
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ?
                        actDataCopy.get(i).hisCost.appVal /(100 * actDataCopy.get(i).hisRequest.appVal ) : 0;
                info.arpm=arpm;
                info.aexp=actDataCopy.get(i).hisRequest.appVal;
                if (info.aexp > 100) {
                    maxA=Math.max(arpm, maxA);
                }
                minA=Math.min(arpm, minA);

                // 广告位每pv消耗
                double hrpm=actDataCopy.get(i).hisRequest.slotVal > 0 ? actDataCopy.get(i).hisCost.slotVal /(100 * actDataCopy.get(i).hisRequest.slotVal) : 0;
                info.hrpm=hrpm;
                info.hexp=actDataCopy.get(i).hisRequest.slotVal;
                if(info.hexp > 100) {
                    maxH=Math.max(hrpm, maxH);
                }
                minH=Math.min(hrpm, minH);

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i=0;i<actDataCopy.size();++i) {
                requests.add(actDataCopy.get(i).hisRequest.slotVal);
                double hrpm=mMap.get(actDataCopy.get(i).activityId).hrpm;
                double arpm=mMap.get(actDataCopy.get(i).activityId).arpm;
                double grpm=mMap.get(actDataCopy.get(i).activityId).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(actDataCopy.get(i).isExcellent);
                supports.add(actDataCopy.get(i).isSupport);
                subTypes.add(actDataCopy.get(i).subType);
                scores.add(actDataCopy.get(i).score);
                cvrBiass.add(actDataCopy.get(i).cvrBias);

                double reward= Constant.MIN_REWARD;
                double sconfidence=Math.min(actDataCopy.get(i).hisRequest.slotVal / 100, 1);
                double aconfidence=Math.min(actDataCopy.get(i).hisRequest.appVal / 100, 1);

                reward=sconfidence * normlize( hrpm * 0.8, maxH, 0.8) +
                        (1 - sconfidence) * aconfidence * normlize(arpm * 0.7, maxA, 0.7) +
                        (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(grpm * 0.5, maxG, 0.6);

                reward=reward * reward;

                reward=Math.max(reward, 0);

                actModelCopy.get(i).reward=actModelCopy.get(i).reward * decay+reward;
                actModelCopy.get(i).count=actModelCopy.get(i).count * decay+1.0;
                actModelCopy.get(i).alpha=1.5+actModelCopy.get(i).reward;
                actModelCopy.get(i).beta=2.0+(actModelCopy.get(i).count - actModelCopy.get(i).reward);

                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityIds.add(actModelCopy.get(i).activityId);
                activityTypes.add(actDataCopy.get(i).activityType);
                changeScores.add(actDataCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            int numMachines=candiList.size();
            SelectInfoDetail selectInfoDetail =
                    selectMachineWithChangeScore(alphas, betas, activityTypes
                            , activityIds,changeScores,numMachines, hrpms,
                            arpms, grpms, requests, excellents, supports, subTypes, scores,cvrBiass);

            int selectedActivityIndex=selectInfoDetail.index;
            result=candiList.get(selectedActivityIndex);
            result.strategyType=selectInfoDetail.strategyType;
            double maxChangeScore=selectInfoDetail.maxChangeScore;

            List<SimilarCostActivitiesInfo> sameCostActivitiesInfoList=new ArrayList<>();
            //消耗分相近的活动信息
            ArrayList<SelectPoolInfo> sameCostcondi=selectInfoDetail.condi;
            if(sameCostcondi.size() > 0){
                double selectedActivityReward=sameCostcondi.get(0).getReward();
                int sameCostActivityCnt=sameCostcondi.size();

                for (SelectPoolInfo selectInfo:sameCostcondi){

                    SimilarCostActivitiesInfo sameCostActivitiesInfo=new SimilarCostActivitiesInfo();

                    Long activityId=selectInfo.getActivityId();
                    Long activityType=selectInfo.getActivityType();

                    int ifSelected=0;
                    if (selectInfo.getIndex() == selectedActivityIndex){
                        ifSelected=1;
                    }

                    int index=selectInfo.getIndex();

                    double mabReward=selectInfo.getReward();
                    double changeScore=selectInfo.getChangeScore();
                    double hrpm=selectInfo.getHrpm();
                    double arpm=selectInfo.getArpm();
                    double grpm=selectInfo.getGrpm();
                    int subType=selectInfo.getSubType();
                    boolean excellent=selectInfo.isExcellent();

                    //计算与最优的差异
                    double diffReward= selectInfo.getReward()-selectedActivityReward;
                    double diffChangeScore=selectInfo.getChangeScore() - maxChangeScore;

                    //封装
                    sameCostActivitiesInfo.activityId=activityId;
                    sameCostActivitiesInfo.sameActivityCnt=sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType=activityType;
                    sameCostActivitiesInfo.ifSelected=ifSelected;
                    sameCostActivitiesInfo.mabReward=mabReward;
                    sameCostActivitiesInfo.changeScore=changeScore;
                    sameCostActivitiesInfo.index=index;
                    sameCostActivitiesInfo.hrpm=hrpm;
                    sameCostActivitiesInfo.arpm=arpm;
                    sameCostActivitiesInfo.grpm=grpm;
                    sameCostActivitiesInfo.diffReward=diffReward;
                    sameCostActivitiesInfo.diffChangeScore=diffChangeScore;
                    sameCostActivitiesInfo.subType=subType;
                    sameCostActivitiesInfo.isExcellent=excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }

            rankResult.activityModel=result;
            rankResult.similarCostActivitiesInfo=sameCostActivitiesInfoList;

            mMap.clear();

            return rankResult;
        }catch (Exception e)
        {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }


    /**
     *功能描述 融合表单类和非表单类cvr
     *
     * @author lijingzhe
     * @date 2019/9/9
     * @param ad
     * @return cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityCvrInfo
     */
    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad,double cvr) {
        double changeScoreBias = 0.05; //统计腰部+尾部流量(pv>100)的均值cvr
        double changeScoreMerge=0.0;

        double changeScoreForms = 0.0;  //该活动下
        double changeScoreNotForms = 0.0;

        // 该活动表单类置信cvr
        if(ad.sumClickForms > ad.sumEffectPVForms){
            changeScoreForms = WilsonInterval.wilsonCalc(ad.sumEffectPVForms, ad.sumClickForms).lowerBound;
        }else{
            changeScoreForms = WilsonInterval.wilsonCalc(ad.sumClickForms, ad.sumClickForms).lowerBound;
        }

        // 该活动非表单类置信cvr
        if(ad.sumClickNotForms > ad.sumEffectPVNotForms){
            changeScoreNotForms = WilsonInterval.wilsonCalc(ad.sumEffectPVNotForms, ad.sumClickNotForms).lowerBound;
        }else{
            changeScoreNotForms = WilsonInterval.wilsonCalc(ad.sumClickNotForms, ad.sumClickNotForms).lowerBound;
        }

        double wcvr = cvr > 0 ? changeScoreBias/cvr :1;
        changeScoreMerge = changeScoreForms + changeScoreNotForms * 0.2 * Math.min(2.5, wcvr);

        //输出 转化得分明细
        ActivityCvrInfo  activityChangeVal= new ActivityCvrInfo() ;

        activityChangeVal.sumClickForms=ad.sumClickForms;
        activityChangeVal.sumEffectPVForms=ad.sumEffectPVForms;

        activityChangeVal.sumClickNotForms=ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms=ad.sumEffectPVNotForms;

        activityChangeVal.changeScoreForms= changeScoreForms;
        activityChangeVal.changeScoreNotForms= changeScoreNotForms;

        activityChangeVal.changeScoreMerge=changeScoreMerge;
        //结果输出
        return activityChangeVal ;

    }

    public static double normlize(double val, double max, double limit) {
        double norm=Math.min(val * limit / max, limit);
        return norm;
    }

    /**
     *功能描述 去除卡包分，直接发券活动暂时不处理
     * @author lijingzhe
     * @date 2019/8/22
     * @param alphas, betas, subTypes, activityIds, changeScores, numMachines, gama
     * @return cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRec40.SelectInfoDetail
     */
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Boolean> supports, List<Integer> subTypes, List<Double> scores, List<Double> cvrBiass) {
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        List<SelectPoolInfo> sinfos=new ArrayList();
        double visitPvs = requests.stream().reduce((x,y)->x+y).get();
        for (int i=0; i < numMachines; i++) {
            if(activityTypes.get(i) != 21){
                double theta=BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
                SelectPoolInfo sinfo=new SelectPoolInfo();
                sinfo.setReward(theta);
                sinfo.setActivityType(activityTypes.get(i));
                sinfo.setIndex(i);
                sinfo.setActivityId(activityIds.get(i));
                sinfo.setChangeScore(changeScores.get(i));
                sinfo.setHrpm(hrpms.get(i));
                sinfo.setArpm(arpms.get(i));
                sinfo.setGrpm(grpms.get(i));
                sinfo.setRequest(requests.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setScores(scores.get(i));
                sinfo.setExcellent(excellents.get(i));
                sinfo.setSubType(subTypes.get(i));
                sinfo.setCvrBias(cvrBiass.get(i));
                sinfo.setSupport(supports.get(i));
                sinfos.add(sinfo);
            }
        }

        if(sinfos.size() > 0){
            // 非卡包活动转化分最高活动
            List<SelectPoolInfo> chs = sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed())
                    .collect(Collectors.toList());
            double maxChangeScore = chs.get(0).getChangeScore();
//            double midChangeScore = chs.get(Math.min(chs.size()/2+1, 10)).getChangeScore();

            List<SelectPoolInfo> ranks = sinfos.stream()
                    .sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed())
                    .collect(Collectors.toList());
            selectInfoDetail.condi = new ArrayList<>(ranks.subList(0, Math.min(ranks.size(),5)));
            selectInfoDetail.maxChangeScore = maxChangeScore;

            for (int i = 0; i < ranks.size(); i++) {
                selectInfoDetail.index = ranks.get(i).getIndex();

                // 热点活动扶持，广告位每天最多推一个最新的热点活动
                if(ranks.get(i).isSupport){
                    if(ranks.get(i).getRequest() < 5000 || ranks.get(i).getRequest() < 0.2 * visitPvs){
                        selectInfoDetail.strategyType = 6;
                        break;
                    }
                }

                // 投放次数>=100 && 投放次数<=500的活动，优质活动兜底
                if(ranks.get(i).getRequest() < 100){
                    if(ranks.get(i).isExcellent() && Math.random() < 0.02){
                        selectInfoDetail.strategyType = 1;
                        break;
                    }
                    // 转化差的活动低概率投放
                    if(ranks.get(i).getChangeScore() < 0.8 * ranks.get(i).getCvrBias() && Math.random() < 0.001){
                        selectInfoDetail.strategyType = -1;
                        break;
                    }
                }else if(ranks.get(i).getRequest() >= 100 && ranks.get(i).getRequest() <= 500){
                    // 排名top 2-5 每个活动以1%概率随机投放
                    if(ranks.get(i).isExcellent() && i > 0 && i < 5 && Math.random() < 0.01){
                        selectInfoDetail.strategyType = 2;
                        break;
                        // 排名top 5-20 每个活动以0.1%概率投放
                    }else if(ranks.get(i).isExcellent() && i < 20 && Math.random() < 0.001) {
                        selectInfoDetail.strategyType = 3;
                        break;
                    }

                    if(ranks.get(i).getChangeScore() <0.8 * ranks.get(i).getCvrBias() && Math.random() < 0.0002){
                        selectInfoDetail.strategyType = -2;
                        break;
                    }
                }else {
                    //转化分相近的每个活动信息
                    if (ranks.get(i).getChangeScore() >= 0.8 * ranks.get(i).getCvrBias()) {
                        selectInfoDetail.strategyType = 4;
                        break;
                    }
                }
            }

            if(selectInfoDetail==null || selectInfoDetail.strategyType == 0){
                selectInfoDetail.index = ranks.get(0).getIndex();
                selectInfoDetail.maxChangeScore = changeScores.get(0);
                selectInfoDetail.strategyType = 5;
            }
        }else{
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = changeScores.get(0);
            selectInfoDetail.condi = new ArrayList<>();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }

    /**
     *功能描述 封装海选数据
     * @author lijingzhe
     * @date 2019/8/23
     * @param act, actIds, exHashMap
     * @return cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo
     */
    private static ActivityMatchInfo fillData(ActivityInfoData act, Set<Long> actIds, Map<Long, NormInfo> exHashMap){
        ActivityMatchInfo actM=new ActivityMatchInfo();
        actM.activityId=act.activityId;
        actM.slotId=act.slotId;
        actM.appId=act.appId;
        actM.ucRate=act.ucRate;

        actM.hisClick=new ActivityVal();
        actM.hisClick.globalVal=act.click.globalVal;
        actM.hisClick.appVal=act.click.appVal;
        actM.hisClick.slotVal=act.click.slotVal;

        actM.hisCost=new ActivityVal();
        actM.hisCost.globalVal=act.cost.globalVal;
        actM.hisCost.appVal=act.cost.appVal;
        actM.hisCost.slotVal=act.cost.slotVal;

        actM.hisRequest=new ActivityVal();
        actM.hisRequest.globalVal=act.request.globalVal;
        actM.hisRequest.appVal=act.request.appVal;
        actM.hisRequest.slotVal=act.request.slotVal;

        actM.subType=act.subType;
        actM.isExcellent=actIds.contains(act.activityId);
        actM.nPvClick=exHashMap.getOrDefault(act.activityId,new NormInfo()).getnPvClick();
        actM.nPvCost=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvCost();
        actM.nCvrForm=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnFormCvr();
        actM.nCvrNotForm=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnNotFormCvr();
        actM.nCvr=exHashMap.getOrDefault(act.activityId, new NormInfo()).getnCvr();
        actM.score=exHashMap.getOrDefault(act.activityId, new NormInfo()).getScore();

        return actM;
    }
}
