/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtil {
    public static double[] reciprocalOfNCache = new double[]{1.0, 1.0, 0.5, 0.3333, 0.25, 0.2, 0.1667, 0.1429, 0.125, 0.1111, 0.1, 0.0909, 0.0833, 0.0769, 0.0714, 0.0667, 0.0625, 0.0588, 0.0556, 0.0526, 0.05, 0.0476, 0.0455, 0.0435, 0.0417, 0.04, 0.0385, 0.037, 0.0357, 0.0345, 0.0333, 0.0323, 0.0313, 0.0303, 0.0294, 0.0286, 0.0278, 0.027, 0.0263, 0.0256, 0.025};

    public static double reciprocalOfN(Integer n) {
        double ret = 1.0;
        if (n != null && n <= 40) {
            ret = reciprocalOfNCache[n];
        } else if (n != null) {
            ret = MathUtil.division(1.0, n, 4);
        }
        return ret;
    }

    public static double sigmoid(double value) {
        return 1.0 / (1.0 + Math.exp(-1.0 * value));
    }

    public static double stdwithBoundary(double value, double lowB, double upB) {
        return value < lowB ? lowB : (value > upB ? upB : value);
    }

    public static Double max(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return Math.max(d1, d2);
    }

    public static Long dot(Long v1, Double v2) {
        Long ret = 0L;
        if (v1 != null && v2 != null) {
            Double tmp = (double)v1.longValue() * v2;
            ret = MathUtil.double2long(tmp);
        }
        return ret;
    }

    public static Double dot(Double v1, Double v2, int newScala) {
        Double ret = 0.0;
        if (v1 != null && v2 != null) {
            Double tmp = v1 * v2;
            ret = MathUtil.formatDouble(tmp, newScala);
        }
        return ret;
    }

    public static Double dotPow(Double price, Double Ctr, Double ctrFactor, Double Lower, Double Upper, int newScala) {
        double ret = 0.0;
        if (ctrFactor == null) {
            ctrFactor = 1.0;
        }
        if (price != null && Ctr != null) {
            double tmp = price * Math.pow(Ctr, ctrFactor);
            ret = MathUtil.formatDouble(tmp, newScala);
        }
        return ret;
    }

    public static Double division(Long v1, Long v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1L) {
            ret = MathUtil.division(MathUtil.toDouble(v1), MathUtil.toDouble(v2), newScala);
        }
        return ret;
    }

    public static double division(double v1, int v2, int newScala) {
        double ret = 0.0;
        if (v2 >= 1) {
            ret = v1 / (double)v2;
            ret = MathUtil.formatDouble(ret, newScala);
        }
        return ret;
    }

    public static Double division(Double v1, Double v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1.0 && (ret = Double.valueOf(v1 / v2)) != null) {
            ret = MathUtil.formatDouble(ret, newScala);
        }
        return ret;
    }

    public static Double division(Long v1, Double v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1.0 && (ret = Double.valueOf((double)v1.longValue() / v2)) != null) {
            ret = MathUtil.formatDouble(ret, newScala);
        }
        return ret;
    }

    public static Double division(Double v1, Long v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1L) {
            ret = MathUtil.division(v1, MathUtil.toDouble(v2), newScala);
        }
        return ret;
    }

    public static Long division(Long v1, Long v2) {
        Double d;
        Long ret = null;
        if (v1 != null && v2 != null && v2 >= 1L && (d = Double.valueOf(MathUtil.toDouble(v1) / MathUtil.toDouble(v2))) != null) {
            ret = Math.round(d);
        }
        return ret;
    }

    public static Double divisionNew(Long v1, Long v2, int newScala) {
        Double ret = 0.0;
        if (v1 != null && v2 != null && v2 >= 1L) {
            ret = MathUtil.division(MathUtil.toDouble(v1), MathUtil.toDouble(v2), newScala);
        }
        return ret;
    }

    public static Double add(Double v1, Double v2) {
        if (v1 != null && v2 != null) {
            return v1 + v2;
        }
        if (v1 != null) {
            return v1;
        }
        return v2;
    }

    public static Double mean(Double v1, Double v2, Double weigh) {
        if (v1 != null && v2 != null) {
            return v1 * weigh + v2 * (1.0 - weigh);
        }
        if (v1 != null) {
            return v1;
        }
        return v2;
    }

    public static Long double2long(Double value) {
        Long ret = 0L;
        if (value != null) {
            ret = value.longValue();
        }
        return ret;
    }

    public static Double toDouble(Long v1) {
        Double ret = 0.0;
        if (v1 != null) {
            ret = (double)v1.longValue() + 0.0;
        }
        return ret;
    }

    public static double toddouble(Double v1) {
        double ret = 0.0;
        if (v1 != null) {
            ret = v1 + 0.0;
        }
        return ret;
    }

    public static double formatDouble(double d, int newScala) {
        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
        return bg.doubleValue();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 50; ++i) {
            System.out.println(i + "," + MathUtil.reciprocalOfN(i));
        }
    }

    public static Double log(Double value) {
        Double ret = null;
        if (value != null && value >= 1.0) {
            ret = Math.log(value + 1.0);
        }
        return ret;
    }

    public static Double log(Long value) {
        Double ret = null;
        if (value != null && value >= 1L) {
            ret = Math.log(value + 1L);
        }
        return ret;
    }

    public static Long log1p(Long value) {
        if (value == null || value < 0L) {
            return 0L;
        }
        return Math.min(Math.round(Math.log(value + 1L) / Math.log(2.0)), 10L);
    }

    public static Double sqrt(Double value) {
        Double ret = null;
        if (value != null && value >= 1.0) {
            ret = Math.sqrt(value + 1.0);
        }
        return ret;
    }

    public static double between(double lower, double target, double higher) {
        target = Math.min(target, higher);
        target = Math.max(target, lower);
        return target;
    }
}

