/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTFModelTest {
    public static Logger logger = LoggerFactory.getLogger(LocalTFModelTest.class);
    public static String feature = "{\"f4010010\":\"Mozilla/5.0 (Linux; Android 6.0; CAM-AL00 Build/HONORCAM-AL00; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.132 MQQBrowser/6.2 TBS/044328 Mobile Safari/537.36 mojia/1007010802\",\"f4010091\":\"2\",\"f3010120\":\"1\",\"f2010030\":\"4\",\"f4010090\":\"2\",\"f1010010\":\"11\",\"f5010060\":\"0\",\"f4010041\":\"0\",\"f4010121\":\"21\",\"f2010020\":\"0\",\"f4010080\":\"1\",\"f3010010\":\"5128\",\"f3010130\":\"0\",\"f6010020\":\"com.moji.mjweather\",\"f5010070\":\"0\",\"f4010122\":\"3\",\"f4010031\":\"86\",\"f4010030\":\"6102\",\"f4010110\":\"108.86984\",\"f4010070\":\"0\",\"f2010050\":\"4\",\"f6010010\":\"mojiWeather\",\"f2010010\":\"80\",\"f3010060\":\"60\",\"f6010090\":\"80\",\"f5010080\":\"0\",\"f4010020\":\"111.18.90.230\",\"f3010070\":\"60\",\"f4010060\":\"CAM-AL00\",\"f1010020\":\"3\",\"f5010090\":\"0\",\"f5010050\":\"864233033321573\",\"f5010010\":\"O\",\"f4010100\":\"34.865234\"}";
    public static Map<String, String> featureIdxMap = JSON.parseObject((String)feature);
    private static Queue<LocalTFModel> localTFModelQueue = new LinkedList<LocalTFModel>();
    private static LoadingCache<String, LocalTFModel> localTfModelCache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(3L, TimeUnit.SECONDS).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, LocalTFModel>(){

        public LocalTFModel load(String key) {
            LocalTFModel ltfModel = new LocalTFModel();
            try {
                System.out.println("load");
                String v = "101";
                if (Math.random() > 0.5) {
                    v = "100";
                }
                ltfModel.loadModel(key, v);
            }
            catch (Exception e) {
                logger.error("rspPlugin algo get ltfModel error..." + e);
            }
            try {
                while (localTFModelQueue.size() > 1) {
                    System.out.println("q.size=" + localTFModelQueue.size());
                    LocalTFModel poll = (LocalTFModel)localTFModelQueue.poll();
                    assert (poll != null);
                    poll.close();
                    poll.close();
                }
            }
            catch (Exception e) {
                System.out.println("algo LocalTFModel e\uff1a" + e);
            }
            localTFModelQueue.add(ltfModel);
            return ltfModel;
        }
    });

    public static void main(String[] args) {
        LocalTFModelTest.test6();
    }

    public static void getAllFileName(String path, List<String> listFileName) {
        File file = new File(path);
        if (file.isDirectory()) {
            LocalTFModelTest.listFiles(file);
        }
    }

    public static void listFiles(File directory) {
        File[] listFiles = directory.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            File f = listFiles[i];
            System.out.println(f.getName() + "-" + f.lastModified());
        }
    }

    public static void test2() {
        try {
            LocalTFModel model = new LocalTFModel();
            model.loadModel("/Users/lwj/Desktop/model/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void test1() {
        CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("adx_coder_dqn_v001");
        System.out.println("ctrModel=" + JSON.toJSONString((Object)ctrModel.getUpdateTime()));
        LocalTFModel model = new LocalTFModel();
        try {
            int i;
            model.loadModel("/Users/lwj/Desktop/model");
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            for (i = 0; i < 10; ++i) {
                map.put("A" + i, featureIdxMap);
            }
            System.out.println(JSON.toJSONString((Object)ctrModel.predictWithLocalTF(map, model)));
            for (i = 0; i < 100; ++i) {
                map.put("A" + i, featureIdxMap);
            }
            System.out.println(LocalDateTime.now());
            for (i = 0; i < 10; ++i) {
                ctrModel.predictWithLocalTF(map, model);
            }
            System.out.println(LocalDateTime.now());
            System.out.println();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void test6() {
        CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("adx_coder_dqn_v001");
        System.out.println("ctrModel=" + JSON.toJSONString((Object)ctrModel.getUpdateTime()));
        LocalTFModel model = new LocalTFModel();
        try {
            model.loadModel("/Users/lwj/Desktop/model", "101");
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            map.put("A", featureIdxMap);
            System.out.println(JSON.toJSONString((Object)ctrModel.predictWithLocalTF(map, model)));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void test55() {
        List<Long> tList = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        tList.parallelStream().forEach(a -> LocalTFModelTest.test5(a));
    }

    public static void test5(Long j) {
        System.out.println(j);
        JedisConfig jcOffline = new JedisConfig();
        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);
        CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001", juOffline);
        try {
            int i;
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            HashMap mMap = new HashMap();
            for (i = 0; i < 100; ++i) {
                map.put("A" + i, featureIdxMap);
            }
            System.out.println(LocalDateTime.now());
            for (i = 0; i < 1000; ++i) {
                System.out.println(j + "-" + i);
                Thread.sleep(50L);
                LocalTFModel model = (LocalTFModel)localTfModelCache.get((Object)"/Users/lwj/Desktop/model/");
                ctrModel.predictWithLocalTF(map, model);
            }
            System.out.println(LocalDateTime.now());
            System.out.println();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void test3() {
        FM ctrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_ctr_v007");
        try {
            int i;
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            for (i = 0; i < 100; ++i) {
                map.put("B" + i, featureIdxMap);
            }
            System.out.println(JSON.toJSONString((Object)ctrModel.predicts(map)));
            System.out.println(LocalDateTime.now());
            for (i = 0; i < 1000; ++i) {
                ctrModel.predicts(map);
                Thread.sleep(5000L);
            }
            System.out.println(LocalDateTime.now());
            System.out.println();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void sync1() {
        JedisConfig jcOffline = new JedisConfig();
        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);
        CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001", juOffline);
        System.out.println(ctrModel.getUpdateTime());
        StdCoderModelSaveBo.saveModelCoderByKeyToJedis("mid_act_resplug_coder_v001", ctrModel, juOffline);
    }

    public static void testLoadTF() {
        try {
            HashMap<String, LocalTFModel> map = new HashMap<String, LocalTFModel>();
            for (int i = 0; i < 1000; ++i) {
                LocalTFModel model = new LocalTFModel();
                model.loadModel("/Users/lwj/Desktop/model/");
                model.close();
                map.put("1", model);
                System.out.println(i);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

