package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.*;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import my.com.google.protobuf.ByteString;
import org.apache.commons.lang.StringUtils;

import java.sql.Time;
import java.time.LocalDateTime;
import java.util.*;

import static cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo.jedisUtil;

public class ModelPredictTest {

    public static List<String> modelKeyList = Arrays.asList(
//            "mid_fm_ctr_v501",
//            "mid_fm_ctr_v502",
//            "mid_fm_ctr_v603",
////
////            "mid_fm_cvr_v501",
////            "mid_fm_cvr_v502",
//            "mid_fm_cvr_v603",
////
////            "mid_fm_ctr_v610",
////            "mid_fm_ctr_v611",
////            "mid_fm_ctr_v612",
////            "mid_fm_ctr_v614",
////            "mid_fm_cvr_v610",
////            "mid_fm_cvr_v611",
////            "mid_fm_cvr_v612", // count
////            "mid_fm_cvr_v614", //
////
////
            "mid_fm_ctr_v007"
//            "mid_fm_ctr_v006",
//            "mid_fm_cvr_v003",
//            "mid_fm_cvr_v006",
////
//            "mid_ftrl_fm_ctr_v004",
//
//
//            "mid_ftrl_fm_ctr_v002",
//            "mid_ftrl_fm_ctr_v003",
//            "mid_ftrl_fm_ctr_v004",
//            "mid_ftrl_fm_ctr_v006",
//            "mid_ftrl_fm_ctr_v007"
////            "mid_ftrl_fm_ctr_v008",
//            "mid_ftrl_fm_ctr_v009",
//            "mid_ftrl_fm_ctr_v010",
//            "mid_ftrl_fm_ctr_v011",
////            "mid_ftrl_fm_ctr_v501",
////            "mid_ftrl_fm_ctr_v502",
//            "mid_ftrl_fm_ctr_v611",
//            "mid_ftrl_fm_ctr_v612",
//
//            "mid_ftrl_fm_cvr_v002",
//            "mid_ftrl_fm_cvr_v003",
//            "mid_ftrl_fm_cvr_v004",
//            "mid_ftrl_fm_cvr_v006",
//            "mid_ftrl_fm_cvr_v007",
////            "mid_ftrl_fm_cvr_v008",
//            "mid_ftrl_fm_cvr_v009",
//
//            "mid_ftrl_fm_cvr_v010",
//            "mid_ftrl_fm_cvr_v011",
//            "mid_ftrl_fm_cvr_v012",
////            "mid_ftrl_fm_cvr_v501",
////            "mid_ftrl_fm_cvr_v502",
//            "mid_ftrl_fm_cvr_v611",
//            "mid_ftrl_fm_cvr_v612"


    );

    public static List<String> modelKeyList2 = Arrays.asList(


//            "mid_ftrl_ffm_ctr_v001",
//            "mid_ftrl_ffm_ctr_v002",
//            "mid_ftrl_ffm_ctr_v003",
//            "mid_ftrl_ffm_ctr_v004",
//            "mid_ftrl_ffm_ctr_v004"
//            "mid_ftrl_ffm_cvr_v002",
//            "mid_ftrl_ffm_cvr_v003",
//            "mid_ftrl_ffm_cvr_v004"
            //"mid_ftrl_fm_ctr_v002"


    );


//    public static String feature = "{\"orderId\":\"taw-188284042240239\",\"f608001\":\"1\",\"f113001\":\"04.01.0001\",\"f9913\":\"5\",\"f508002\":\"R9km\",\"f806001\":\"7\",\"f508001\":\"OPPO\",\"f806002\":\"11\",\"f806003\":\"9\",\"f806004\":\"7\",\"f603002\":\"2\",\"f603001\":\"5\",\"f110001\":\"1\",\"f502001\":\"1\",\"f502002\":\"4\",\"f611001\":\"1\",\"f505001\":\"170-2699\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"28867\",\"f102001\":\"02.01.0008\",\"f609001\":\"0\",\"f804004\":\"7\",\"f804003\":\"8\",\"f804002\":\"18\",\"f9930\":\"-1\",\"f804001\":\"12\",\"f9931\":\"-1\",\"f301001\":\"1034\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"203809\",\"advertId\":\"39854\",\"f807002\":\"11\",\"f807001\":\"12\",\"f507001\":\"2\",\"f807004\":\"7\",\"f807003\":\"9\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f9929\":\"-1\",\"f306001\":\"2\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"f206001\":\"262\",\"f504001\":\"OPPO R9km\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"2000\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f805001\":\"12\",\"f805002\":\"12\",\"f805003\":\"9\",\"f805004\":\"7\",\"f602001\":\"1\",\"f205002\":\"39\",\"f205001\":\"30\",\"f404003\":\"workother\",\"f106001\":\"10031\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f101001\":\"38454\",\"f503001\":\"4\",\"time\":\"20181122065021\",\"f302001\":\"1034\",\"f602002\":\"1\"}";

    //    public static String feature = "{\"orderId\":\"taw-336002010251006\",\"f608001\":\"0\",\"f113001\":\"04.01.0006\",\"f9913\":\"6\",\"f508002\":\"NEX A\",\"f806001\":\"7\",\"f508001\":\"vivo\",\"f806002\":\"5\",\"f806003\":\"5\",\"f9916\":\"02.24.0001&3,02.01.0001&2,02.01.0002&3\",\"f806004\":\"3\",\"f9917\":\"02.24.0001&1,02.01.0001&1,02.01.0002&1\",\"f9918\":\"02.24.0001&1,02.01.0001&1,02.01.0002&1\",\"f9919\":\"02.24.0001&7,02.01.0001&8,02.01.0002&7\",\"f660302\":\"4\",\"f603002\":\"4\",\"f603001\":\"4\",\"f550201\":\"null,22&7,24&6,25&3,26&4,27&6,28&7,29&5,162&11,163&4,196&8,471&7,493&1,384&9,188&12,266&1,159&4,30&6,31&7,53&3,10&6\",\"f110001\":\"0\",\"f550202\":\"null,22&3,24&3,25&7,26&1,27&7,28&4,29&7,162&1,163&3,196&7,471&3,384&6,188&1,159&1,30&6,31&3,53&6,10&7\",\"f502001\":\"17\",\"f502002\":\"7\",\"f611001\":\"6\",\"f505001\":\"2700-4499\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"58225\",\"f102001\":\"02.01.0001\",\"f660001\":\"19\",\"f609001\":\"1\",\"f804004\":\"4\",\"f804003\":\"6\",\"f804002\":\"6\",\"f9930\":\"2\",\"f804001\":\"7\",\"f9931\":\"-1\",\"f301001\":\"1759\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,22&1,23&1,24&7,25&16,10&1,11&17,13&2,14&1,15&8,16&4,17&8,18&2,19&3,1&5,2&5,3&8,4&7,5&1,6&2,7&1,8&5,9&6,20&8,21&6\",\"f550101\":\"null,22&7,23&11,24&7,25&9,10&5,11&3,13&5,14&5,15&7,16&11,17&6,18&5,19&7,1&7,2&6,3&6,4&5,5&2,6&5,7&3,8&6,9&7,20&4,21&8\",\"f108001\":\"271430\",\"advertId\":\"41460\",\"f807002\":\"5\",\"f9924\":\"02.24.0001,02.01.0001\",\"f807001\":\"7\",\"f507001\":\"2\",\"f807004\":\"3\",\"f807003\":\"6\",\"f9927\":\"0\",\"f810001\":\"1\",\"f770001\":\"07.19.0001\",\"f9928\":\"0\",\"f810002\":\"0\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0002\",\"f604002\":\"4\",\"f604001\":\"4\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"vivo NEX A\",\"f660102\":\"2\",\"f601001\":\"6\",\"f601002\":\"6\",\"f303001\":\"2000\",\"f550402\":\"null,22&4,188&1,471&5,384&3\",\"f607001\":\"0\",\"f550401\":\"null,22&5,188&11,471&6,384&6\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103\",\"f403004\":\"0\",\"f805001\":\"7\",\"f805002\":\"5\",\"f805003\":\"5\",\"f805004\":\"3\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"450\",\"f205001\":\"22\",\"f701001\":\"1041460\",\"f808002\":\"0_0,02.01.0001_0,02.01.0002_0,02.24.0001_0\",\"f811002\":\"103\",\"f404003\":\"workother\",\"f106001\":\"12079\",\"f660201\":\"0\",\"f8807\":\"1\",\"f808001\":\"0_1,02.01.0001_1,02.01.0002_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f550302\":\"null,1&1,2&3,3&1,16&3,17&4,6&2,19&3,20&8,10&1,21&7\",\"f550301\":\"null,1&8,2&5,3&8,16&9,17&6,6&6,19&7,20&4,10&7,21&3\",\"f101001\":\"41460\",\"f503001\":\"6301\",\"time\":\"20190602172329\",\"f302001\":\"1759\",\"f602002\":\"6\"}";
//    public static String feature = "{\"orderId\":\"taw-336002010251006\",\"f608001\":\"0\",\"f113001\":\"04.01.0006\",\"f9913\":\"6\",\"f508002\":\"NEX A\",\"f806001\":\"7\",\"f508001\":\"vivo\",\"f806002\":\"5\",\"f806003\":\"5\",\"f9916\":\"02.24.0001&3,02.01.0001&2,02.01.0002&3\",\"f806004\":\"3\",\"f9917\":\"02.24.0001&1,02.01.0001&1,02.01.0002&1\",\"f9918\":\"02.24.0001&1,02.01.0001&1,02.01.0002&1\",\"f9919\":\"02.24.0001&7,02.01.0001&8,02.01.0002&7\",\"f660302\":\"4\",\"f603002\":\"4\",\"f603001\":\"4\",\"f550201\":\"null,22&7,24&6,25&3,26&4,27&6,28&7,29&5,162&11,163&4,196&8,471&7,493&1,384&9,188&12,266&1,159&4,30&6,31&7,53&3,10&6\",\"f110001\":\"0\",\"f550202\":\"null,22&3,24&3,25&7,26&1,27&7,28&4,29&7,162&1,163&3,196&7,471&3,384&6,188&1,159&1,30&6,31&3,53&6,10&7\",\"f502001\":\"17\",\"f502002\":\"7\",\"f611001\":\"6\",\"f505001\":\"2700-4499\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"58225\",\"f102001\":\"02.01.0001\",\"f660001\":\"19\",\"f609001\":\"1\",\"f804004\":\"4\",\"f804003\":\"6\",\"f804002\":\"6\",\"f9930\":\"2\",\"f804001\":\"7\",\"f9931\":\"-1\",\"f301001\":\"1759\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,22&1,23&1,24&7,25&16,10&1,11&17,13&2,14&1,15&8,16&4,17&8,18&2,19&3,1&5,2&5,3&8,4&7,5&1,6&2,7&1,8&5,9&6,20&8,21&6\",\"f550101\":\"null,22&7,23&11,24&7,25&9,10&5,11&3,13&5,14&5,15&7,16&11,17&6,18&5,19&7,1&7,2&6,3&6,4&5,5&2,6&5,7&3,8&6,9&7,20&4,21&8\",\"f108001\":\"271430\",\"advertId\":\"41460\",\"f807002\":\"5\",\"f9924\":\"02.24.0001,02.01.0001\",\"f807001\":\"7\",\"f507001\":\"2\",\"f807004\":\"3\",\"f807003\":\"6\",\"f9927\":\"0\",\"f810001\":\"1\",\"f770001\":\"07.19.0001\",\"f9928\":\"0\",\"f810002\":\"0\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0002\",\"f604002\":\"4\",\"f604001\":\"4\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"vivo NEX A\",\"f660102\":\"2\",\"f601001\":\"6\",\"f601002\":\"6\",\"f303001\":\"2000\",\"f550402\":\"null,22&4,188&1,471&5,384&3\",\"f607001\":\"0\",\"f550401\":\"null,22&5,188&11,471&6,384&6\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103\",\"f403004\":\"0\",\"f805001\":\"7\",\"f805002\":\"5\",\"f805003\":\"5\",\"f805004\":\"3\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"450\",\"f205001\":\"22\",\"f701001\":\"1041460\",\"f808002\":\"0_0,02.01.0001_0,02.01.0002_0,02.24.0001_0\",\"f811002\":\"103\",\"f404003\":\"workother\",\"f106001\":\"12079\",\"f660201\":\"0\",\"f8807\":\"1\",\"f808001\":\"0_1,02.01.0001_1,02.01.0002_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f550302\":\"null,1&1,2&3,3&1,16&3,17&4,6&2,19&3,20&8,10&1,21&7\",\"f550301\":\"null,1&8,2&5,3&8,16&9,17&6,6&6,19&7,20&4,10&7,21&3\",\"f101001\":\"41460\",\"f503001\":\"6301\",\"time\":\"20190602172329\",\"f302001\":\"1759\",\"f602002\":\"6\"}";
    public static String feature0 = "{\"orderId\":\"taw-513975513270494\",\"f608001\":\"1\",\"f113001\":\"04.01.0008,04.03.0017\",\"f9913\":\"25\",\"f508002\":\"X21UDA\",\"f806001\":\"2\",\"f508001\":\"vivo\",\"f806002\":\"5\",\"f806003\":\"3\",\"f830101\":\"null,54432_59499,53491_59499,57604_59499\",\"f9916\":\"02.01.0008&5,02.06&5\",\"f806004\":\"3\",\"f830102\":\"null,20619_6209,17074_6209,23374_6209\",\"f9917\":\"02.01.0008&11,02.06&1\",\"f830103\":\"null,07.24.0001_07.12.0051,07.24.0001_07.12.0051,07.24.0001_07.12.0051\",\"f9918\":\"02.01.0008&3,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.01.0008&10,02.06&6\",\"f104001\":\"83089\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"8\",\"f502002\":\"2\",\"f611001\":\"1\",\"f505001\":\"2700-4499\",\"f770102\":\"1\",\"f809001\":\"5\",\"f809002\":\"13\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"51326\",\"f102001\":\"02.20.0002\",\"f830001\":\"54432,53491,57604\",\"f830002\":\"20619,17074,23374\",\"f830003\":\"07.24.0001,07.24.0001,07.24.0001\",\"f830004\":\"8,8,8\",\"f609001\":\"0\",\"f804004\":\"2\",\"f804003\":\"7\",\"f804002\":\"1\",\"f9930\":\"1\",\"f804001\":\"9\",\"f9931\":\"-1\",\"f301001\":\"2041\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&16,23&5,24&16,13&1,14&1,25&17,15&4,16&2,17&10,18&8,19&0,1&2,2&2,3&1,4&1,5&1,6&2,7&1,8&5,9&5,20&6,21&3,10&8\",\"f550101\":\"null,11&8,23&8,24&4,13&3,14&2,25&9,15&6,16&6,17&9,18&7,19&1,1&8,2&5,3&4,4&3,5&2,6&6,7&3,8&6,9&6,20&5,21&6,10&4\",\"f108001\":\"197615\",\"advertId\":\"59499\",\"f807002\":\"3\",\"f9924\":\"02.06\",\"f807001\":\"2\",\"f507001\":\"1\",\"f807004\":\"3\",\"f830111\":\"null,57604_59499\",\"f807003\":\"2\",\"f830112\":\"null,23374_6209\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.12.0051\",\"f830113\":\"null,07.24.0001_07.12.0051\",\"f9928\":\"1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"02.01.0008\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"vivo X21UD A\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"2000\",\"f114001\":\"119\",\"f607001\":\"1\",\"f114002\":\"124\",\"f406001\":\"11\",\"f206002\":\"260\",\"f811001\":\"102,302\",\"f403004\":\"0\",\"f830011\":\"{0=57604, 2=, 3=}\",\"f805001\":\"2\",\"f830012\":\"{0=23374, 2=, 3=}\",\"f805002\":\"5\",\"f830013\":\"{0=07.24.0001, 2=, 3=}\",\"f805003\":\"3\",\"f830014\":\"{0=8, 2=, 3=}\",\"f805004\":\"3\",\"f602001\":\"2\",\"f115001\":\"0\",\"f205002\":\"59\",\"f205001\":\"53\",\"f701001\":\"1059499\",\"f808002\":\"0_13,02.01.0008_13,02.06_0\",\"f811002\":\"102,402\",\"f404003\":\"workother\",\"f106001\":\"6209\",\"f121001\":\"001001\",\"f121002\":\"005001\",\"f121003\":\"false\",\"f121004\":\"003013\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002001\",\"f808001\":\"0_5,02.01.0008_7,02.06_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"9\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&10,23&1,13&0,24&13,25&19,14&0,15&3,16&4,17&0,18&2,19&0,1&2,2&0,3&1,4&0,5&0,6&1,7&0,8&7,9&3,20&1,21&5,10&0\",\"f550301\":\"null,11&4,23&3,13&1,24&3,25&5,14&0,15&5,16&5,17&1,18&3,19&1,1&3,2&1,3&4,4&0,5&1,6&3,7&1,8&3,9&5,20&9,21&5,10&1\",\"f101001\":\"59499\",\"f503001\":\"1301\",\"time\":\"20191217082114\",\"f302001\":\"2041\",\"f602002\":\"2\"}";

    public static String feature = "{\"orderId\":\"taw-513975513270494\",\"f608001\":\"1\",\"f113001\":\"04.01.0008,04.03.0017\",\"f9913\":\"25\",\"f508002\":\"X21UDA\",\"f806001\":\"2\",\"f508001\":\"vivo\",\"f806002\":\"5\",\"f806003\":\"3\",\"f830101\":\"null,54432_59499,53491_59499,57604_59499\",\"f9916\":\"02.01.0008&5,02.06&5\",\"f806004\":\"3\",\"f830102\":\"null,20619_6209,17074_6209,23374_6209\",\"f9917\":\"02.01.0008&11,02.06&1\",\"f830103\":\"null,07.24.0001_07.12.0051,07.24.0001_07.12.0051,07.24.0001_07.12.0051\",\"f9918\":\"02.01.0008&3,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.01.0008&10,02.06&6\",\"f104001\":\"83089\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"8\",\"f502002\":\"2\",\"f611001\":\"1\",\"f505001\":\"2700-4499\",\"f770102\":\"1\",\"f809001\":\"5\",\"f809002\":\"13\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"51326\",\"f102001\":\"02.20.0002\",\"f830001\":\"54432,53491,57604\",\"f830002\":\"20619,17074,23374\",\"f830003\":\"07.24.0001,07.24.0001,07.24.0001\",\"f830004\":\"8,8,8\",\"f609001\":\"0\",\"f804004\":\"2\",\"f804003\":\"7\",\"f804002\":\"1\",\"f9930\":\"1\",\"f804001\":\"9\",\"f9931\":\"-1\",\"f301001\":\"2041\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&16,23&5,24&16,13&1,14&1,25&17,15&4,16&2,17&10,18&8,19&0,1&2,2&2,3&1,4&1,5&1,6&2,7&1,8&5,9&5,20&6,21&3,10&8\",\"f550101\":\"null,11&8,23&8,24&4,13&3,14&2,25&9,15&6,16&6,17&9,18&7,19&1,1&8,2&5,3&4,4&3,5&2,6&6,7&3,8&6,9&6,20&5,21&6,10&4\",\"f108001\":\"197615\",\"advertId\":\"59499\",\"f807002\":\"3\",\"f9924\":\"02.06\",\"f807001\":\"2\",\"f507001\":\"1\",\"f807004\":\"3\",\"f830111\":\"null,57604_59499\",\"f807003\":\"2\",\"f830112\":\"null,23374_6209\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.12.0051\",\"f830113\":\"null,07.24.0001_07.12.0051\",\"f9928\":\"1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"02.01.0008\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"vivo X21UD A\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"2000\",\"f114001\":\"119\",\"f607001\":\"1\",\"f114002\":\"124\",\"f406001\":\"11\",\"f206002\":\"260\",\"f811001\":\"102,302\",\"f403004\":\"0\",\"f830011\":\"{0=57604, 2=, 3=}\",\"f805001\":\"2\",\"f830012\":\"{0=23374, 2=, 3=}\",\"f805002\":\"5\",\"f830013\":\"{0=07.24.0001, 2=, 3=}\",\"f805003\":\"3\",\"f830014\":\"{0=8, 2=, 3=}\",\"f805004\":\"3\",\"f602001\":\"2\",\"f115001\":\"2\",\"f205002\":\"59\",\"f205001\":\"53\",\"f701001\":\"1059499\",\"f808002\":\"0_13,02.01.0008_13,02.06_0\",\"f811002\":\"102,402\",\"f404003\":\"workother\",\"f106001\":\"6209\",\"f121001\":\"001001\",\"f121002\":\"005001\",\"f121003\":\"false\",\"f121004\":\"003013\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002001\",\"f808001\":\"0_5,02.01.0008_7,02.06_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"9\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&10,23&1,13&0,24&13,25&19,14&0,15&3,16&4,17&0,18&2,19&0,1&2,2&0,3&1,4&0,5&0,6&1,7&0,8&7,9&3,20&1,21&5,10&0\",\"f550301\":\"null,11&4,23&3,13&1,24&3,25&5,14&0,15&5,16&5,17&1,18&3,19&1,1&3,2&1,3&4,4&0,5&1,6&3,7&1,8&3,9&5,20&9,21&5,10&1\",\"f101001\":\"59499\",\"f503001\":\"1301\",\"time\":\"20191217082114\",\"f302001\":\"2041\",\"f602002\":\"2\"}";

    public static Map<String, String> featureIdxMap = (Map) JSON.parseObject(feature);


    public static void main(String[] args) {
        try {

//            test7();
//           test2();
//            test1();
//            test11();
//            test9();
            test13();

//            test6();

//            System.out.println();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void test1() {

        List<String> printList = new ArrayList<>();

        for (String key : modelKeyList) {

            try {


                FM model = StdModelSave.getModelByKeyFromJedis(key);
                System.out.println(JSON.toJSONString(model));
                Double ret = model.predict(featureIdxMap);
                printList.add("model=" + key + ".predict = " + ret + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());


            } catch (Exception e) {
                e.printStackTrace();
            }
        }


        printList.forEach(line -> System.out.println(line));
    }


    public static void test2() throws Exception {


        List<String> printList = new ArrayList<>();

        Map<String, Map<String, String>> features = new HashMap<>();
        for (int i = 0; i < 100; i++) {
            String key1 = String.valueOf(i) + "_" + "3456";
            features.put(key1, featureIdxMap);
        }

        System.out.println("featuresSize= " + features.size());

        int cntGig = 0;
        for (String key : modelKeyList2) {

            try {
                long diffTime1 = 0;
                double diffTime2 = 0;
                double diffTime3 = 0;
                int cnt = 0;
                Map<String, Double> ret = new HashMap<>();
                Map<String, Double> ret2 = new HashMap<>();
                ;

                long time1 = System.currentTimeMillis();
//                FFM2 model = StdModelSave.getModelByKeyFromJedisFFM2(key);
//
//                FFM2 model1 = StdModelSave.getModelByKeyFromJedisFFM2(key);

                FFM model2 = StdModelSave.getModelByKeyFromJedisFFM(key);

//                long l1= System.currentTimeMillis();
//                model.predicts(features);
//                System.out.println(System.currentTimeMillis()-l1);
//                long l11=System.currentTimeMillis();
//                model.predicts2(features);
//                System.out.println(System.currentTimeMillis()-l11);
//
//                long l2= System.currentTimeMillis();
//                model1.predicts2(features);
//                System.out.println(System.currentTimeMillis()-l2);
//                long l22=System.currentTimeMillis();
//                model1.predicts(features);
//                System.out.println(System.currentTimeMillis()-l22);

                long l3 = System.currentTimeMillis();
                Map<String, Double> ret1 = model2.predicts2(features);
                System.out.println(System.currentTimeMillis() - l3);

                long l33 = System.currentTimeMillis();
                Map<String, Double> ret12 = model2.predicts(features);
                System.out.println(System.currentTimeMillis() - l33);

                long l4 = System.currentTimeMillis();
                Map<String, Double> ret3 = model2.predicts2(features);
                System.out.println(System.currentTimeMillis() - l4);

                System.out.println("ret1= " + ret1);
                System.out.println("ret12= " + ret12);
                System.out.println("ret3= " + ret3);


//
//                long time2 = System.currentTimeMillis();
//                diffTime1 += time2 - time1;
//                long maxTime=0;
//
//                for (int i=0;i< 1000;i++) {
//                    cnt +=1;
//
//                    long time3 = System.currentTimeMillis();
//                    ret=model.predicts(features);
//                     //ret = model.predict(featureIdxMap);
//                    long time4 = System.currentTimeMillis();
//                     //ret2 = model.predict2(featureIdxMap);
//                   // long time5 = System.currentTimeMillis();
//
//                    //System.out.println("diffTime4_5= "+ (time5- time4) ) ;
//                    diffTime2  += time4 - time3;
//                    if (time4 - time3 >=100) {
//                        cntGig +=1;
//                        System.out.println("diffTime3_4= "+ (time4 - time3)) ;
//                        System.out.println("i= " + i);
//                    }
//
//                    if (time4 - time3 >=maxTime) {
//                        maxTime = time4 - time3;
//                    }
//                   // diffTime3  += time5 - time4;
//                }
//                System.out.println("cnt= " + cnt) ;
//                System.out.println("cntGig= " + cntGig) ;
//                System.out.println("maxTime= "+ maxTime) ;
//                System.out.println("diffTime1= " + diffTime1) ;
//                System.out.println("diffTime2= "+ diffTime2/cnt) ;
//                //System.out.println("diffTime3= "+ diffTime3/cnt) ;
//                System.out.println("ret= " + ret) ;
//                System.out.println("ret2= " + ret2) ;

                //printList.add("model=" + key + ".predict = " + ret + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

                // printList.add("model=" + key + ".predict2 = " + ret2 + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

//                StdModelSave.saveModelByKeyToJedisFFM("mid_ftrl_ffm_cvr_v004",model);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        printList.forEach(line -> System.out.println(line));

    }


    public static void test3() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

            IModel ctrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_bcvr_v010");
            IModel cvrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_bcvr_v010");

            TFServingClient tfServingClient = new TFServingClient("10.222.50.42", 9000, "deepfm-bcvr-102", null);


            ESMM model = new ESMM(ctrModel, cvrModel, tfServingClient, tfServingClient, MutModelType.DEEP);

            Map<String, Map<String, String>> map = new HashMap<>();
            map.put("1", featureIdxMap);

            for (int i = 0; i < 10; i++) {

                System.out.println(1);
                Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

                System.out.println(2);
            }
            Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

            System.out.println(JSON.toJSONString(ret));


        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static void test4() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

            IModel ctrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_ctr_v010");
            IModel cvrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_bcvr_v010");


//            TFServingClient tfServingClient = new TFServingClient("10.50.201.91", 9000, "esmm-001", null);


            ESMM model = new ESMM(ctrModel, cvrModel, null, null, null, null, null, null, MutModelType.NORMAL);

            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 10; i++) {
                map.put("A" + i, featureIdxMap);
            }


            Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

            System.out.println(JSON.toJSONString(ret));
            System.out.println("ctr.size = " + ret.get(PredictResultType.CTR).size());
            System.out.println("cvr.size = " + ret.get(PredictResultType.CVR).size());


        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static void test5() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

            IModel cvrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_bcvr_v007");

            TFServingClient tfServingClient = new TFServingClient("10.50.201.163", 9000, "deepfm-bcvr-002", null);


            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 10; i++) {
                map.put("A" + i, featureIdxMap);
            }


            for (int j = 0; j < 100; j++) {
                try {
                    Map<String, Double> ret = cvrModel.predictWithTF(map, tfServingClient);
                    System.out.println(JSON.toJSONString(ret));
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public static void test6() {

        List<String> printList = new ArrayList<>();
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("10.170.1.131");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {
            String key = "mid_ftrl_fm_bcvr_v007";
            String key2 = "adx_mid_ftrl_fm_ctr_v001";

            FM model = StdModelSave.getModelByKeyFromJedis(key, juOnline);

            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);

            FM model2 = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            Double ret = model2.predict(featureIdxMap);
            printList.add("model=" + key2 + ".predict = " + ret + ",model.UpdateTime = " + model2.getUpdateTime() + ",model_ps = " + model2.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


        printList.forEach(line -> System.out.println(line));
    }

    public static void test7() throws Exception {


        List<String> printList = new ArrayList<>();


        try {


            CODER Model = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_ctr_v001");
            TFServingClient ctrTFServingClient = new TFServingClient("10.50.201.199", 9000, "deepffm-ctr-e2e001", null);


            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 10; i++) {
                map.put("A" + i, featureIdxMap);
            }

            System.out.println(LocalDateTime.now());
            for (int j = 0; j < 100; j++) {
                try {

                    Map<String, Double> ret = Model.predictWithTF(map, ctrTFServingClient);
                    System.out.println(JSON.toJSONString(ret));
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
            System.out.println(LocalDateTime.now());

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test8() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

//            for (int j = 0; j < 10; j++) {


            CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_dcvr_v101");
            CODER cvrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_dcvr_v001");
            IModel ctrFModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_ctr_v010");
            IModel cvrFModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_bcvr_v010");


            for (int j = 0; j < 100; j++) {

                TFServingClient ctrTFServingClient = new TFServingClient("10.222.50.70", 9000, "xdeepfm-ctr-105", null);
                TFServingClient cvrTFServingClient = new TFServingClient("10.50.201.229", 9000, "xdeepfm-bcvr-105", null);

//                ctrTFServingClient = null;
//                cvrTFServingClient = null;


                ESMM model = new ESMM(ctrFModel, cvrFModel, ctrFModel, cvrFModel, ctrTFServingClient, cvrTFServingClient, null, null, MutModelType.DEEP);

                Map<String, Map<String, String>> map = new HashMap<>();

                for (int i = 0; i < 4; i++) {
                    map.put("A" + i, featureIdxMap);
                }


                Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

                System.out.println(JSON.toJSONString(ret));
                System.out.println("ctr.size = " + ret.get(PredictResultType.CTR).size());
                System.out.println("cvr.size = " + ret.get(PredictResultType.CVR).size());


            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static void test9() {

        List<String> printList = new ArrayList<>();
        JedisConfig jcOnline = new JedisConfig();
//        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
//        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
//        jcOnline.setPort(6379);
        jcOnline.setIp("r-bp11fb0d240332c4888.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("quHLkBCa2tVVRQ2");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("test.config.dui88.com");
//        jcOffline.setIp("10.170.1.131");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {
            String key = "adx_coder_dqn_v001";
            String key2 = "adx_coder_dqn_v001";

            CODER model = StdModelSave.getADXCODERModelByKeyFromJedis(key, juOnline);


            System.out.println("sleep,at time=" + model.getUpdateTime());

//            Thread.sleep(15*1000);

//            StdModelSave.saveADXCODERModelByKeyToJedis(key2, model, juOffline);

//            CODER model2 = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
//            Double ret = model2.predict(featureIdxMap);
//            printList.add("model=" + key2 + ".predict = " + ret + ",model.UpdateTime = " + model2.getUpdateTime() + ",model_ps = " + model2.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


        printList.forEach(line -> System.out.println(line));
    }

    public static void test10() {

        List<String> printList = new ArrayList<>();
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("10.172.58.137");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {
            String key = "mid_ftrl_coder_dcvr_v101";
            String key2 = "mid_ftrl_coder_dcvr_v101";

            FM model = StdModelSave.getModelByKeyFromJedis(key, juOnline);
            System.out.println(model);


            StdModelSave.saveModelByKeyToJedis(key2, model, juOffline);

//            CODER model2 = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
//            Double ret = model2.predict(featureIdxMap);
//            printList.add("model=" + key2 + ".predict = " + ret + ",model.UpdateTime = " + model2.getUpdateTime() + ",model_ps = " + model2.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


        printList.forEach(line -> System.out.println(line));
    }

    public static void test11() {

        List<String> printList = new ArrayList<>();
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();


        // 10.172.58.137
//        jcOffline.setIp("10.170.1.131");
        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {
            String key = "mid_ftrl_fm_bcvr_v013";
            String key2 = "mid_act_resplug_coder_v001";

            FM model = StdModelSave.getModelByKeyFromJedis(key, juOffline);
            System.out.println(model.getUpdateTime());


            StdModelSave.saveModelByKeyToJedis(key2, model, juOffline);

            FM model2 = StdModelSave.getModelByKeyFromJedis(key2, juOffline);
            System.out.println(model2.getUpdateTime());
//            Double ret = model2.plredict(featureIdxMap);
//            printList.add("model=" + key2 + ".predict = " + ret + ",model.UpdateTime = " + model2.getUpdateTime() + ",model_ps = " + model2.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


        printList.forEach(line -> System.out.println(line));
    }

    public static void test12() {

        List<String> printList = new ArrayList<>();
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();


        try {

            String key1 = "mid_ftrl_fm_ctr_v342";
            FM model = StdModelSave.getModelByKeyFromJedis(key1, juOnline);
            Map<Integer, Map<Integer, Double>> vector = model.getParamsDo().getVector();
            List<FeatureBaseType> f = model.getFeatureBaseType();
//            System.out.println("aaaa:" + vector);


            String key = "nz_last_model_new_mid_ftrl_fm_ctr_v342_";
            String ret1 = juOnline.get(key);

            String ret2 = StringZIP.unzipString(ret1);
            System.out.println(ret2);
            ArrayList<String> f_names = new ArrayList<>();


            for (String s : ret2.split(",")) {
                if (s.contains("name") && s.split(":").length == 2) {
                    String f_name = s.split(":")[1];
                    f_names.add(f_name);
                }
            }
            System.out.println(JSON.toJSONString(f_names));
//            String modelKey = "mid_ftrl_fm_ctr_v007";
//            ArrayList<String> modelKeyFeatureStrs = new ArrayList<>();
//            String modelKeyFeature = "'" + modelKey + "'" + ": " + "[" + StringUtils.join(f_names, ",") + "]";
//            modelKeyFeatureStrs.add(modelKeyFeature);
//
//
//        String allModelKeyFeature = StringUtils.join(modelKeyFeatureStrs, ",");
//        System.out.println(allModelKeyFeature);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void test13() {

        try {
            //1 编码器获取 缓存
            IModel fm = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_dcvr_v001");
            IModel coderModel0 = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_dcvr_v101");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.93", 9000, "esmm-dcvr-001", null);
            String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"38944\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";


            String featureStr1 = "{\"f142006\":\"4\",\"f142005\":\"23,58,94,10,34,42,67,87,107\",\"f142008\":\"0\",\"f142007\":\"0\",\"f142002\":\"1\",\"f142001\":\"2\",\"f142004\":\"17,62,98,10,29,50,72,82,107\",\"f113001\":\"04.03.0021,04.03.0007,04.01.0003\",\"f142003\":\"23,55,98,11,33,49,67,82,107\",\"f806001\":\"22\",\"f806002\":\"0\",\"f806003\":\"13\",\"f830101\":\"null,42175_65930,64158_65930,64157_65930,67418_65930,67359_65930,58896_65930,58932_65930,60081_65930,64157_65930,60193_65930,42180_65930,42178_65930,42179_65930,66478_65930,64157_65930,50967_65930,66478_65930,66889_65930,64157_65930,50967_65930\",\"f806004\":\"1\",\"f830102\":\"null,6419_30371,23680_30371,23680_30371,18071_30371,31673_30371,8220_30371,8220_30371,8220_30371,23680_30371,8220_30371,6419_30371,6419_30371,6419_30371,30929_30371,23680_30371,18072_30371,30929_30371,323_30371,23680_30371,18072_30371\",\"f830103\":\"null,07.11.0019_07.23.0019,07.08.0055_07.23.0019,07.08.0055_07.23.0019,07.07.0003_07.23.0019,07.24.0001_07.23.0019,07.08.0055_07.23.0019,07.11.0019_07.23.0019,07.11.0019_07.23.0019,07.11.0019_07.23.0019,07.24.0001_07.23.0019,07.08.0055_07.23.0019,07.10.0004_07.23.0019,07.24.0001_07.23.0019,07.24.0013_07.23.0019,07.08.0055_07.23.0019,07.10.0004_07.23.0019,07.23.0008_07.23.0019,07.07.0003_07.23.0019,07.08.0055_07.23.0019,07.10.0004_07.23.0019\",\"f830104\":\"null,11_9,3_9,3_9,16_9,8_9,10_9,3_9,4_9,3_9,17_9,11_9,11_9,11_9,8_9,3_9,8_9,10_9,3_9,9_9,16_9\",\"f104001\":\"95323\",\"f142009\":\"0\",\"f110001\":\"0\",\"f142012\":\"\",\"f142011\":\"0\",\"f142010\":\"0\",\"f770102\":\"1\",\"f770501\":\"0\",\"f141015\":\"\",\"f144009\":\"2\",\"f141016\":\"6\",\"f144007\":\"8\",\"f141018\":\"8\",\"f144008\":\"6\",\"f141011\":\"244\",\"f144005\":\"9\",\"f141012\":\"1,17\",\"f144006\":\"9\",\"f141013\":\"1\",\"f144003\":\"12\",\"f141014\":\"1\",\"f144004\":\"8\",\"f144001\":\"11\",\"f144002\":\"11\",\"f141010\":\"239\",\"f102001\":\"02.06.0003\",\"f660001\":\"9\",\"f804004\":\"8\",\"f804003\":\"12\",\"f804002\":\"15\",\"f804001\":\"19\",\"f144010\":\"1\",\"f807002\":\"13\",\"f807001\":\"19\",\"f807004\":\"8\",\"f830111\":\"null,42175_65930\",\"f807003\":\"12\",\"f830112\":\"null,6419_30371\",\"f810001\":\"null\",\"f770001\":\"07.23.0019\",\"f830113\":\"null,07.11.0019_07.23.0019\",\"f810002\":\"null\",\"f830114\":\"null,11_9\",\"f770401\":\"0\",\"f770402\":\"0\",\"f610001\":\"0\",\"f143010\":\"2\",\"f141004\":\"1010\",\"f141001\":\"赖柔茶叶\",\"f141002\":\"07.23.0019\",\"f141003\":\"0\",\"f805001\":\"22\",\"f805002\":\"0\",\"f805003\":\"13\",\"f805004\":\"1\",\"f115001\":\"0\",\"f701001\":\"1065930\",\"f106001\":\"30371\",\"f121003\":\"null\",\"f660201\":\"0\",\"f143007\":\"9\",\"f143006\":\"8\",\"f143009\":\"5\",\"f143008\":\"7\",\"f143003\":\"10\",\"f143002\":\"12\",\"f112001\":\"05.02.0022,05.02.0008\",\"f143005\":\"10\",\"f143004\":\"11\",\"f143001\":\"12\",\"f101001\":\"65930\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f9601\":\"null\",\"f9602\":\"null\",\"f9603\":\"null\"}";

            String featureStr2 = "{\"f608001\":\"1\",\"f425011\":\"0\",\"f425004\":\"0\",\"f431001\":\"1\",\"f431003\":\"0\",\"f431002\":\"1\",\"f213001\":\"163,109,61,229,25,289,217,181,3,265,241,37\",\"f213002\":\"1537,685,1861,1645,13,457,289,709,397,2833,109,1957,2509,1237,1141,349,2797,2863,2269,1885,853,133\",\"f213003\":\"166,289,1,265,241,37\",\"f213004\":\"1861,1537,289,2866,709\",\"f414003\":\"132,52\",\"f414004\":\"2\",\"f603002\":\"3\",\"f414001\":\"134,58,172,246,183,5,223,203\",\"f603001\":\"3\",\"f414002\":\"133,56,172,244,183,5,222,203\",\"f414007\":\"3\",\"f414008\":\"0\",\"f414005\":\"5\",\"f425012\":\"0\",\"f505001\":\"1100-1699\",\"f809001\":\"8\",\"f809002\":\"2\",\"f413002\":\"134,57,22,174,245,183,6,222,206\",\"f413003\":\"132,52,172,3\",\"f413001\":\"135,58,22,174,247,184,7,225,206\",\"f413006\":\"0\",\"f413007\":\"3\",\"f413004\":\"2\",\"f413005\":\"5\",\"f413008\":\"1\",\"f201001\":\"55374\",\"f609001\":\"1\",\"f306001\":\"2\",\"f415004\":\"6\",\"f415005\":\"5\",\"f415003\":\"132\",\"f415007\":\"11\",\"f206001\":\"262\",\"f504001\":\"V1818CA\",\"f601001\":\"5\",\"f601002\":\"5\",\"f410001\":\"6\",\"f607001\":\"1\",\"f206002\":\"260\",\"f811001\":\"102,202,303,404\",\"f403004\":\"0\",\"f212004\":\"4152,4497,432,4381,1556,3434,240,1020,2066,1971,1420,1609,4516,3684,317,337,488,299,4473,2446,2008,2576,679,147,2958,4402,413,280,32,698,1154,69,945,222,4458,4437,2314,2426,3717,14,811,834,469,261,107,1136,3071,2693,204,2941,639,2234,4231,4535\",\"f212003\":\"260,145,278,50,466,354,185,165,108,330,128,222,232,13,431,393,70\",\"f212002\":\"1931,3549,2731,2446,2958,3055,413,2616,1153,736,906,12,811,469,2693,639,4232,1420,1609,2864,299,1573,3380,184,3110,279,696,945,3984,3718,4156,4381,1971,4517,625,337,4043,146,51,564,3586,4459,4440,1040,2123,4536,241,3681,4400,1988,69,1361,2502,2463,204,4422,2066,1172,4023,1894,1950,2008,2579,3887,1096,125,33,260,107,1136,2940,4498,849,446,1705,489,4475,2810,2331,3434,1020,3833,3092,4250,317,1228,1819,2313,2427,831,2085,3795,2237,1461,431,1552,3605,3475,1775,678,3263,2351,2993,223,3207,2388,3244,3073,508\",\"f212001\":\"261,145,280,32,375,51,469,352,298,451,184,160,108,332,128,223,241,13,432,90,394,69\",\"f9702\":\"0\",\"f602001\":\"13\",\"f205002\":\"35\",\"f205001\":\"25\",\"f211003\":\"158,85,169,25,289,217,109,97,63,206,73,133,145,2,265,241,37\",\"f211002\":\"1213,2233,1717,1537,1861,1921,253,1645,721,565,1,505,289,1693,397,2665,889,1009,1801,181,985,109,1957,169,433,589,2509,2341,2617,2761,1237,2846,205,2545,85,25,349,2257,2809,2797,649,1333,2858,145,2317,2774,1249,37,853,1573,1549,121,2785,1297,733,2533,1189,1225,1261,1621,2449,685,13,157,61,709,1849,2833,529,277,1069,301,2822,1765,1465,2161,637,2413,1945,2677,193,769,1141,1453,1525,517,1309,2389,1405,265,973,2269,421,2053,1477,1885,133,2017,1501,2041,1933,313\",\"f211001\":\"158,85,169,13,229,25,289,217,181,277,109,97,64,205,73,133,145,2,265,49,241,37\",\"f811002\":\"105,302\",\"f404003\":\"workother\",\"f211004\":\"2617,2833,265,2761,973,2161,145,637,1297,1237,889,1009,2846,2317,193,205,301,181,2823,1537,1261,1621,421,85,1861,2773,253,169,13,433,721,37,589,133,2809,2797,1453,1525,2341,1,505,517,289,157,61,709,1933,1693,121,1849,397,1405,2665,2858\",\"f701002\":\"1055374\",\"f426004\":\"0\",\"f432006\":\"0\",\"f432005\":\"0\",\"f503001\":\"2301\",\"f432002\":\"0\",\"f432001\":\"0\",\"f432004\":\"0\",\"f432003\":\"0\",\"f602002\":\"11\",\"f415001\":\"132\",\"f222001\":\"7,73,25\",\"f411001\":\"8\",\"f222003\":\"1,139,47\",\"f222002\":\"7,28\",\"f411003\":\"5\",\"f411002\":\"8\",\"f411005\":\"5\",\"f411004\":\"2\",\"f222005\":\"49829,65514\",\"f222004\":\"1,48\",\"f508002\":\"V1818CA\",\"f508001\":\"\",\"f9916\":\"02.24.0001&9,02.24.0002&9,02.01.0008&11,02.23.0001&9,02.22.0001&11,02.22.0006&10,02.06&10,02.19&11,02.15&11\",\"f9917\":\"02.24.0001&9,02.24.0002&7,02.01.0008&9,02.23.0001&1,02.22.0001&9,02.22.0006&9,02.06&9,02.19&9,02.15&10\",\"f9918\":\"02.24.0001&1,02.24.0002&1,02.01.0008&1,02.23.0001&1,02.22.0001&1,02.22.0006&5,02.06&1,02.19&1,02.15&1\",\"f9919\":\"02.24.0001&11,02.24.0002&10,02.01.0008&4,02.23.0001&5,02.22.0001&3,02.22.0006&12,02.06&5,02.19&5,02.15&13\",\"f502001\":\"17\",\"f502002\":\"5\",\"f611001\":\"4\",\"f9903\":\"0\",\"f434009\":\"0\",\"f434007\":\"0\",\"f434008\":\"0\",\"f434005\":\"0\",\"f434006\":\"0\",\"f434003\":\"0\",\"f434004\":\"0\",\"f434001\":\"0\",\"f434002\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f830001\":\"42175,64158,64157,67418,67359,58896,58932,60081,64157,60193,42180,42178,42179,66478,64157,50967,66478,66889,64157,50967\",\"f830002\":\"6419,23680,23680,18071,31673,8220,8220,8220,23680,8220,6419,6419,6419,30929,23680,18072,30929,323,23680,18072\",\"f830003\":\"07.11.0019,07.08.0055,07.08.0055,07.07.0003,07.24.0001,07.08.0055,07.11.0019,07.11.0019,07.11.0019,07.24.0001,07.08.0055,07.10.0004,07.24.0001,07.24.0013,07.08.0055,07.10.0004,07.23.0008,07.07.0003,07.08.0055,07.10.0004\",\"f433008\":\"0\",\"f830004\":\"11,3,3,16,8,10,3,4,3,17,11,11,11,8,3,8,10,3,9,16\",\"f433006\":\"0\",\"f433007\":\"0\",\"f433004\":\"0\",\"f433005\":\"0\",\"f433002\":\"0\",\"f9930\":\"4\",\"f433003\":\"0\",\"f9931\":\"-1\",\"f301001\":\"20117\",\"f9932\":\"-1\",\"f433001\":\"0\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f221002\":\"14,8,73,49,25\",\"f221001\":\"61,10,13,73,49,109,37,25,85\",\"f108001\":\"324804\",\"f221004\":\"33,13,128,90,52\",\"f221003\":\"109,14,33,128,90,186,68,52,147\",\"f9924\":\"02.23.0001,02.01.0008,02.06,02.19\",\"f210001\":\"158,85,169,13,229,25,289,218,181,277,109,97,63,206,73,133,145,2,265,49,241,37\",\"f507001\":\"4\",\"f210002\":\"1213,2233,1717,1537,1861,1921,253,1645,721,565,1,505,289,1693,397,2665,889,1009,1801,181,985,109,1957,169,433,589,2509,2341,2617,2761,1237,2846,205,2545,85,25,349,2257,2809,2797,649,1333,2858,145,2317,2774,1249,37,853,1573,1549,121,2785,1297,733,2533,1189,1225,1261,1621,2449,685,13,157,61,709,1849,2833,529,277,1069,301,2822,1465,2161,637,2413,2677,193,769,1141,1453,1525,517,1309,2389,1405,265,973,2269,1117,421,2053,1477,1885,133,2017,1501,2041,1933,313\",\"f9927\":\"0\",\"f9928\":\"3\",\"f9929\":\"1\",\"f9921\":\"\",\"f9922\":\"02.22.0006,02.24.0001,02.15\",\"f210003\":\"158,85,169,25,290,217,109,97,62,208,73,133,145,2,265,241,37\",\"f9923\":\"02.22.0001\",\"f9802\":\"0\",\"f210004\":\"2617,2833,265,2761,973,2161,145,637,1297,1237,889,1009,2846,2317,193,205,301,181,2824,1537,1261,1621,421,85,1861,2773,253,169,13,433,721,37,589,133,2809,2798,1453,1525,2341,1,505,517,289,157,1465,61,709,1933,1693,121,1849,397,1405,2665,2858\",\"f604002\":\"3\",\"f226007\":\"1\",\"f226006\":\"1\",\"f226005\":\"1\",\"f604001\":\"3\",\"f226004\":\"0\",\"f226003\":\"0\",\"f226002\":\"10\",\"f501001\":\"Android\",\"f226001\":\"10\",\"f226008\":\"1\",\"f303001\":\"28\",\"f114001\":\"118\",\"f462002\":\"0\",\"f114002\":\"127\",\"f406001\":\"12\",\"f424010\":\"0\",\"f830011\":\"{0=42175, 2=, 3=}\",\"f424001\":\"3\",\"f830012\":\"{0=6419, 2=, 3=}\",\"f424002\":\"2\",\"f830013\":\"{0=07.11.0019, 2=, 3=}\",\"f830014\":\"{0=11, 2=, 3=}\",\"f424004\":\"3\",\"f424005\":\"4\",\"f424006\":\"0\",\"f424007\":\"07.23.0008\",\"f424008\":\"0\",\"f220001\":\"61,10,13,73,49,109,37,25,85\",\"f220002\":\"14,8,73,49,25\",\"f808002\":\"0_2,02.22.0001_1,02.23.0001_0,02.24.0002_1,02.01.0008_1,02.22.0006_5,02.06_1,02.24.0001_1,02.15_1,02.19_1\",\"f423001\":\"5\",\"f423002\":\"2\",\"f423004\":\"3\",\"f506001\":\"1\",\"f423005\":\"5\",\"f434018\":\"0\",\"f423006\":\"0\",\"f423007\":\"07.23.0008\",\"f434016\":\"0\",\"f423008\":\"1\",\"f434017\":\"0\",\"f434014\":\"0\",\"f434015\":\"0\",\"f434012\":\"0\",\"f434013\":\"0\",\"f808001\":\"0_8,02.22.0001_4,02.23.0001_1,02.24.0002_12,02.01.0008_7,02.22.0006_10,02.06_6,02.24.0001_12,02.15_11,02.19_7\",\"f8803\":\"1\",\"f434010\":\"0\",\"f434011\":\"0\",\"f225006\":\"0\",\"f225005\":\"0\",\"f605001\":\"1\",\"f412002\":\"8\",\"f225004\":\"10\",\"f605002\":\"1\",\"f412001\":\"8\",\"f225003\":\"10\",\"f412004\":\"2\",\"f225002\":\"1\",\"f412003\":\"4\",\"f412006\":\"0\",\"f412005\":\"5\",\"f214001\":\"310,209,116,450,47,553,415,353,7,507,462,70\",\"f214002\":\"2960,1313,3586,3159,24,891,554,1359,761,5429,228,3751,4809,2370,2196,678,5360,5485,4355,3614,1637,255\",\"f302001\":\"20117\",\"f214003\":\"310,553,2,507,462,78\",\"f214004\":\"3586,2960,554,5485,1359\"}";


            Map<String, String> featureIdxMap = (Map) JSON.parseObject(featureStr1);

            Map<String, FeatureMapDo> featureMap = new HashMap<>();
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(featureIdxMap);


            Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(featureStr2);

            Map<String, FeatureMapDo> featureMap2 = new HashMap<>();
            featureMapDo.setStaticFeatureMap(featureIdxMap2);


            featureMap.put("Q", featureMapDo);


            Map<String, Map<String, String>> map = new HashMap<>();
            map.put("a", featureIdxMap);

            CODER coderModel = (CODER) coderModel0;
            DCVR dcvr = new DCVR(fm, coderModel, tfServingClient);


            for (int i = 0; i < 100; i++) {
                System.out.println(coderModel.getUpdateTime());
                System.out.println(JSON.toJSONString(dcvr.predictDCvrAndTF(featureMap)));
//                System.out.println(JSON.toJSONString(coderModel.predictWithTF(map, tfServingClient)));
//                System.out.println(JSON.toJSONString(coderModel.getCoderMap().get("f225005")));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }


    }


}
