package cn.com.duiba.nezha.alg.example.example.bid;

import cn.com.duiba.nezha.alg.alg.advert.BidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.example.util.StatSyncBo;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidControlTest {


    @Test
    public void coldControl() {


//        OcpxControlModel ocpxControlModel = StatSyncBo.readModelFromRedis("strategy_stat_model_v001");
        OcpxControlModel ocpxControlModel = new OcpxControlModel();
//        System.out.println(ocpxControlModel.getOcpxControlSubModel(67078L, 166949L).getDeepControlParams());
//

        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        adBidParamsDo.setFee(170L);
        adBidParamsDo.setFactor(1.0);

        Long advertId = 72698L;
        Long slotId = 312089L;
        Long cpcFee = 60L;

        AdControlParams adControlParams = ocpxControlModel.getAdSlotControlParams(advertId, slotId);

        SlotControlParams slotControlParams = ocpxControlModel.getSlotControlParams(slotId);

        System.out.println("adControlParams=" + JSON.toJSONString(adControlParams));
        System.out.println("slotControlParams=" + JSON.toJSONString(slotControlParams));


        Map<Long, Long> ret = new HashMap<>();
        for (int i = 0; i < 100; i++) {
            BidControl.coldControl(adBidParamsDo, adControlParams, slotControlParams, cpcFee);

            Long fee = adBidParamsDo.getFee();

            ret.put(fee, ret.getOrDefault(fee, 0L) + 1L);

            adBidParamsDo.setFee(170L);
        }

        System.out.println(JSON.toJSONString(ret));
    }


    @Test
    public void deepControl() {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();

        adBidParamsDo.setDeepControlType(1);
        adBidParamsDo.setDeepFee(100 * 100L);
        adBidParamsDo.setFee(100L);
        adBidParamsDo.setAbTestId(2);

        DeepControlParams params = new DeepControlParams();
        params.setDeepFactor(0.7);
        DeepControlParams slotParams = new DeepControlParams();
        params.setDeepFactor(0.6);

        BidControl.deepControl(adBidParamsDo, params, slotParams);
        System.out.println(JSON.toJSONString(adBidParamsDo));
    }

    @Test
    public void test() {

        for (int s = 3; s < 40; s++) {

            String line = s + ":";

            boolean status = false;
            int a = 0;
            String result = "";
            for (int i = 1; i < 21; i++) {

                int j = s - i;

                if (j <= i || j > 20) {
                    continue;
                }

                boolean type = isOnePPSet(i, j);

                if (!type) {
                    a++;
                    result = "[" + i + "," + j + "]";
                }

                line += "(" + i + "," + j + "," + i * j + "," + type + "),";
            }
            if (a == 1) {
                status = true;
            } else {
                result = "";
            }
            System.out.println(status + ":" + result + ":" + line);
        }
    }


    public boolean isOnePPSet(int x, int y) {

        int s = x * y;
        int a = (int) Math.sqrt(s);
        int cnt = 0;
        if (s < 20) {
            cnt++;
        }


        for (int i = 2; i <= a; i++) {
            if (s % i == 0 && s / i <= 20) {
                cnt++;
                if (cnt > 1) {
                    return false;
                }

            }
        }
        return true;
    }


}
