package cn.com.duiba.nezha.alg.example.example.bid;

import cn.com.duiba.nezha.alg.alg.advert.BidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.example.util.StatSyncBo;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;

public class BidControlTest {


    @Test
    public void coldControl() {


        OcpxControlModel ocpxControlModel = StatSyncBo.readModelFromRedis("strategy_stat_model_v001");


        System.out.println(ocpxControlModel.getUpdateTime());


        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        adBidParamsDo.setFee(170L);
        adBidParamsDo.setFactor(1.0);

        Long advertId = 72499L;
        Long slotId = 312089L;
        Long cpcFee = 60L;

        AdControlParams adControlParams = ocpxControlModel.getAdSlotControlParams(advertId, slotId);

        SlotControlParams slotControlParams = ocpxControlModel.getSlotControlParams(slotId);

        System.out.println("adControlParams=" + JSON.toJSONString(adControlParams));
        System.out.println("slotControlParams=" + JSON.toJSONString(slotControlParams));


        Map<Long, Long> ret = new HashMap<>();
        for (int i = 0; i < 100; i++) {
            BidControl.coldControl(adBidParamsDo, adControlParams, slotControlParams, cpcFee);

            Long fee = adBidParamsDo.getFee();

            ret.put(fee, ret.getOrDefault(fee, 0L) + 1L);

            adBidParamsDo.setFee(170L);
        }

        System.out.println(JSON.toJSONString(ret));
    }


    @Test
    public void deepControl() {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();

        adBidParamsDo.setDeepControlType(1);
        adBidParamsDo.setDeepFee(100 * 100L);
        adBidParamsDo.setFee(100L);
        adBidParamsDo.setAbTestId(2);

        DeepControlParams params = new DeepControlParams();
        params.setDeepFactor(0.7);
        DeepControlParams slotParams = new DeepControlParams();
        params.setDeepFactor(0.6);

        BidControl.deepControl(adBidParamsDo, params, slotParams);
        System.out.println(JSON.toJSONString(adBidParamsDo));
    }
}
