/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.recall.params.TupleParam;
import cn.com.duiba.nezha.alg.alg.recallcompare.param.FilterParam;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ParamSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveRecallParamByKeyToJedis(String modelKey, Map<String, TupleParam> param, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, param})) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = modelKey;
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);
            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, TupleParam> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        HashMap<String, TupleParam> ret = new HashMap<String, TupleParam>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = modelKey;
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject((String)ret1);
            jsonObject.forEach((k, v) -> {
                TupleParam cfr_ignored_0 = (TupleParam)ret.put((String)k, (TupleParam)JSON.parseObject((String)v.toString(), TupleParam.class));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveFilterParamByKeyToJedis(String modelKey, FilterParam param, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, param})) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = modelKey;
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)param);
            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FilterParam getFilterParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        FilterParam ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = modelKey;
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            ret = (FilterParam)JSON.parseObject((String)ret1, FilterParam.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, TupleParam> paramMap = new HashMap<String, TupleParam>();
        TupleParam tupleParamA = new TupleParam();
        tupleParamA.getFilterParam().setVectorActiveTrade(Arrays.asList("16"));
        tupleParamA.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamA.getCombineParam().setRecallNumMap((Map)ImmutableMap.of((Object)2, (Object)8));
        paramMap.put("expA", tupleParamA);
        TupleParam tupleParamB = new TupleParam();
        tupleParamB.getFilterParam().setVectorActiveTrade(Arrays.asList("15"));
        tupleParamB.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamB.getCombineParam().setRecallNumMap((Map)ImmutableMap.of((Object)2, (Object)8));
        paramMap.put("expB", tupleParamB);
        TupleParam tupleParamC = new TupleParam();
        tupleParamC.getFilterParam().setVectorActiveTrade(Arrays.asList("15", "16", "21", "9"));
        tupleParamC.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamC.getCombineParam().setRecallNumMap((Map)ImmutableMap.of((Object)2, (Object)16));
        paramMap.put("expC", tupleParamC);
        ParamSaver.saveRecallParamByKeyToJedis("NZ_K86_recall_params", paramMap, jedisUtil);
        System.out.println(JSONObject.toJSONString(paramMap));
        Map<Object, Object> paramMapB = new HashMap();
        paramMapB = ParamSaver.getRecallParamByKeyFromJedis("NZ_K86_recall_params", jedisUtil);
        System.out.println(paramMapB);
    }
}

