/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.example.util.MongoUtil;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import java.util.HashMap;

public class StdModelSave {
    private static String getLastModelKey(String modelKey) {
        return "nz_last_model_new_" + modelKey + "_";
    }

    public static void saveModelByKeyToMD(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FM> map = new HashMap<String, FM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FFM> map = new HashMap<String, FFM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromMDFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

