package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class NdAdvertParamsSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveNdAdvertParamByKeyToJedis(String modelKey,
                                                     Map<String, NdAdvertParams> param, JedisUtil ju) {
        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, NdAdvertParams> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        Map<String,NdAdvertParams> ret = new HashMap<>();

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = modelKey;
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject(ret1);

            jsonObject.forEach((k, v) -> ret.put(k, JSON.parseObject(v.toString(), NdAdvertParams.class)));

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static void main(String[] args) {
        Map<String, NdAdvertParams> paramsMap = new HashMap<>();
        NdAdvertParams ndAdvertParams = new NdAdvertParams();

        ndAdvertParams.setClickConfidenceThreshold(5000);
        ndAdvertParams.setSepStageThreshold(300);
        ndAdvertParams.setColdStartThreshold1(50);
        ndAdvertParams.setColdStartThreshold2(100);
        ndAdvertParams.setColdStartThreshold3(150);
        ndAdvertParams.setAppConvertThreshold(50);
        ndAdvertParams.setAppCVRThreshold(0.03);
        ndAdvertParams.setAppConsumeThreshold(500.0);
        ndAdvertParams.setExposeConfidenceThreshold(4000);
        ndAdvertParams.setExposeConsumePercentThreshold(0.1);
        ndAdvertParams.setExposeConfidenceThreshold2(600);

        ndAdvertParams.setMinDimStatsCvrThreshold(0.01);

        ndAdvertParams.setClickConfidenceThresholdSet2(20000);
        ndAdvertParams.setSepStageThresholdSet2(1200);
        ndAdvertParams.setColdStartThresholdSet4(200);
        ndAdvertParams.setColdStartThresholdSet5(400);
        ndAdvertParams.setColdStartThresholdSet6(600);
        ndAdvertParams.setExposeConfidenceThresholdSet3(20000);
//        ndAdvertParams.setExposeConfidenceThresholdSet4(30000);
        ndAdvertParams.setExposeConsumePercentThresholdSet2(0.1);
        ndAdvertParams.setExposeConfidenceThresholdSet5(2000);

        paramsMap.put("ndAdvertParams", ndAdvertParams);

        saveNdAdvertParamByKeyToJedis("NZ_K86_cold_expose",paramsMap,jedisUtil);
        System.out.println(JSONObject.toJSONString(paramsMap));

        Map<String, NdAdvertParams> paramMap=new HashMap<String,NdAdvertParams>();
        paramMap=getRecallParamByKeyFromJedis("NZ_K86_cold_expose",jedisUtil);
        System.out.println(paramMap);

    }

}