/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class NdAdvertParamsSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveNdAdvertParamByKeyToJedis(String modelKey, NdAdvertParams param, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, param})) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = modelKey;
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)param);
            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, NdAdvertParams> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        HashMap<String, NdAdvertParams> ret = new HashMap<String, NdAdvertParams>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = modelKey;
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject((String)ret1);
            jsonObject.forEach((k, v) -> {
                NdAdvertParams cfr_ignored_0 = (NdAdvertParams)ret.put((String)k, (NdAdvertParams)JSON.parseObject((String)v.toString(), NdAdvertParams.class));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap paramsMap = new HashMap();
        NdAdvertParams ndAdvertParams = new NdAdvertParams();
        ndAdvertParams.setAppConvertThreshold(Integer.valueOf(50));
        ndAdvertParams.setAppCVRThreshold(Double.valueOf(0.017));
        ndAdvertParams.setAppConsumeThreshold(Double.valueOf(250000.0));
        ndAdvertParams.setAppTriDayConsumeThreshold(Double.valueOf(80000.0));
        ndAdvertParams.setClickConfidenceThreshold(Integer.valueOf(5000));
        ndAdvertParams.setSepStageThreshold(Integer.valueOf(300));
        ndAdvertParams.setColdStartThreshold1(Integer.valueOf(50));
        ndAdvertParams.setColdStartThreshold2(Integer.valueOf(100));
        ndAdvertParams.setColdStartThreshold3(Integer.valueOf(150));
        ndAdvertParams.setExposeConfidenceThreshold(Integer.valueOf(4000));
        ndAdvertParams.setExposeConsumePercentThreshold(Double.valueOf(0.1));
        ndAdvertParams.setExposeConfidenceThreshold2(Integer.valueOf(600));
        ndAdvertParams.setMinDimStatsCvrThreshold(Double.valueOf(0.01));
        ndAdvertParams.setClickConfidenceThresholdSet2(Integer.valueOf(20000));
        ndAdvertParams.setSepStageThresholdSet2(Integer.valueOf(1200));
        ndAdvertParams.setColdStartThresholdSet4(Integer.valueOf(200));
        ndAdvertParams.setColdStartThresholdSet5(Integer.valueOf(400));
        ndAdvertParams.setColdStartThresholdSet6(Integer.valueOf(600));
        ndAdvertParams.setExposeConfidenceThresholdSet3(Integer.valueOf(20000));
        ndAdvertParams.setExposeConsumePercentThresholdSet2(Double.valueOf(0.1));
        ndAdvertParams.setExposeConfidenceThresholdSet5(Integer.valueOf(2000));
        ndAdvertParams.setExposureUpperBound1(Double.valueOf(1.21));
        ndAdvertParams.setExposureK1(Double.valueOf(-3.5 * Math.pow(10.0, -4.0)));
        ndAdvertParams.setExposureUpperBound2(Double.valueOf(1.2));
        ndAdvertParams.setExposureK2(Double.valueOf(-1.0 * Math.pow(10.0, -4.0)));
        ndAdvertParams.setRankUpperBound(Double.valueOf(1.0));
        NdAdvertParamsSaver.saveNdAdvertParamByKeyToJedis("NZ_K86_cold_expose", ndAdvertParams, jedisUtil);
        System.out.println(JSONObject.toJSONString((Object)ndAdvertParams));
    }
}

