/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AdvertSupportParamsSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveAdvertSupportParamsByKeyToJedis(String modelKey, SupportParams param, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, param})) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = modelKey;
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)param);
            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, SupportParams> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        HashMap<String, SupportParams> ret = new HashMap<String, SupportParams>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = modelKey;
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject((String)ret1);
            jsonObject.forEach((k, v) -> {
                SupportParams cfr_ignored_0 = (SupportParams)ret.put((String)k, (SupportParams)JSON.parseObject((String)v.toString(), SupportParams.class));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap paramsMap = new HashMap();
        SupportParams params = new SupportParams();
        ArrayList<Double> supportRatioBucket = new ArrayList<Double>();
        supportRatioBucket.add(0.0);
        supportRatioBucket.add(0.1);
        supportRatioBucket.add(0.2);
        supportRatioBucket.add(0.3);
        supportRatioBucket.add(0.5);
        supportRatioBucket.add(0.8);
        supportRatioBucket.add(1.0);
        ArrayList<Double> supportRatioWeight = new ArrayList<Double>();
        supportRatioWeight.add(1.0);
        supportRatioWeight.add(0.9);
        supportRatioWeight.add(0.8);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.3);
        ArrayList<Double> rankRatioBucket = new ArrayList<Double>();
        rankRatioBucket.add(0.5);
        rankRatioBucket.add(0.6);
        rankRatioBucket.add(0.7);
        rankRatioBucket.add(0.8);
        rankRatioBucket.add(0.9);
        ArrayList<Double> rankRatioWeight = new ArrayList<Double>();
        rankRatioWeight.add(0.5);
        rankRatioWeight.add(0.6);
        rankRatioWeight.add(0.8);
        rankRatioWeight.add(1.0);
        rankRatioWeight.add(1.1);
        params.setSupportRatioBucket(supportRatioBucket);
        params.setSupportRatioWeight(supportRatioWeight);
        params.setRankRatioBucket(rankRatioBucket);
        params.setRankRatioWeight(rankRatioWeight);
        params.setCostRatio(Double.valueOf(1.25));
        params.setCons(Double.valueOf(0.8));
        params.setConvs(Long.valueOf(100L));
        params.setConv(Long.valueOf(50L));
        AdvertSupportParamsSaver.saveAdvertSupportParamsByKeyToJedis("NZ_K86_new_support", params, jedisUtil);
        System.out.println(JSONObject.toJSONString((Object)params));
        Map<Object, Object> paramMap = new HashMap();
        paramMap = AdvertSupportParamsSaver.getRecallParamByKeyFromJedis("NZ_K86_new_support", jedisUtil);
        System.out.println(paramMap);
    }
}

