package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdvertSupportParamsSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveAdvertSupportParamsByKeyToJedis(String modelKey,
                                                           SupportParams param, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, SupportParams> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        Map<String,SupportParams> ret = new HashMap<>();

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = modelKey;
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject(ret1);

            jsonObject.forEach((k, v) -> ret.put(k, JSON.parseObject(v.toString(), SupportParams.class)));

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static void main(String[] args) {
        Map<String, SupportParams> paramsMap = new HashMap<>();
        SupportParams params = new SupportParams();

        List<Double> supportRatioBucket =  new ArrayList<>();
        supportRatioBucket.add(0.0);
        supportRatioBucket.add(0.1);
        supportRatioBucket.add(0.2);
        supportRatioBucket.add(0.3);
        supportRatioBucket.add(0.5);
        supportRatioBucket.add(0.8);
        supportRatioBucket.add(1.0);

        List<Double>  supportRatioWeight = new ArrayList<>();
        supportRatioWeight.add(1.0);
        supportRatioWeight.add(0.9);
        supportRatioWeight.add(0.8);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.3);

        List<Double> rankRatioBucket =  new ArrayList<>();
        rankRatioBucket.add(0.5);
        rankRatioBucket.add(0.6);
        rankRatioBucket.add(0.7);
        rankRatioBucket.add(0.8);
        rankRatioBucket.add(0.9);

        List<Double>  rankRatioWeight = new ArrayList<>();
        rankRatioWeight.add(0.5);
        rankRatioWeight.add(0.6);
        rankRatioWeight.add(0.8);
        rankRatioWeight.add(1.0);
        rankRatioWeight.add(1.1);

        params.setSupportRatioBucket(supportRatioBucket);
        params.setSupportRatioWeight(supportRatioWeight);
        params.setRankRatioBucket(rankRatioBucket);
        params.setRankRatioWeight(rankRatioWeight);
        params.setCostRatio(1.25);
        params.setCons(0.8);
        params.setConvs(100L);
        params.setConv(50L);


        saveAdvertSupportParamsByKeyToJedis("NZ_K86_new_support",params,jedisUtil);
        System.out.println(JSONObject.toJSONString(params));

        Map<String, SupportParams> paramMap=new HashMap<String,SupportParams>();
        paramMap=getRecallParamByKeyFromJedis("NZ_K86_new_support",jedisUtil);
        System.out.println(paramMap);

    }

}